/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.vehicle.collisions.GJKResult;
import com.paneedah.weaponlib.vehicle.collisions.OBBCollider;
import com.paneedah.weaponlib.vehicle.collisions.OreintedBB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class RopeSimulation {
    public ArrayList<Point> points = new ArrayList();
    public ArrayList<Stick> sticks = new ArrayList();
    public HashMap<Point, Vec3d> originalPos = new HashMap();

    public void printPoints() {
        for (Point p : this.points) {
            System.out.println(p.name + "(" + this.points.indexOf(p) + ")");
        }
    }

    public Vec3d getPointDifference(int index) {
        return this.points.get((int)index).pos.func_178788_d(this.originalPos.get(this.points.get(index)));
    }

    public void connect(Point a, Point b) {
        if (!this.points.contains(a)) {
            this.originalPos.put(a, a.pos);
            this.points.add(a);
        }
        if (!this.points.contains(b)) {
            this.originalPos.put(b, b.pos);
            this.points.add(b);
        }
        this.sticks.add(new Stick(a, b));
    }

    public void connectC3(Point a, Point b, double len) {
        if (!this.points.contains(a)) {
            this.originalPos.put(a, a.pos);
            this.points.add(a);
        }
        if (!this.points.contains(b)) {
            this.originalPos.put(b, b.pos);
            this.points.add(b);
        }
        Stick s = new Stick(a, b);
        s.c3Constraint = true;
        s.length = (float)len;
        this.sticks.add(s);
    }

    public void generateChain(double totalLength, int pieces) {
        Point prev = new Point(new Vec3d(0.0, 0.0, 0.0), true);
        this.points.add(prev);
        for (int r = 1; r < pieces + 1; ++r) {
            double yOffset = totalLength * ((double)r / (double)pieces);
            Point newPoint = new Point(new Vec3d(-yOffset, 0.0, 0.0), false);
            this.points.add(newPoint);
            prev = newPoint;
        }
        this.autoSticks();
        System.out.println("----------START----------");
        for (Stick stick : this.sticks) {
            System.out.println(stick.pointA.pos + " | " + stick.pointB.pos);
        }
        System.out.println("----------END----------");
    }

    public void newPoint(Vec3d pos, boolean locked) {
        this.points.add(new Point(pos, locked));
    }

    public void autoSticks() {
        for (int p = 0; p < this.points.size() - 1; ++p) {
            Stick stick = new Stick(this.points.get(p), this.points.get(p + 1));
            this.sticks.add(stick);
        }
    }

    public void simulate(double dt) {
        for (Point p : this.points) {
            if (p.locked) continue;
            Vec3d posBeforeUpdate = p.pos;
            p.pos = p.pos.func_178787_e(p.pos.func_178788_d(p.prevPos));
            p.pos = p.pos.func_178787_e(new Vec3d(0.0, -1.0, 0.0).func_186678_a(dt * dt));
            double belowHeight = -4.0;
            AxisAlignedBB box = new AxisAlignedBB(-0.1, -0.1, -0.1, 0.1, 0.1, 0.1);
            box = box.func_186662_g(0.1);
            box = box.func_191194_a(p.pos);
            List i = ClientProxy.MC.field_71441_e.func_184144_a(null, box);
            for (AxisAlignedBB b : i) {
                if (!(b.field_72337_e < p.pos.field_72448_b)) continue;
                GJKResult result = OBBCollider.areColliding(OreintedBB.fromAABB(box), OreintedBB.fromAABB(b));
                posBeforeUpdate = posBeforeUpdate.func_178788_d(p.pos).func_186678_a(0.01).func_178787_e(p.pos);
                p.pos = p.pos.func_178787_e(result.separationVector.func_186678_a(-result.penetrationDepth));
            }
            p.prevPos = posBeforeUpdate;
        }
        for (int i = 0; i < 3; ++i) {
            for (Stick stick : this.sticks) {
                if (stick.c3Constraint && stick.pointA.pos.func_72438_d(stick.pointB.pos) > (double)stick.length) continue;
                Vec3d stickCentre = stick.pointA.pos.func_178787_e(stick.pointB.pos).func_186678_a(0.5);
                Vec3d stickDir = stick.pointA.pos.func_178788_d(stick.pointB.pos).func_72432_b();
                if (!stick.pointA.locked) {
                    stick.pointA.pos = stickCentre.func_178787_e(stickDir.func_186678_a((double)stick.length).func_186678_a(0.5));
                }
                if (stick.pointB.locked) continue;
                stick.pointB.pos = stickCentre.func_178788_d(stickDir.func_186678_a((double)stick.length).func_186678_a(0.5));
            }
        }
    }

    public void render(double x, double y, double z) {
    }

    public static class Stick {
        public Point pointA;
        public Point pointB;
        public float length;
        public boolean c3Constraint = false;

        public Stick(Point a, Point b) {
            this.pointA = a;
            this.pointB = b;
            this.length = (float)a.pos.func_72438_d(b.pos);
        }
    }

    public static class Point {
        public Vec3d pos = Vec3d.field_186680_a;
        public Vec3d prevPos = Vec3d.field_186680_a;
        public boolean locked = false;
        public String name = "";

        public Point(Vec3d pos) {
            this.pos = pos;
            this.prevPos = pos;
        }

        public Point(String name, Vec3d pos, boolean locked) {
            this.name = name;
            this.pos = pos;
            this.prevPos = pos;
            this.locked = locked;
        }

        public Point(Vec3d pos, boolean locked) {
            this.pos = pos;
            this.prevPos = pos;
            this.locked = locked;
        }
    }
}

