/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.UniversalObject;
import com.paneedah.weaponlib.Exposure;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class LightExposure
extends UniversalObject
implements Exposure {
    private long lastExposureTimestamp;
    private long maxDuration;
    private float totalDose = 1.0f;
    private float decayFactor = 0.995f;

    public LightExposure() {
    }

    public LightExposure(long lastExposureTimestamp, long maxDuration, float dose, float decayFactor) {
        this.lastExposureTimestamp = lastExposureTimestamp;
        this.maxDuration = maxDuration;
        this.totalDose = dose;
        this.decayFactor = decayFactor;
    }

    public float getTotalDose() {
        return this.totalDose;
    }

    public void setTotalDose(float totalDose) {
        this.totalDose = totalDose;
    }

    @Override
    public boolean isEffective(World world) {
        return this.totalDose > 3.0E-4f && world.func_82737_E() - this.lastExposureTimestamp <= this.maxDuration;
    }

    @Override
    public void update(Entity entity) {
        this.totalDose *= this.decayFactor;
    }

    @Override
    public void write(ByteBuf byteBuf) {
        super.write(byteBuf);
        byteBuf.writeLong(this.lastExposureTimestamp);
        byteBuf.writeFloat(this.totalDose);
    }

    @Override
    public void read(ByteBuf byteBuf) {
        super.read(byteBuf);
        this.lastExposureTimestamp = byteBuf.readLong();
        this.totalDose = byteBuf.readFloat();
    }

    @Override
    public void updateFrom(Exposure otherExposure) {
        if (otherExposure instanceof LightExposure) {
            LightExposure other = (LightExposure)otherExposure;
            this.lastExposureTimestamp = other.lastExposureTimestamp;
            this.totalDose = other.totalDose;
        }
    }

    @Override
    public long getLastSyncTimestamp() {
        return 0L;
    }
}

