/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.mwc.renderer.StaticModelSourceRenderer;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.ModelSource;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.render.IHasModel;
import com.paneedah.weaponlib.render.modelrepo.ServerGearModelHookRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class ItemVest
extends Item
implements ISpecialArmor,
ModelSource,
IModernCraftingRecipe,
IHasModel {
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
    private int size;
    private final int damageReduceAmount;
    private int durability;
    private double percentDamageBlocked;
    private CraftingEntry[] modernRecipe;
    private CraftingGroup craftGroup;
    public ModelBiped model;
    public String modelFileString;
    public String textureName;

    public String getModelFileString() {
        return this.modelFileString;
    }

    public String getTextureName() {
        return this.textureName;
    }

    public ItemVest(ModContext context, double percentDamageBlocked, int durability) {
        this.percentDamageBlocked = percentDamageBlocked;
        this.damageReduceAmount = 1;
        this.durability = durability;
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, tooltip, flagIn);
        double formattedDouble = (double)Math.round(this.percentDamageBlocked * 10000.0) / 100.0;
        tooltip.add(String.format("%sDamage Blocked: %s%s%%", TextFormatting.GREEN, TextFormatting.GRAY, formattedDouble));
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @Override
    public List<Tuple<ModelBase, String>> getTexturedModels() {
        return this.texturedModels;
    }

    @Override
    public CustomRenderer<?> getPostRenderer() {
        return null;
    }

    public double getDamageBlocked() {
        return this.percentDamageBlocked;
    }

    public int getSize() {
        return this.size;
    }

    private static String addFileExtension(String s, String ext) {
        return s != null && !s.endsWith(ext) ? s + ext : s;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack vestStack, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, this.percentDamageBlocked, 2000);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)(this.percentDamageBlocked * 10.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    @Override
    public CraftingEntry[] getModernRecipe() {
        return this.modernRecipe;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public CraftingGroup getCraftingGroup() {
        return this.craftGroup;
    }

    @Override
    public void setCraftingRecipe(CraftingEntry[] recipe) {
        this.modernRecipe = recipe;
    }

    @Override
    public void setCraftingGroup(CraftingGroup group) {
        this.craftGroup = group;
    }

    @Override
    public void registerModels() {
    }

    public static class Builder {
        private String name;
        private CreativeTabs tab;
        private ModelBase model;
        private String textureName;
        private ModelSourceTransforms transforms = ModelSourceTransforms.builder().entityPositioning(() -> new Transform().withPosition(-0.5, -1.75, 0.5).withScale(1.0, 1.0, 1.0).doGLDirect()).inventoryPositioning(() -> new Transform().withPosition(-0.15, -4.15, 0.35).withRotation(18.0, -50.0, 0.0).withScale(2.9, 2.9, 2.9).doGLDirect()).build();
        private String modelFileString;
        private String properTextureName;
        private int durability;
        private int damageReduceAmount;
        private double percentDamageBlocked;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDamageReduceAmount(int damageReduceAmount) {
            this.damageReduceAmount = damageReduceAmount;
            return this;
        }

        public Builder withPercentDamageBlocked(double ratio) {
            this.percentDamageBlocked = ratio;
            return this;
        }

        public Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withTab(CreativeTabs tab) {
            this.tab = tab;
            return this;
        }

        public Builder withProperModel(String elModel, String properTextureName) {
            this.modelFileString = elModel;
            this.properTextureName = properTextureName;
            return this;
        }

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withModelTextureName(String textureName) {
            this.textureName = textureName;
            return this;
        }

        public Builder withEntityPositioning(Runnable entityPositioning) {
            this.transforms.setEntityPositioning(entityPositioning);
            return this;
        }

        public Builder withInventoryPositioning(Runnable inventoryPositioning) {
            this.transforms.setInventoryPositioning(inventoryPositioning);
            return this;
        }

        public Builder withThirdPersonPositioning(Runnable thirdPersonPositioning) {
            this.transforms.setThirdPersonPositioning(thirdPersonPositioning);
            return this;
        }

        public Builder withCustomEquippedPositioning(Runnable customEquippedPositioning) {
            this.transforms.setCustomEquippedPositioning(customEquippedPositioning);
            return this;
        }

        public Builder withFirstPersonPositioning(Runnable firstPersonPositioning) {
            this.transforms.setFirstPersonPositioning(firstPersonPositioning);
            return this;
        }

        public Builder withFirstPersonModelPositioning(Consumer<ModelBase> firstPersonModelPositioning) {
            this.transforms.setFirstPersonModelPositioning(firstPersonModelPositioning);
            return this;
        }

        public Builder withEntityModelPositioning(Consumer<ModelBase> entityModelPositioning) {
            this.transforms.setEntityModelPositioning(entityModelPositioning);
            return this;
        }

        public Builder withInventoryModelPositioning(Consumer<ModelBase> inventoryModelPositioning) {
            this.transforms.setInventoryModelPositioning(inventoryModelPositioning);
            return this;
        }

        public Builder withThirdPersonModelPositioning(Consumer<ModelBase> thirdPersonModelPositioning) {
            this.transforms.setThirdPersonModelPositioning(thirdPersonModelPositioning);
            return this;
        }

        public Builder withFirstPersonHandPositioning(Runnable leftHand, Runnable rightHand) {
            this.transforms.setFirstPersonLeftHandPositioning(leftHand);
            this.transforms.setFirstPersonRightHandPositioning(rightHand);
            return this;
        }

        public ItemVest build(ModContext modContext) {
            if (this.name == null) {
                throw new IllegalStateException("ItemBackpack name not set");
            }
            ItemVest item = new ItemVest(modContext, this.percentDamageBlocked, this.durability);
            ServerGearModelHookRegistry.modelArray.add(this.modelFileString);
            item.modelFileString = this.modelFileString;
            item.textureName = this.properTextureName;
            item.func_77655_b("mwc_" + this.name);
            CraftingRegistry.registerHook(item);
            if (this.modelFileString != null && !FMLCommonHandler.instance().getSide().isServer()) {
                try {
                    ModelBase base = (ModelBase)Class.forName(this.modelFileString).newInstance();
                    item.texturedModels.add(new Tuple<ModelBase, String>(base, ItemVest.addFileExtension(this.properTextureName, ".png")));
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (this.model != null) {
                item.texturedModels.add(new Tuple<ModelBase, String>(this.model, ItemVest.addFileExtension(this.textureName, ".png")));
            }
            if (this.tab != null) {
                item.func_77637_a(this.tab);
            }
            modContext.registerRenderableItem(this.name, (Item)item, (Object)(FMLCommonHandler.instance().getSide() == Side.CLIENT ? new StaticModelSourceRenderer(this.transforms) : null));
            return item;
        }
    }
}

