/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.weaponlib.AttachmentBuilder;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.electronics.ScopePerspective;
import com.paneedah.weaponlib.perspective.ReflexScreen;
import com.paneedah.weaponlib.render.scopes.CyclicList;
import com.paneedah.weaponlib.render.scopes.Reticle;
import java.util.Arrays;
import org.lwjgl.opengl.GL11;

public class ItemScope
extends ItemAttachment<Weapon> {
    private static final int DEFAULT_MAX_STACK_SIZE = 1;
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 400;
    private ModContext modContext;
    private Builder builder;

    private ItemScope(Builder builder) {
        super(AttachmentCategory.SCOPE, builder.getModel(), builder.getTextureName(), null, null, null);
        this.builder = builder;
        this.func_77625_d(1);
    }

    public boolean hasReticle() {
        return !this.builder.reticles.isEmpty();
    }

    public float getMinZoom() {
        return this.builder.minZoom;
    }

    public float getMaxZoom() {
        return this.builder.maxZoom;
    }

    public boolean isOptical() {
        return this.builder.isOpticalZoom;
    }

    public boolean usesWhitePhosphor() {
        return this.builder.usesWhitePhosphor;
    }

    public boolean hasNightVision() {
        return this.builder.hasNightVision;
    }

    public int getWidth() {
        return this.builder.width;
    }

    public void switchReticle() {
        this.builder.screen.reticleList.next();
    }

    public int getHeight() {
        return this.builder.height;
    }

    public static final class Builder
    extends AttachmentBuilder<Weapon> {
        private float minZoom;
        private float maxZoom;
        private boolean isOpticalZoom;
        private boolean hasNightVision;
        private boolean usesWhitePhosphor;
        private Runnable viewfinderPositioning;
        private int width = 400;
        private int height = 400;
        public Reticle sniperReticle = new Reticle("holo");
        public CyclicList<Reticle> reticles = new CyclicList();
        public ReflexScreen screen;
        private float radialCut = 20.0f;
        private Runnable reticlePositioning;

        public Builder withZoomRange(float minZoom, float maxZoom) {
            this.minZoom = minZoom;
            this.maxZoom = maxZoom;
            return this;
        }

        public Builder withRadialCut(float radius) {
            this.radialCut = radius;
            return this;
        }

        public Builder withSniperReticle(Reticle ret) {
            this.sniperReticle = ret;
            return this;
        }

        public Builder withOpticalZoom() {
            this.isOpticalZoom = true;
            return this;
        }

        public Builder withViewfinderSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder withNightVision() {
            this.hasNightVision = true;
            return this;
        }

        public Builder withWhitePhosphor() {
            this.usesWhitePhosphor = true;
            return this;
        }

        public Builder withHolographicReticles(Reticle ... reticles) {
            this.reticles.addAll(Arrays.asList(reticles));
            return this;
        }

        public Builder withReticlePositioning(Runnable reticlePositioning) {
            this.reticlePositioning = reticlePositioning;
            return this;
        }

        public Builder withViewfinderPositioning(Runnable viewfinderPositioning) {
            this.viewfinderPositioning = viewfinderPositioning;
            return this;
        }

        @Override
        protected ItemAttachment<Weapon> createAttachment(ModContext modContext) {
            if (this.isOpticalZoom) {
                if (this.viewfinderPositioning == null) {
                    this.viewfinderPositioning = () -> {
                        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                        GL11.glTranslatef((float)0.1f, (float)0.4f, (float)0.6f);
                    };
                }
                this.withPostRender(new ScopePerspective(this.viewfinderPositioning, this.sniperReticle));
            }
            if (!this.reticles.isEmpty()) {
                this.screen = new ReflexScreen(this.reticlePositioning, this.radialCut, this.reticles);
                this.withPostRender(this.screen);
            }
            ItemScope itemScope = new ItemScope(this);
            itemScope.modContext = modContext;
            return itemScope;
        }

        @Override
        public ItemAttachment<Weapon> build(ModContext modContext) {
            this.apply2 = (a, instance) -> {
                float zoom = this.minZoom + (this.maxZoom - this.minZoom) / 2.0f;
                instance.setZoom(zoom);
            };
            this.remove2 = (a, instance) -> instance.setZoom(1.0f);
            return super.build(modContext);
        }
    }
}

