/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.ModelSource;
import com.paneedah.weaponlib.Part;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemAttachment<T>
extends Item
implements ModelSource,
IModernCraftingRecipe {
    private AttachmentCategory category;
    private String crosshair;
    private ApplyHandler<T> apply;
    private ApplyHandler<T> remove;
    protected ApplyHandler2<T> apply2;
    protected ApplyHandler2<T> remove2;
    protected MeleeWeaponApplyHandler<T> apply3;
    protected MeleeWeaponApplyHandler<T> remove3;
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
    private List<CustomRenderer<?>> postRenderer = new ArrayList();
    private CustomRenderer<?> preRenderer;
    private Part renderablePart;
    private String name;
    private Function<ItemStack, String> informationProvider;
    protected int field_77777_bU = 1;
    private CraftingEntry[] modernRecipe;
    private CraftingGroup craftGroup;
    private List<CompatibleAttachment<T>> attachments = new ArrayList<CompatibleAttachment<T>>();
    private List<Weapon> compatibleWeapons = new ArrayList<Weapon>();
    private List<ItemAttachment<T>> requiredAttachments = new ArrayList<ItemAttachment<T>>();
    protected String textureName;
    public Vec3d rotationPoint = Vec3d.field_186680_a;

    protected ItemAttachment(AttachmentCategory category, ModelBase model, String textureName, String crosshair, ApplyHandler<T> apply, ApplyHandler<T> remove) {
        this.category = category;
        this.textureName = textureName.toLowerCase();
        this.crosshair = crosshair != null ? "mwc:textures/crosshairs/" + crosshair + ".png" : null;
        this.apply = apply;
        this.remove = remove;
    }

    protected ItemAttachment(AttachmentCategory category, String crosshair, ApplyHandler<T> apply, ApplyHandler<T> remove) {
        this.category = category;
        this.crosshair = crosshair != null ? "mwc:textures/crosshairs/" + crosshair + ".png" : null;
        this.apply = apply;
        this.remove = remove;
    }

    public int func_77639_j() {
        return this.field_77777_bU;
    }

    public Item setTextureName(String name) {
        return this;
    }

    @Override
    public CraftingGroup getCraftingGroup() {
        return this.craftGroup;
    }

    @Override
    public void setCraftingGroup(CraftingGroup cg) {
        this.craftGroup = cg;
    }

    public void setModernRecipe(CraftingEntry ... is) {
        this.modernRecipe = is;
    }

    public Part getRenderablePart() {
        return this.renderablePart;
    }

    protected void setRenderablePart(Part renderablePart) {
        this.renderablePart = renderablePart;
    }

    protected Function<ItemStack, String> getInformationProvider() {
        return this.informationProvider;
    }

    protected void setInformationProvider(Function<ItemStack, String> informationProvider) {
        this.informationProvider = informationProvider;
    }

    protected void setRequiredAttachments(List<ItemAttachment<T>> requiredAttachments) {
        this.requiredAttachments = Collections.unmodifiableList(requiredAttachments);
    }

    public List<ItemAttachment<T>> getRequiredAttachments() {
        return this.requiredAttachments;
    }

    @Deprecated
    public ItemAttachment<T> addModel(ModelBase model, String textureName) {
        this.texturedModels.add(new Tuple<ModelBase, String>(model, textureName));
        return this;
    }

    public ItemAttachment(AttachmentCategory category, String crosshair) {
        this(category, crosshair, (ItemAttachment<T> a, T w, EntityLivingBase p) -> {}, (ItemAttachment<T> a, T w, EntityLivingBase p) -> {});
    }

    public ItemAttachment(AttachmentCategory category, ModelBase attachment, String textureName, String crosshair) {
        this(category, attachment, textureName, crosshair, (a, w, p) -> {}, (a, w, p) -> {});
    }

    public AttachmentCategory getCategory() {
        return this.category;
    }

    @Override
    public List<Tuple<ModelBase, String>> getTexturedModels() {
        return this.texturedModels;
    }

    public void setFirstModel(ItemAttachment<Weapon> model) {
        this.texturedModels.set(0, model.getTexturedModels().get(0));
    }

    public String getCrosshair() {
        return this.crosshair;
    }

    public ApplyHandler<T> getApply() {
        return this.apply;
    }

    public ApplyHandler<T> getRemove() {
        return this.remove;
    }

    public void addCompatibleWeapon(Weapon weapon) {
        this.compatibleWeapons.add(weapon);
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (tooltip != null && this.informationProvider != null) {
            tooltip.add(this.informationProvider.apply(itemStack));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPostRenderers(List<CustomRenderer<?>> postRenderer) {
    }

    @Override
    public CustomRenderer<?> getPostRenderer() {
        return this.postRenderer.isEmpty() ? null : this.postRenderer.get(0);
    }

    public List<CustomRenderer<?>> getAllPostRenderers() {
        return this.postRenderer;
    }

    public CustomRenderer<?> getPreRenderer() {
        return this.preRenderer;
    }

    public void setPreRenderer(CustomRenderer<?> preRenderer) {
        this.preRenderer = preRenderer;
    }

    protected void addCompatibleAttachment(CompatibleAttachment<T> attachment) {
        this.attachments.add(attachment);
    }

    public List<CompatibleAttachment<T>> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public String toString() {
        return this.name != null ? "Attachment [" + this.name + "]" : super.toString();
    }

    public ApplyHandler2<T> getApply2() {
        return this.apply2;
    }

    protected ApplyHandler2<T> getRemove2() {
        return this.remove2;
    }

    public MeleeWeaponApplyHandler<T> getApply3() {
        return this.apply3;
    }

    public MeleeWeaponApplyHandler<T> getRemove3() {
        return this.remove3;
    }

    public void setPostRenderer(List<CustomRenderer<?>> postRenderer2) {
        this.postRenderer = postRenderer2;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public CraftingEntry[] getModernRecipe() {
        return this.modernRecipe;
    }

    @Override
    public void setCraftingRecipe(CraftingEntry[] recipe) {
        this.modernRecipe = recipe;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return true;
    }

    public static interface MeleeWeaponApplyHandler<T> {
        public void apply(ItemAttachment<T> var1, PlayerMeleeInstance var2);
    }

    public static interface ApplyHandler2<T> {
        public void apply(ItemAttachment<T> var1, PlayerWeaponInstance var2);
    }

    public static interface ApplyHandler<T> {
        public void apply(ItemAttachment<T> var1, T var2, EntityLivingBase var3);
    }
}

