/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.ExplosionMessage;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.particle.ExplosionSmokeFX;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Explosion {
    private final boolean isFlaming;
    private final boolean isSmoking;
    private final Random explosionRNG = new Random();
    private final World world;
    private final Vector3D position;
    private final Entity exploder;
    private final float explosionStrength;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vector3D> playerKnockbackMap = Maps.newHashMap();
    private final float smokeParticleAgeCoefficient;
    private final float smokeParticleScaleCoefficient;
    private final String smokeParticleTextureName;
    private final SoundEvent explosionSound;

    public Explosion(World worldIn, Entity entityIn, Vector3D position, float explosionStrength, boolean flaming, boolean smoking, float particleAgeCoefficient, float smokeParticleAgeCoefficient, float explosionParticleScaleCoefficient, float smokeParticleScaleCoefficient, String explosionParticleTextureName, String smokeParticleTextureName, SoundEvent explosionSound) {
        this.world = worldIn;
        this.exploder = entityIn;
        this.explosionStrength = explosionStrength;
        this.position = position;
        this.isFlaming = flaming;
        this.isSmoking = smoking;
        this.smokeParticleAgeCoefficient = smokeParticleAgeCoefficient;
        this.smokeParticleScaleCoefficient = smokeParticleScaleCoefficient;
        this.smokeParticleTextureName = smokeParticleTextureName;
        this.explosionSound = explosionSound;
    }

    public static void createOldServerSideExplosion(World world, EntityLivingBase thrower, Entity entity, Vector3D position, float explosionStrength, boolean isFlaming, boolean isSmoking, boolean isDestroyingBlocks, float particleAgeCoefficient, float smokeParticleAgeCoefficient, float explosionParticleScaleCoefficient, float smokeParticleScaleCoefficient, String explosionParticleTextureName, String smokeParticleTextureName, SoundEvent explosionSound) {
        Explosion explosion = new Explosion(world, entity, position, explosionStrength *= (float)ModernConfigManager.explosionDamage, isFlaming, isSmoking, particleAgeCoefficient, smokeParticleAgeCoefficient, explosionParticleScaleCoefficient, smokeParticleScaleCoefficient, explosionParticleTextureName, smokeParticleTextureName, explosionSound);
        explosion.doExplosionA();
        explosion.doExplosionB(true, isDestroyingBlocks);
        if (!isSmoking) {
            explosion.affectedBlockPositions.clear();
        }
        for (EntityPlayer currentPlayer : world.field_73010_i) {
            Vector3D velocity;
            if (currentPlayer == null) {
                return;
            }
            if (!(currentPlayer.func_70092_e(position.x, position.y, position.z) < 4096.0) || (velocity = explosion.getPlayerKnockbackMap().get(currentPlayer)) == null) continue;
            MWC.CHANNEL.sendTo((IMessage)new ExplosionMessage(velocity, explosionStrength), (EntityPlayerMP)currentPlayer);
        }
    }

    public static void createServerSideExplosion(World world, EntityLivingBase thrower, Entity entity, double posX, double posY, double posZ, float explosionStrength, boolean isFlaming, boolean isSmoking, boolean isDestroyingBlocks, float particleAgeCoefficient, float smokeParticleAgeCoefficient, float explosionParticleScaleCoefficient, float smokeParticleScaleCoefficient, String explosionParticleTextureName, String smokeParticleTextureName, SoundEvent explosionSound) {
        world.func_72876_a((Entity)thrower, entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v, (float)ModernConfigManager.explosionDamage, ModernConfigManager.explosionBreak);
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.position.x;
                    double d6 = this.position.y;
                    double d8 = this.position.z;
                    for (float f = this.explosionStrength * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos((int)d4, (int)d6, (int)d8);
                        IBlockState iBlockState = this.world.func_180495_p(blockpos);
                        if (!MWCUtil.isPenetrableByBullets(iBlockState)) {
                            float f2 = this.exploder != null ? this.exploder.func_180428_a(new net.minecraft.world.Explosion(this.world, this.exploder, this.position.x, this.position.y, this.position.z, this.explosionStrength, false, true), this.world, blockpos, iBlockState) : iBlockState.func_177230_c().func_149638_a(null);
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a(new net.minecraft.world.Explosion(this.world, this.exploder, this.position.x, this.position.y, this.position.z, this.explosionStrength, false, true), this.world, blockpos, iBlockState, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        Vector3D vec3d = new Vector3D(this.position.x, this.position.y, this.position.z);
        float knockbackRange = this.explosionStrength * 2.0f;
        List list = this.world.func_72839_b(this.exploder, this.exploder.func_174813_aQ().func_72321_a((double)knockbackRange, (double)knockbackRange, (double)knockbackRange).func_72321_a((double)(-knockbackRange), (double)(-knockbackRange), (double)(-knockbackRange)));
        for (Entity entity : list) {
            EntityPlayer entityplayer;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.position.x, this.position.y, this.position.z) / (double)knockbackRange) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.position.x) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.position.y) * d7 + (d9 = entity.field_70161_v - this.position.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            AxisAlignedBB boundingBox = entity.func_174813_aQ();
            double deltaX = 1.0 / ((boundingBox.field_72336_d - boundingBox.field_72340_a) * 2.0 + 1.0);
            double deltaY = 1.0 / ((boundingBox.field_72337_e - boundingBox.field_72338_b) * 2.0 + 1.0);
            double deltaZ = 1.0 / ((boundingBox.field_72334_f - boundingBox.field_72339_c) * 2.0 + 1.0);
            double offsetX = (1.0 - Math.floor(1.0 / deltaX) * deltaX) / 2.0;
            double offsetZ = (1.0 - Math.floor(1.0 / deltaZ) * deltaZ) / 2.0;
            int collidableCount = 0;
            int totalSampleCount = 0;
            for (double x = 0.0; x <= 1.0; x += deltaX) {
                for (double y = 0.0; y <= 1.0; y += deltaY) {
                    for (double z = 0.0; z <= 1.0; z += deltaZ) {
                        double posX = boundingBox.field_72340_a + (boundingBox.field_72336_d - boundingBox.field_72340_a) * x;
                        double posY = boundingBox.field_72338_b + (boundingBox.field_72337_e - boundingBox.field_72338_b) * y;
                        double posZ = boundingBox.field_72339_c + (boundingBox.field_72334_f - boundingBox.field_72339_c) * z;
                        Vector3D sampledVec = new Vector3D(posX + offsetX, posY, posZ + offsetZ);
                        if (MWCUtil.rayTraceBlocks(this.world, sampledVec, vec3d, this::canCollideWithBlock) == null) {
                            ++collidableCount;
                        }
                        ++totalSampleCount;
                    }
                }
            }
            double d14 = (float)collidableCount / (float)totalSampleCount;
            double d10 = (1.0 - d12) * d14 * (double)(this.explosionStrength / 4.0f);
            if (!(entity instanceof EntityPlayer) || (entityplayer = (EntityPlayer)entity).func_175149_v()) continue;
            this.playerKnockbackMap.put(entityplayer, new Vector3D(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public boolean canCollideWithBlock(Block block, IBlockState iBlockState) {
        return !MWCUtil.isPenetrableByBullets(iBlockState) && block.func_176209_a(iBlockState, false);
    }

    public void doExplosionB(boolean spawnParticles, boolean destroyBlocks) {
        if (!this.world.field_72995_K && this.explosionSound != null) {
            this.world.func_184148_a(null, this.position.x, this.position.y, this.position.z, this.explosionSound, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.isSmoking) {
            int counter = 0;
            for (BlockPos blockpos : this.affectedBlockPositions) {
                if (counter++ % 2 != 0) continue;
                IBlockState blockState = this.world.func_180495_p(blockpos);
                if (!destroyBlocks || blockState.func_177230_c() == Blocks.field_150350_a) continue;
                if (blockState.func_177230_c().func_149659_a(new net.minecraft.world.Explosion(this.world, this.exploder, this.position.x, this.position.y, this.position.z, this.explosionStrength, false, true))) {
                    blockState.func_177230_c().func_180653_a(this.world, blockpos, blockState, (float)ModernConfigManager.explodedBlockDropChance * (1.0f / this.explosionStrength), 0);
                }
                blockState.func_177230_c().onBlockExploded(this.world, blockpos, new net.minecraft.world.Explosion(this.world, this.exploder, this.position.x, this.position.y, this.position.z, this.explosionStrength, false, true));
            }
            if (spawnParticles && FMLCommonHandler.instance().getSide().isClient()) {
                for (int i = 0; i < 15; ++i) {
                    double pX = this.position.x + this.world.field_73012_v.nextGaussian() * 0.8 * (double)this.smokeParticleScaleCoefficient;
                    double pY = this.position.y + this.world.field_73012_v.nextGaussian() * 0.9 * (double)this.smokeParticleScaleCoefficient;
                    double pZ = this.position.z + this.world.field_73012_v.nextGaussian() * 0.8 * (double)this.smokeParticleScaleCoefficient;
                    double motionX = this.world.field_73012_v.nextGaussian() * 0.001 * (double)this.explosionStrength;
                    double motionY = this.world.field_73012_v.nextGaussian() * 1.0E-4 * (double)this.explosionStrength;
                    double motionZ = this.world.field_73012_v.nextGaussian() * 0.001 * (double)this.explosionStrength;
                    MWC.modContext.getEffectManager().spawnExplosionSmoke(pX, pY, pZ, motionX, motionY, motionZ, this.smokeParticleScaleCoefficient, (int)((float)(250 + (int)(this.world.field_73012_v.nextFloat() * 30.0f)) * this.smokeParticleAgeCoefficient), ExplosionSmokeFX.Behavior.EXPLOSION, this.smokeParticleTextureName);
                }
            }
        }
        if (this.isFlaming && destroyBlocks) {
            for (BlockPos blockpos1 : this.affectedBlockPositions) {
                if (!this.world.func_175623_d(blockpos1) || !this.world.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.explosionRNG.nextInt(3) != 0) continue;
                this.world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public Map<EntityPlayer, Vector3D> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }
}

