/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.utils;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.compatibility.CompatibleExtraEntityFlags;
import com.paneedah.weaponlib.config.ModernConfigManager;
import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.jafama.FastMath;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MWCUtil {
    private static final Set<Material> PENETRABLE_MATERIALS = new HashSet<Material>(Arrays.asList(Material.field_151569_G, Material.field_151582_l, Material.field_151585_k, Material.field_151570_A, Material.field_151584_j, Material.field_151594_q, Material.field_151593_r, Material.field_151568_F));
    private static final Set<Block> PENETRABLE_BLOCKS = new HashSet<Block>(Arrays.asList(Blocks.field_150411_aY, Blocks.field_180393_cK, Blocks.field_180394_cL, Blocks.field_150472_an, Blocks.field_150444_as));

    public static boolean isPenetrableByBullets(IBlockState blockState) {
        if (PENETRABLE_MATERIALS.contains(blockState.func_185904_a()) || PENETRABLE_BLOCKS.contains(blockState.func_177230_c()) || !ModernConfigManager.penetrableBlocks.isEmpty() && ModernConfigManager.penetrableBlocks.contains(blockState.func_177230_c().getRegistryName().toString())) {
            return true;
        }
        return ModernConfigManager.bulletBreakGlass && blockState.func_185904_a() == Material.field_151592_s;
    }

    public static int consumeItemsFromPlayerInventory(List<? extends Item> items, int amount, EntityPlayer player) {
        if (amount <= 0) {
            return 0;
        }
        if (player.func_184812_l_() && !player.func_70093_af()) {
            return amount;
        }
        int consumedAmount = 0;
        block0: for (Item item : items) {
            for (int slotIndex = 0; slotIndex < player.field_71071_by.func_70302_i_(); ++slotIndex) {
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(slotIndex);
                if (!stackInSlot.func_77973_b().equals(item)) continue;
                int availableItems = stackInSlot.func_190916_E();
                int itemsToConsume = Math.min(availableItems, amount - consumedAmount);
                stackInSlot.func_190918_g(itemsToConsume);
                if ((consumedAmount += itemsToConsume) >= amount) break block0;
            }
        }
        return consumedAmount;
    }

    public static ItemStack consumeItemsFromPlayerInventory(List<? extends ItemMagazine> items, Comparator<ItemStack> comparator, EntityPlayer player) {
        ItemStack maxStack = null;
        if (player.func_184812_l_() && !player.func_70093_af()) {
            return items.stream().map(ItemMagazine::create).max(comparator).orElse(null);
        }
        for (ItemStack currentStack : player.field_71071_by.field_70462_a) {
            if (!items.contains(currentStack.func_77973_b()) || maxStack != null && comparator.compare(currentStack, maxStack) <= 0) continue;
            maxStack = currentStack;
        }
        if (maxStack == null || maxStack.func_190926_b()) {
            return null;
        }
        return maxStack.func_77979_a(1);
    }

    public static RayTraceResult rayTraceBlocks(World world, Vector3D startPos, Vector3D endPos, BiPredicate<Block, IBlockState> isCollidable) {
        int startX = FastMath.floorToInt((double)startPos.x);
        int startY = FastMath.floorToInt((double)startPos.y);
        int startZ = FastMath.floorToInt((double)startPos.z);
        int endX = FastMath.floorToInt((double)endPos.x);
        int endY = FastMath.floorToInt((double)endPos.y);
        int endZ = FastMath.floorToInt((double)endPos.z);
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(startX, startY, startZ);
        for (int i = 0; i < 256; ++i) {
            RayTraceResult rayTraceResult;
            EnumFacing direction;
            double nextY;
            double nextX;
            if (startX == endX && startY == endY && startZ == endZ) {
                return null;
            }
            double d = endX > startX ? (double)(startX + 1) : (nextX = endX < startX ? (double)startX : 999.0);
            double d2 = endY > startY ? (double)(startY + 1) : (nextY = endY < startY ? (double)startY : 999.0);
            double nextZ = endZ > startZ ? (double)(startZ + 1) : (endZ < startZ ? (double)startZ : 999.0);
            double diffX = endPos.x - startPos.x;
            double diffY = endPos.y - startPos.y;
            double diffZ = endPos.z - startPos.z;
            double factorX = endX != startX ? (nextX - startPos.x) / diffX : 999.0;
            double factorY = endY != startY ? (nextY - startPos.y) / diffY : 999.0;
            double factorZ = endZ != startZ ? (nextZ - startPos.z) / diffZ : 999.0;
            factorX = factorX == 0.0 ? -1.0E-4 : factorX;
            factorY = factorY == 0.0 ? -1.0E-4 : factorY;
            double d3 = factorZ = factorZ == 0.0 ? -1.0E-4 : factorZ;
            if (factorX < factorY && factorX < factorZ) {
                direction = endX > startX ? EnumFacing.WEST : EnumFacing.EAST;
                startPos.set(nextX, startPos.y + diffY * factorX, startPos.z + diffZ * factorX);
                startX = FastMath.floorToInt((double)startPos.x);
                if (direction == EnumFacing.EAST) {
                    --startX;
                }
            } else if (factorY < factorZ) {
                direction = endY > startY ? EnumFacing.DOWN : EnumFacing.UP;
                startPos.set(startPos.x + diffX * factorY, nextY, startPos.z + diffZ * factorY);
                startY = FastMath.floorToInt((double)startPos.y);
                if (direction == EnumFacing.UP) {
                    --startY;
                }
            } else {
                direction = endZ > startZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                startPos.set(startPos.x + diffX * factorZ, startPos.y + diffY * factorZ, nextZ);
                startZ = FastMath.floorToInt((double)startPos.z);
                if (direction == EnumFacing.SOUTH) {
                    --startZ;
                }
            }
            blockPos.func_181079_c(startX, startY, startZ);
            IBlockState iBlockState = world.func_180495_p((BlockPos)blockPos);
            if (!isCollidable.test(iBlockState.func_177230_c(), iBlockState) || (rayTraceResult = iBlockState.func_185910_a(world, (BlockPos)blockPos, startPos.toVec3d(), endPos.toVec3d())) == null) continue;
            return rayTraceResult;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static Vec3d getInterpolatedPlayerPos() {
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        float renderPartialTicks = ClientProxy.MC.func_184121_ak();
        double interpolatedX = (player.field_70165_t - player.field_70169_q) * (double)renderPartialTicks + player.field_70169_q;
        double interpolatedY = (player.field_70163_u - player.field_70167_r) * (double)renderPartialTicks + player.field_70167_r;
        double interpolatedZ = (player.field_70161_v - player.field_70166_s) * (double)renderPartialTicks + player.field_70166_s;
        return new Vec3d(interpolatedX, interpolatedY, interpolatedZ);
    }

    public static boolean isProning(EntityPlayer player) {
        return (CompatibleExtraEntityFlags.getFlags((Entity)player) & CompatibleExtraEntityFlags.PRONING) != 0;
    }
}

