/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.messages;

import com.paneedah.mwc.equipment.inventory.EquipmentInventory;
import com.paneedah.mwc.utils.ModReference;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class EntityInventorySyncMessage
implements IMessage {
    private int entityId;
    private boolean excludeEntity;
    private NBTTagCompound inventoryCompound = new NBTTagCompound();

    public EntityInventorySyncMessage(Entity entity, boolean excludeEntity, EquipmentInventory inventory) {
        this.entityId = entity.func_145782_y();
        this.excludeEntity = excludeEntity;
        inventory.writeToNBT(this.inventoryCompound);
    }

    public void fromBytes(ByteBuf byteBuf) {
        PacketBuffer packetBuf = new PacketBuffer(byteBuf);
        this.entityId = packetBuf.readInt();
        this.excludeEntity = packetBuf.readBoolean();
        try {
            this.inventoryCompound = packetBuf.func_150793_b();
        }
        catch (IOException ioException) {
            ModReference.RED_LOG.printFramedError("Networking", "Failed to read equipment inventory from message", "Equipment inventory won't be synced", new String[]{ioException.getMessage()});
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        PacketBuffer packetBuf = new PacketBuffer(byteBuf);
        packetBuf.writeInt(this.entityId);
        packetBuf.writeBoolean(this.excludeEntity);
        packetBuf.func_150786_a(this.inventoryCompound);
    }

    public EquipmentInventory getInventory() {
        EquipmentInventory inventory = new EquipmentInventory();
        if (this.inventoryCompound != null) {
            inventory.readFromNBT(this.inventoryCompound);
        }
        return inventory;
    }

    public Entity getEntity(World world) {
        return world.func_73045_a(this.entityId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isExcludeEntity() {
        return this.excludeEntity;
    }

    public NBTTagCompound getInventoryCompound() {
        return this.inventoryCompound;
    }

    public EntityInventorySyncMessage() {
    }
}

