/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.equipment.inventory.carryable.backpack;

import com.paneedah.mwc.equipment.inventory.carryable.backpack.BackpackInventory;
import com.paneedah.mwc.equipment.inventory.carryable.backpack.BackpackSlot;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BackpackContainer
extends Container {
    public final BackpackInventory inventory;
    private int armorSlotStartIndex;
    private int armorSlotEndIndex;
    private int standardInventorySlotStartIndex;
    private int standardInventorySlotEndIndex;
    private int hotbarSlotStartIndex;
    private int hotbarSlotEndIndex;

    public BackpackContainer(EntityPlayer player, InventoryPlayer inventoryPlayer, BackpackInventory inventoryItem) {
        this.inventory = inventoryItem;
        List<Slot> storageSlots = this.createStorageSlots(this.inventory);
        storageSlots.forEach(slot -> this.func_75146_a((Slot)slot));
        boolean customSlotStartIndex = false;
        int customSlotEndIndex = 0 + storageSlots.size() - 1;
        List<Slot> armorSlots = this.createArmorSlots(player, inventoryPlayer);
        armorSlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.armorSlotStartIndex = customSlotEndIndex + 1;
        this.armorSlotEndIndex = this.armorSlotStartIndex + armorSlots.size() - 1;
        List<Slot> standardInventorySlots = this.createStandardInventorySlots(inventoryPlayer);
        standardInventorySlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.standardInventorySlotStartIndex = this.armorSlotEndIndex + 1;
        this.standardInventorySlotEndIndex = this.standardInventorySlotStartIndex + standardInventorySlots.size() - 1;
        List<Slot> hotbarSlots = this.createHotbarSlots(inventoryPlayer);
        hotbarSlots.forEach(slot -> this.func_75146_a((Slot)slot));
        this.hotbarSlotStartIndex = this.standardInventorySlotEndIndex + 1;
        this.hotbarSlotEndIndex = this.hotbarSlotStartIndex + hotbarSlots.size() - 1;
    }

    protected List<Slot> createStorageSlots(BackpackInventory inventoryCustom) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < inventoryCustom.func_70302_i_(); ++i) {
            slots.add(new BackpackSlot(this.inventory, i, 80 + 18 * (i / 4), 8 + 18 * (i % 4)));
        }
        return slots;
    }

    protected List<Slot> createHotbarSlots(InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 9; ++i) {
            slots.add(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
        return slots;
    }

    protected List<Slot> createStandardInventorySlots(InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                slots.add(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        return slots;
    }

    protected List<Slot> createArmorSlots(final EntityPlayer player, InventoryPlayer inventoryPlayer) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < 4; ++i) {
            final EntityEquipmentSlot entityequipmentslot = (new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET})[i];
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, inventoryPlayer.func_70302_i_() - 1 - i - 1, 8, 8 + i * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.func_77973_b().isValidArmor(stack, entityequipmentslot, (Entity)player);
                }

                public boolean func_82869_a(EntityPlayer playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @SideOnly(value=Side.CLIENT)
                public String func_178171_c() {
                    return ItemArmor.field_94603_a[entityequipmentslot.func_188454_b()];
                }
            });
        }
        return slots;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int index) {
        ItemStack itemstack = new ItemStack(Items.field_190931_a);
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.standardInventorySlotStartIndex) {
                if (!this.func_75135_a(itemstack1, this.standardInventorySlotStartIndex, this.hotbarSlotEndIndex + 1, true)) {
                    return new ItemStack(Items.field_190931_a);
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else {
                EntityEquipmentSlot type;
                ItemArmor armor;
                int ordinal;
                if (itemstack1.func_77973_b() instanceof ItemArmor && !this.func_75135_a(itemstack1, this.armorSlotStartIndex + (ordinal = 4 - (armor = (ItemArmor)itemstack1.func_77973_b()).func_185083_B_().func_188452_c()), this.armorSlotStartIndex + ordinal + 1, false)) {
                    if (!this.func_75135_a(itemstack1, 0, this.field_75151_b.size() - 1, false)) {
                        return ItemStack.field_190927_a;
                    }
                    return ItemStack.field_190927_a;
                }
                if (index >= this.standardInventorySlotStartIndex ? !this.func_75135_a(itemstack1, 0, this.standardInventorySlotStartIndex, false) : index >= this.armorSlotStartIndex && index <= this.armorSlotEndIndex && !this.func_75135_a(itemstack1, this.armorSlotStartIndex + (type = ((ItemArmor)itemstack1.func_77973_b()).field_77881_a).ordinal(), this.armorSlotStartIndex + type.ordinal() + 1, false)) {
                    return new ItemStack(Items.field_190931_a);
                }
                if (index >= this.standardInventorySlotStartIndex && index <= this.standardInventorySlotEndIndex ? !this.func_75135_a(itemstack1, this.hotbarSlotStartIndex, this.hotbarSlotEndIndex + 1, false) : index >= this.hotbarSlotStartIndex && index <= this.hotbarSlotEndIndex && !this.func_75135_a(itemstack1, this.standardInventorySlotStartIndex, this.standardInventorySlotEndIndex + 1, false)) {
                    return new ItemStack(Items.field_190931_a);
                }
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return null;
            }
            slot.func_190901_a(par1EntityPlayer, itemstack1);
        }
        return itemstack;
    }
}

