/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Updatable;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import com.paneedah.weaponlib.melee.ItemMelee;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public final class ClientTickerController {
    private static ScheduledFuture<?> scheduledFuture;

    public static void start() {
        scheduledFuture = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> ClientTicker.onTick(), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public static void stop() {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static final class ClientTicker {
        private static boolean rightMouseButtonPressed;
        private static final int LEFT_MOUSE_BUTTON = 0;
        private static final int RIGHT_MOUSE_BUTTON = 1;
        private static int guiCooldown;

        private ClientTicker() {
        }

        private static void onTick() {
            if (!Mouse.isCreated() || ClientProxy.MC.field_71439_g == null || ClientProxy.MC.field_71439_g.func_175149_v()) {
                return;
            }
            ClientTicker.scheduleTask(ClientTicker::tickHeldItem, false);
            if (ClientProxy.MC.field_71462_r != null) {
                guiCooldown = 30;
                return;
            }
            if (guiCooldown > 0) {
                --guiCooldown;
            }
            if (Mouse.isButtonDown((int)0)) {
                ClientTicker.scheduleTask(ClientTicker::onLeftMouseButtonDown, true);
            } else {
                ClientTicker.scheduleTask(ClientTicker::onLeftMouseButtonReleased, false);
            }
            if (Mouse.isButtonDown((int)1)) {
                if (!rightMouseButtonPressed) {
                    rightMouseButtonPressed = true;
                    ClientTicker.scheduleTask(ClientTicker::onRightMouseButtonDown, true);
                }
            } else {
                rightMouseButtonPressed = false;
                ClientTicker.scheduleTask(ClientTicker::onRightMouseButtonReleased, false);
            }
        }

        private static void scheduleTask(Runnable runnable, boolean blockedByGUICooldown) {
            if (!blockedByGUICooldown || guiCooldown == 0) {
                ClientProxy.MC.func_152344_a(runnable);
            }
        }

        private static void onLeftMouseButtonDown() {
            if (AnimationModeProcessor.getInstance().getFPSMode()) {
                return;
            }
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            Item item = ClientTicker.getHeldItemMainHand((EntityPlayer)player);
            if (item instanceof Weapon && BalancePackManager.isWeaponDisabled((Weapon)item)) {
                return;
            }
            if (item instanceof Weapon) {
                ((Weapon)item).tryFire((EntityPlayer)player);
            } else if (item instanceof ItemMelee) {
                ((ItemMelee)item).attack((EntityPlayer)player, false);
            } else if (item instanceof ItemGrenade) {
                ((ItemGrenade)item).attack((EntityPlayer)player, true);
            }
        }

        private static void onRightMouseButtonDown() {
            if (AnimationModeProcessor.getInstance().getFPSMode()) {
                return;
            }
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            Item item = ClientTicker.getHeldItemMainHand((EntityPlayer)player);
            if (item instanceof Weapon && BalancePackManager.isWeaponDisabled((Weapon)item)) {
                return;
            }
            if (item instanceof Weapon) {
                if (player.func_70051_ag()) {
                    player.func_70031_b(false);
                    KeyBinding.func_74510_a((int)ClientProxy.MC.field_71474_y.field_151444_V.func_151463_i(), (boolean)false);
                    ClientValueRepo.shouldContinueRunning = true;
                }
                ((Weapon)item).toggleAiming();
            } else if (item instanceof ItemMelee) {
                ((ItemMelee)item).attack((EntityPlayer)player, true);
            } else if (item instanceof ItemGrenade) {
                ((ItemGrenade)item).attack((EntityPlayer)player, false);
            }
        }

        private static void onLeftMouseButtonReleased() {
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            Item item = ClientTicker.getHeldItemMainHand((EntityPlayer)player);
            if (item instanceof Weapon && BalancePackManager.isWeaponDisabled((Weapon)item)) {
                return;
            }
            if (item instanceof Weapon) {
                ((Weapon)item).tryStopFire((EntityPlayer)player);
            } else if (item instanceof ItemGrenade) {
                ((ItemGrenade)item).attackUp((EntityPlayer)player, true);
            }
        }

        private static void onRightMouseButtonReleased() {
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            Item item = ClientTicker.getHeldItemMainHand((EntityPlayer)player);
            if (item instanceof Weapon && BalancePackManager.isWeaponDisabled((Weapon)item)) {
                return;
            }
            PlayerWeaponInstance mainHandHeldWeaponInstance = MWC.modContext.getMainHeldWeapon();
            if (mainHandHeldWeaponInstance != null && ModernConfigManager.holdToAim && item instanceof Weapon && mainHandHeldWeaponInstance.isAimed()) {
                if (ClientValueRepo.shouldContinueRunning) {
                    player.func_70031_b(true);
                    ClientValueRepo.shouldContinueRunning = false;
                }
                ((Weapon)item).toggleAiming();
            }
            if (item instanceof ItemGrenade) {
                ((ItemGrenade)item).attackUp((EntityPlayer)player, false);
            }
        }

        private static void tickHeldItem() {
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            Item item = ClientTicker.getHeldItemMainHand((EntityPlayer)player);
            if (item instanceof Updatable) {
                ((Updatable)item).update((EntityPlayer)player);
            }
        }

        private static Item getHeldItemMainHand(EntityPlayer player) {
            if (player == null) {
                return Items.field_190931_a;
            }
            return player.func_184614_ca().func_77973_b();
        }
    }
}

