/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.Temperature;
import toughasnails.temperature.modifier.TemperatureModifier;

public class TemperatureStorage
implements Capability.IStorage<ITemperature> {
    public NBTBase writeNBT(Capability<ITemperature> capability, ITemperature instance, EnumFacing side) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("temperatureLevel", instance.getTemperature().getRawValue());
        compound.func_74768_a("temperatureTimer", instance.getChangeTime());
        NBTTagList externalModifierList = new NBTTagList();
        for (TemperatureModifier.ExternalModifier modifier : instance.getExternalModifiers().values()) {
            externalModifierList.func_74742_a((NBTBase)modifier.serializeNBT());
        }
        compound.func_74782_a("ExternalModifiers", (NBTBase)externalModifierList);
        return compound;
    }

    public void readNBT(Capability<ITemperature> capability, ITemperature instance, EnumFacing side, NBTBase nbt) {
        if (!(nbt instanceof NBTTagCompound)) {
            throw new IllegalArgumentException("Temperature must be read from an NBTTagCompound!");
        }
        NBTTagCompound compound = (NBTTagCompound)nbt;
        if (compound.func_74764_b("temperatureLevel")) {
            instance.setTemperature(new Temperature(compound.func_74762_e("temperatureLevel")));
            instance.setChangeTime(compound.func_74762_e("temperatureTimer"));
            NBTTagList externalModifierTagList = compound.func_150295_c("ExternalModifiers", 10);
            HashMap externalModifierList = Maps.newHashMap();
            for (int i = 0; i < externalModifierTagList.func_74745_c(); ++i) {
                NBTTagCompound externalModifierCompound = externalModifierTagList.func_150305_b(i);
                TemperatureModifier.ExternalModifier modifier = new TemperatureModifier.ExternalModifier();
                modifier.deserializeNBT(externalModifierCompound);
                externalModifierList.put(modifier.getName(), modifier);
            }
            instance.setExternalModifiers(externalModifierList);
        }
    }
}

