/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import toughasnails.api.TANBlocks;
import toughasnails.api.item.TANItems;
import toughasnails.block.BlockTANCampfire;
import toughasnails.config.ConfigHandler;
import toughasnails.config.GameplayConfig;
import toughasnails.config.TemperatureConfig;
import toughasnails.config.json.ArmorTemperatureData;
import toughasnails.config.json.BlockStatePredicate;
import toughasnails.config.json.BlockTemperatureData;
import toughasnails.config.json.DrinkData;
import toughasnails.config.json.ItemPredicate;
import toughasnails.config.json.MaterialTemperatureData;
import toughasnails.init.ModCompat;
import toughasnails.util.config.JsonUtil;

public class ModConfig {
    public static List<ConfigHandler> configHandlers = Lists.newArrayList();
    public static Map<String, List<BlockTemperatureData>> blockTemperatureData = Maps.newHashMap();
    public static Map<String, List<DrinkData>> drinkData = Maps.newHashMap();
    public static List<ArmorTemperatureData> armorTemperatureData = Lists.newArrayList();
    public static MaterialTemperatureData materialTemperatureData;
    public static GameplayConfig gameplay;
    public static TemperatureConfig temperature;

    public static void preInit(File configDir) {
        gameplay = new GameplayConfig(new File(configDir, "gameplay.cfg"));
        temperature = new TemperatureConfig(new File(configDir, "temperature.cfg"));
    }

    public static void init(File configDir) {
        ArrayList defaultBlockTemperatureData = Lists.newArrayList((Object[])new BlockTemperatureData[]{new BlockTemperatureData(new BlockStatePredicate(TANBlocks.campfire.func_176223_P().func_177226_a((IProperty)BlockTANCampfire.BURNING, (Comparable)Boolean.valueOf(true)), Sets.newHashSet((Object[])new IProperty[]{BlockTANCampfire.BURNING})), 5.0f), new BlockTemperatureData(new BlockStatePredicate(Blocks.field_150470_am), 3.0f), new BlockTemperatureData(new BlockStatePredicate((Block)Blocks.field_150353_l), 15.0f), new BlockTemperatureData(new BlockStatePredicate((Block)Blocks.field_150356_k), 15.0f), new BlockTemperatureData(new BlockStatePredicate(Blocks.field_189877_df), 12.5f)});
        if (ModCompat.HOT_SPRING_WATER != null) {
            defaultBlockTemperatureData.add(new BlockTemperatureData(new BlockStatePredicate(ModCompat.HOT_SPRING_WATER), 5.0f));
        }
        List blockTempDataList = JsonUtil.getOrCreateConfigFile(configDir, "block_temperature.json", defaultBlockTemperatureData, new TypeToken<List<BlockTemperatureData>>(){}.getType());
        ModConfig.populateDataMap(blockTempDataList, blockTemperatureData, tempData -> tempData.predicate.getBlock().getRegistryName().toString());
        materialTemperatureData = JsonUtil.getOrCreateConfigFile(configDir, "material_temperature.json", new MaterialTemperatureData(), new TypeToken<MaterialTemperatureData>(){}.getType());
        ArrayList defaultDrinkData = Lists.newArrayList((Object[])new DrinkData[]{new DrinkData(new ItemPredicate(Items.field_151117_aB, 0), 6, 0.7f, 0.0f)});
        List drinkDataList = JsonUtil.getOrCreateConfigFile(configDir, "drink_stats.json", defaultDrinkData, new TypeToken<List<DrinkData>>(){}.getType());
        ModConfig.populateDataMap(drinkDataList, ModConfig.drinkData, drinkData -> drinkData.getPredicate().getItemStack().func_77973_b().getRegistryName().toString());
        armorTemperatureData = JsonUtil.getOrCreateConfigFile(configDir, "armor_temp_modifiers.json", Lists.newArrayList((Object[])new ArmorTemperatureData[]{new ArmorTemperatureData(Lists.newArrayList((Object[])new String[]{ModConfig.registryName(TANItems.jelled_slime_helmet), ModConfig.registryName(TANItems.jelled_slime_chestplate), ModConfig.registryName(TANItems.jelled_slime_leggings), ModConfig.registryName(TANItems.jelled_slime_boots)}), -1), new ArmorTemperatureData(Lists.newArrayList((Object[])new String[]{ModConfig.registryName(TANItems.wool_helmet), ModConfig.registryName(TANItems.wool_chestplate), ModConfig.registryName(TANItems.wool_leggings), ModConfig.registryName(TANItems.wool_boots)}), 1)}), new TypeToken<List<ArmorTemperatureData>>(){}.getType());
    }

    private static String registryName(Item item) {
        return item.getRegistryName().toString();
    }

    private static <T> void populateDataMap(List<T> dataList, Map<String, List<T>> dataMap, Function<T, String> keyGetter) {
        for (T data : dataList) {
            String key = keyGetter.apply(data);
            if (!dataMap.containsKey(key)) {
                dataMap.put(key, new ArrayList());
            }
            dataMap.get(key).add(data);
        }
    }
}

