/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.top;

import bletch.common.utils.TektopiaUtils;
import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import com.google.common.base.Function;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tangotek.tektopia.ProfessionType;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.entities.EntityArchitect;
import net.tangotek.tektopia.entities.EntityGuard;
import net.tangotek.tektopia.entities.EntityTradesman;
import net.tangotek.tektopia.entities.EntityVillagerTek;

public class TektopiaEntityTop {

    public static class getTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe probe;

        public Void apply(ITheOneProbe theOneProbe) {
            probe = theOneProbe;
            probe.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return "tektopiainformation:default";
                }

                public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
                    if (entity instanceof EntityVillagerTek) {
                        getTheOneProbe.addEntityVillagerTekInfo(mode, probeInfo, player, world, (EntityVillagerTek)entity, data);
                    }
                }
            });
            return null;
        }

        private static boolean addEntityVillagerTekInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, EntityVillagerTek entity, IProbeHitEntityData data) {
            if (ModConfig.top.useSneaking && mode == ProbeMode.NORMAL) {
                return false;
            }
            EntityVillagerTek villager = entity;
            String output = "";
            if (villager != null) {
                Village village;
                boolean showVillageDetails = false;
                if (villager instanceof EntityArchitect) {
                    showVillageDetails = true;
                } else if (villager instanceof EntityTradesman) {
                    showVillageDetails = true;
                } else if (villager.getProfessionType() != null) {
                    String profession = "";
                    int professionSkillLevel = 0;
                    ProfessionType professionType = villager.getProfessionType();
                    switch (professionType) {
                        case CHILD: 
                        case NITWIT: {
                            output = profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                            probeInfo.text(TextFormatting.DARK_AQUA + output);
                            showVillageDetails = true;
                            break;
                        }
                        case NOMAD: {
                            output = profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                            probeInfo.text(TextFormatting.DARK_AQUA + output);
                            break;
                        }
                        case GUARD: {
                            int professionBaseSkillLevel;
                            profession = villager instanceof EntityGuard && ((EntityGuard)villager).isCaptain() ? TextUtils.translate("entity." + ProfessionType.CAPTAIN.name + ".name", new Object[0]) : TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                            professionSkillLevel = villager.getSkill(professionType);
                            output = profession;
                            if (professionSkillLevel > 0) {
                                if (villager.getBlessed() > 0) {
                                    professionBaseSkillLevel = villager.getBaseSkill(professionType);
                                    output = output + " - level " + TextFormatting.GREEN + professionSkillLevel + TextFormatting.WHITE + " (" + professionBaseSkillLevel + ")";
                                } else {
                                    output = output + " - level " + TextFormatting.WHITE + professionSkillLevel;
                                }
                            }
                            probeInfo.text(TextFormatting.DARK_AQUA + output);
                            showVillageDetails = true;
                            break;
                        }
                        default: {
                            int professionBaseSkillLevel;
                            profession = TextUtils.translate("entity." + professionType.name + ".name", new Object[0]);
                            professionSkillLevel = villager.getSkill(professionType);
                            output = profession;
                            if (professionSkillLevel > 0) {
                                if (villager.getBlessed() > 0) {
                                    professionBaseSkillLevel = villager.getBaseSkill(professionType);
                                    output = output + " - level " + TextFormatting.GREEN + professionSkillLevel + TextFormatting.WHITE + " (" + professionBaseSkillLevel + ")";
                                } else {
                                    output = output + " - level " + TextFormatting.WHITE + professionSkillLevel;
                                }
                            }
                            probeInfo.text(TextFormatting.DARK_AQUA + output);
                            showVillageDetails = true;
                        }
                    }
                    int daysAlive = villager.getDaysAlive();
                    if (daysAlive > 0) {
                        output = TextUtils.translate("gui.villager.daysalive", new Object[0]) + " " + TextFormatting.WHITE + daysAlive;
                        probeInfo.text(TextFormatting.DARK_AQUA + output);
                    }
                    float health = villager.func_110143_aJ();
                    output = TextUtils.translate("gui.villager.health", new Object[0]) + " " + TextFormatting.WHITE + health;
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                    int hunger = villager.getHunger();
                    output = TextUtils.translate("gui.villager.hunger", new Object[0]) + " " + TextFormatting.WHITE + hunger;
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                    int happy = villager.getHappy();
                    output = TextUtils.translate("gui.villager.happy", new Object[0]) + " " + TextFormatting.WHITE + happy;
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                    int intelligence = villager.getIntelligence();
                    output = TextUtils.translate("gui.villager.intelligence", new Object[0]) + " " + TextFormatting.WHITE + intelligence;
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                    int blessed = villager.getBlessed();
                    if (blessed > 0) {
                        output = TextUtils.translate("gui.villager.blessedlevels", new Object[0]) + " " + TextFormatting.WHITE + blessed;
                        probeInfo.text(TextFormatting.DARK_AQUA + output);
                    }
                    boolean addProfessionCountShown = false;
                    for (ProfessionType addProfessionType : TektopiaUtils.getProfessionTypes()) {
                        if (addProfessionType == villager.getProfessionType()) continue;
                        profession = TextUtils.translate("entity." + addProfessionType.name + ".name", new Object[0]);
                        professionSkillLevel = villager.getSkill(addProfessionType);
                        if (professionSkillLevel <= 0) continue;
                        if (!addProfessionCountShown) {
                            output = TextUtils.translate("gui.villager.additionalprofessions", new Object[0]);
                            probeInfo.text(TextFormatting.WHITE + output);
                            addProfessionCountShown = true;
                        }
                        output = "\u2022 " + profession + " - " + TextFormatting.WHITE + professionSkillLevel;
                        probeInfo.text(TextFormatting.DARK_AQUA + output);
                    }
                }
                if (showVillageDetails && (village = villager.getVillage()) != null) {
                    String villageName = village.getName();
                    output = TextUtils.translate("gui.villager.villagename", new Object[0]) + " " + TextFormatting.WHITE + villageName;
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                    boolean hasBed = villager.getBedPos() != null;
                    output = TextUtils.translate("gui.villager.hasbed", new Object[0]) + " " + TextFormatting.WHITE + (hasBed ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS);
                    probeInfo.text(TextFormatting.DARK_AQUA + output);
                }
                return true;
            }
            return false;
        }
    }
}

