/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.tooltips;

import bletch.common.utils.TextUtils;
import bletch.tektopiainformation.core.ModConfig;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ParametersAreNonnullByDefault
public class TektopiaItemTooltip {
    public static final String KEY_SUFFIX = ".tooltip";

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltip(ItemTooltipEvent event) {
        List<String> value;
        if (ModConfig.tooltips.restrictToAdvancedTooltips && !event.getFlags().func_194127_a()) {
            return;
        }
        List tooltip = event.getToolTip();
        if (tooltip == null) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.func_77973_b();
        ResourceLocation registryName = item.getRegistryName();
        if (registryName == null) {
            return;
        }
        String resourceDomain = registryName.func_110624_b();
        if (!"tektopia".equalsIgnoreCase(resourceDomain)) {
            return;
        }
        String translateKey = itemStack.func_77977_a() + KEY_SUFFIX;
        if (ModConfig.debug.enableDebug && ModConfig.debug.showTooltipTranslationKey) {
            tooltip.add(TextUtils.translate("gui.translationkey", new Object[0]) + " " + translateKey);
        }
        if ((value = TextUtils.translateMulti(translateKey, new Object[0])) != null && value.size() > 0) {
            if (ModConfig.tooltips.useShiftKey && !GuiScreen.func_146272_n()) {
                value = null;
                if (ModConfig.tooltips.showShiftKeyInfo) {
                    value = TextUtils.translateMulti("gui.showshiftinfo", new Object[0]);
                }
            }
            if (value != null && value.size() > 0) {
                tooltip.addAll(value);
            }
        }
    }
}

