/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.messages;

import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.network.data.VillageData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class VillageMessageToClient
implements IMessage {
    private boolean messageIsValid;
    private VillageData villageData;

    public VillageMessageToClient() {
        this.messageIsValid = false;
        this.villageData = null;
    }

    public VillageMessageToClient(VillageData villageData) {
        this.messageIsValid = villageData != null;
        this.villageData = villageData;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public VillageData getVillageData() {
        return this.villageData;
    }

    public void fromBytes(ByteBuf buffer) {
        try {
            this.readBuffer(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            System.err.println("VillageMessageToClient.fromBytes threw an IOException: " + e.getLocalizedMessage());
        }
    }

    public void toBytes(ByteBuf buffer) {
        try {
            this.writeBuffer(new PacketBuffer(buffer));
        }
        catch (IOException e) {
            System.err.println("VillageMessageToClient.toBytes threw an IOException: " + e.getLocalizedMessage());
        }
    }

    private void readBuffer(PacketBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        NBTTagCompound nbtTag = null;
        try {
            nbtTag = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)buffer), (NBTSizeTracker)new NBTSizeTracker((long)ModConfig.gui.maxNBTReadSize));
        }
        catch (IOException e) {
            nbtTag = null;
        }
        if (nbtTag == null) {
            return;
        }
        this.villageData = new VillageData();
        this.villageData.readNBT(nbtTag);
        this.messageIsValid = true;
    }

    private void writeBuffer(PacketBuffer buffer) throws IOException {
        if (!this.messageIsValid || this.villageData == null) {
            return;
        }
        NBTTagCompound nbtTag = this.villageData.writeNBT(new NBTTagCompound());
        if (nbtTag == null || nbtTag.func_82582_d()) {
            return;
        }
        buffer.func_150786_a(nbtTag);
    }
}

