/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.handlers;

import bletch.tektopiainformation.TektopiaInformation;
import bletch.tektopiainformation.core.ModConfig;
import bletch.tektopiainformation.network.data.VillageData;
import bletch.tektopiainformation.network.messages.VillageMessageToClient;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.VillageManager;
import net.tangotek.tektopia.entities.EntityVillageNavigator;

public class PlayerInteractHandler {
    private static Map<UUID, Long> playerTimeouts = new HashMap<UUID, Long>();

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == Side.CLIENT) {
            return;
        }
        if (event.getSide() == Side.SERVER && ModConfig.gui.enableGuiIntegration && ModConfig.gui.tektopiaInformationBook.enableTektopiaInformationBook) {
            EntityPlayerMP player;
            EntityVillageNavigator villageEntity;
            Village village;
            ItemStack itemInHand;
            Entity entity = event.getTarget();
            if (entity instanceof EntityVillageNavigator && !(itemInHand = event.getEntityPlayer().func_184586_b(event.getHand())).func_190926_b() && itemInHand.func_77973_b() == Item.func_111206_d((String)"minecraft:book") && (village = (villageEntity = (EntityVillageNavigator)event.getTarget()).getVillage()) != null && village.isLoaded()) {
                if (event.isCancelable()) {
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setResult(Event.Result.ALLOW);
                    event.setCanceled(true);
                }
                player = (EntityPlayerMP)event.getEntityPlayer();
                this.SendMessage(player, village, null, null, villageEntity);
            }
            if (entity instanceof EntityItemFrame && !(itemInHand = event.getEntityPlayer().func_184586_b(event.getHand())).func_190926_b() && itemInHand.func_77973_b() == Item.func_111206_d((String)"minecraft:book")) {
                Village village2 = null;
                VillageManager villageManager = VillageManager.get((World)event.getWorld());
                if (villageManager != null) {
                    village2 = villageManager.getVillageAt(event.getPos());
                }
                if (village2 != null) {
                    if (event.isCancelable()) {
                        event.setCancellationResult(EnumActionResult.SUCCESS);
                        event.setResult(Event.Result.ALLOW);
                        event.setCanceled(true);
                    }
                    player = (EntityPlayerMP)event.getEntityPlayer();
                    this.SendMessage(player, village2, event.getPos(), null, null);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack itemInHand;
        Block block;
        if (event.getSide() == Side.CLIENT) {
            return;
        }
        if (event.getSide() == Side.SERVER && ModConfig.gui.enableGuiIntegration && ModConfig.gui.tektopiaInformationBook.enableTektopiaInformationBook && (block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) instanceof BlockBed && !(itemInHand = event.getEntityPlayer().func_184586_b(event.getHand())).func_190926_b() && itemInHand.func_77973_b() == Item.func_111206_d((String)"minecraft:book")) {
            Village village = null;
            VillageManager villageManager = VillageManager.get((World)event.getWorld());
            if (villageManager != null) {
                village = villageManager.getVillageAt(event.getPos());
            }
            if (village != null) {
                if (event.isCancelable()) {
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                    event.setResult(Event.Result.ALLOW);
                    event.setCanceled(true);
                }
                EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
                this.SendMessage(player, village, null, event.getPos(), null);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
    }

    private void SendMessage(EntityPlayerMP player, Village village, BlockPos framePosition, BlockPos bedPosition, EntityVillageNavigator entity) {
        long currentSeconds;
        long previousSeconds = playerTimeouts.getOrDefault(player.func_110124_au(), 0L);
        if (previousSeconds + (long)ModConfig.gui.tektopiaInformationBook.bookGracePeriod > (currentSeconds = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC))) {
            return;
        }
        VillageData villageData = new VillageData(village, player.func_180425_c());
        if (framePosition != null) {
            villageData.setFramePosition(framePosition);
        }
        if (bedPosition != null) {
            villageData.setBedPosition(bedPosition);
        }
        if (entity != null) {
            villageData.setEntity(entity);
        }
        VillageMessageToClient message = new VillageMessageToClient(villageData);
        TektopiaInformation.NETWORK.sendTo((IMessage)message, player);
        playerTimeouts.put(player.func_110124_au(), currentSeconds);
    }
}

