/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.network.data;

import bletch.common.utils.TektopiaUtils;
import bletch.tektopiainformation.network.data.StructureData;
import bletch.tektopiainformation.network.data.VillageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.structures.VillageStructure;
import net.tangotek.tektopia.structures.VillageStructureType;

public class StructuresData {
    protected static final String NBTTAG_VILLAGE_STRUCTURES = "structures";
    protected static final String NBTTAG_VILLAGE_STRUCTURESLIST = "list";
    protected static final String NBTTAG_VILLAGE_STRUCTURETYPECOUNTS = "types";
    protected static final String NBTTAG_VILLAGE_STRUCTURETYPENAME = "name";
    protected static final String NBTTAG_VILLAGE_STRUCTURETYPECOUNT = "count";
    protected VillageData villageData;
    protected List<StructureData> structures;
    protected Map<VillageStructureType, Integer> structureTypeCounts;

    public StructuresData() {
        this.populateData(null, null);
    }

    protected VillageData getVillageData() {
        return this.villageData;
    }

    public int getStructuresCount() {
        return this.structures == null ? 0 : this.structures.size();
    }

    public List<StructureData> getStructures() {
        return this.structures == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.structures.stream().sorted(Comparator.comparing(c -> c.getStructureType().name()).thenComparing(StructureData::getFramePosition)).collect(Collectors.toList()));
    }

    public List<StructureData> getStructuresByType(VillageStructureType structureType) {
        return this.structures == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.structures.stream().filter(s -> structureType != null && structureType.equals((Object)s.getStructureType())).sorted(Comparator.comparing(StructureData::getFramePosition)).collect(Collectors.toList()));
    }

    public List<StructureData> getStructuresOvercrowded() {
        return this.structures == null ? Collections.unmodifiableList(new ArrayList()) : Collections.unmodifiableList(this.structures.stream().filter(s -> s.isOvercrowded()).sorted(Comparator.comparing(StructureData::getStructureTypeName)).collect(Collectors.toList()));
    }

    public StructureData getStructure(int index) {
        return this.structures == null ? null : this.structures.get(index);
    }

    public StructureData getStructureById(int structureId) {
        return this.structures == null ? null : (StructureData)this.structures.stream().filter(r -> structureId > 0 && structureId == r.getStructureId()).findFirst().orElse(null);
    }

    public StructureData getStructureByFramePosition(BlockPos framePosition) {
        return this.structures == null ? null : (StructureData)this.structures.stream().filter(h -> framePosition != null && framePosition.equals((Object)h.getFramePosition())).findFirst().orElse(null);
    }

    public Map<VillageStructureType, Integer> getStructureTypeCounts() {
        return this.structureTypeCounts == null ? Collections.unmodifiableMap(new LinkedHashMap()) : Collections.unmodifiableMap(this.structureTypeCounts.entrySet().stream().sorted(Comparator.comparing(c -> ((VillageStructureType)c.getKey()).name())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)));
    }

    public int getStructureTypeCount(VillageStructureType structureType) {
        return structureType != null && this.structureTypeCounts != null && this.structureTypeCounts.containsKey(structureType) ? this.structureTypeCounts.get(structureType) : 0;
    }

    public StructureData getTownHall() {
        return this.structures == null ? null : (StructureData)this.structures.stream().filter(h -> h.getStructureType() == VillageStructureType.TOWNHALL).findFirst().orElse(null);
    }

    protected void clearData() {
        this.structures = new ArrayList<StructureData>();
        this.structureTypeCounts = new LinkedHashMap<VillageStructureType, Integer>();
    }

    public void populateData(VillageData villageData, Village village) {
        this.clearData();
        this.villageData = villageData;
        if (village != null) {
            Map<VillageStructureType, List<VillageStructure>> structuresList = TektopiaUtils.getVillageStructures(village);
            for (Map.Entry<VillageStructureType, List<VillageStructure>> entry : structuresList.entrySet()) {
                List<VillageStructure> structures = structuresList.get(entry.getKey());
                this.structureTypeCounts.put(entry.getKey(), structures.size());
                for (VillageStructure structure : structures) {
                    this.structures.add(new StructureData(villageData, structure));
                }
            }
        }
    }

    public void readNBT(VillageData villageData, NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        this.clearData();
        this.villageData = villageData;
        if (nbtTag.func_74764_b(NBTTAG_VILLAGE_STRUCTURES)) {
            int index;
            NBTTagCompound nbtStructuresData = nbtTag.func_74775_l(NBTTAG_VILLAGE_STRUCTURES);
            if (nbtStructuresData.func_74764_b(NBTTAG_VILLAGE_STRUCTURETYPECOUNTS)) {
                NBTTagList nbtTagListStructureCounts = nbtStructuresData.func_150295_c(NBTTAG_VILLAGE_STRUCTURETYPECOUNTS, 10);
                for (index = 0; index < nbtTagListStructureCounts.func_74745_c(); ++index) {
                    NBTTagCompound nbtTagStructureCount = nbtTagListStructureCounts.func_150305_b(index);
                    VillageStructureType structureType = VillageStructureType.valueOf((String)nbtTagStructureCount.func_74779_i(NBTTAG_VILLAGE_STRUCTURETYPENAME));
                    this.structureTypeCounts.put(structureType, nbtTagStructureCount.func_74762_e(NBTTAG_VILLAGE_STRUCTURETYPECOUNT));
                }
            }
            if (nbtStructuresData.func_74764_b(NBTTAG_VILLAGE_STRUCTURESLIST)) {
                NBTTagList nbtTagListStructures = nbtStructuresData.func_150295_c(NBTTAG_VILLAGE_STRUCTURESLIST, 10);
                for (index = 0; index < nbtTagListStructures.func_74745_c(); ++index) {
                    this.structures.add(new StructureData(villageData, nbtTagListStructures.func_150305_b(index)));
                }
            }
        }
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbtTag) {
        if (nbtTag == null) {
            nbtTag = new NBTTagCompound();
        }
        NBTTagCompound nbtStructuresData = new NBTTagCompound();
        if (this.structureTypeCounts != null && this.structureTypeCounts.size() > 0) {
            NBTTagList nbtTagListStructureCounts = new NBTTagList();
            for (Map.Entry entry : this.structureTypeCounts.entrySet()) {
                NBTTagCompound nbtTagStructureCount = new NBTTagCompound();
                nbtTagStructureCount.func_74778_a(NBTTAG_VILLAGE_STRUCTURETYPENAME, ((VillageStructureType)entry.getKey()).name());
                nbtTagStructureCount.func_74768_a(NBTTAG_VILLAGE_STRUCTURETYPECOUNT, ((Integer)entry.getValue()).intValue());
                nbtTagListStructureCounts.func_74742_a((NBTBase)nbtTagStructureCount);
            }
            if (!nbtTagListStructureCounts.func_82582_d()) {
                nbtStructuresData.func_74782_a(NBTTAG_VILLAGE_STRUCTURETYPECOUNTS, (NBTBase)nbtTagListStructureCounts);
            }
        }
        if (this.structures != null && this.structures.size() > 0) {
            NBTTagList nbtTagListHomes = new NBTTagList();
            for (StructureData structureData : this.structures) {
                NBTTagCompound nbtTagStructure = structureData.writeNBT(new NBTTagCompound());
                if (nbtTagStructure.func_82582_d()) continue;
                nbtTagListHomes.func_74742_a((NBTBase)nbtTagStructure);
            }
            if (!nbtTagListHomes.func_82582_d()) {
                nbtStructuresData.func_74782_a(NBTTAG_VILLAGE_STRUCTURESLIST, (NBTBase)nbtTagListHomes);
            }
        }
        if (!nbtStructuresData.func_82582_d()) {
            nbtTag.func_74782_a(NBTTAG_VILLAGE_STRUCTURES, (NBTBase)nbtStructuresData);
        }
        return nbtTag;
    }
}

