/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiainformation.core;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Config(modid="tektopiainformation", category="")
@ParametersAreNonnullByDefault
public class ModConfig {
    @Config.LangKey(value="config.debug")
    public static final Debug debug = new Debug();
    @Config.LangKey(value="config.tooltips")
    public static final Tooltips tooltips = new Tooltips();
    @Config.LangKey(value="config.jei")
    public static final Jei jei = new Jei();
    @Config.LangKey(value="config.waila")
    public static final Waila waila = new Waila();
    @Config.LangKey(value="config.top")
    public static final TheOneProbe top = new TheOneProbe();
    @Config.LangKey(value="config.gui")
    public static final GuiSettings gui = new GuiSettings();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.getModID().equals("tektopiainformation")) {
            ConfigManager.sync((String)"tektopiainformation", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class GuiSettings {
        @Config.LangKey(value="config.gui.tektopiaInformationBook")
        public final TektopiaInformationBook tektopiaInformationBook = new TektopiaInformationBook();
        @Config.Comment(value={"If true, will integrate with the GUI."})
        @Config.LangKey(value="config.gui.enableGuiIntegration")
        @Config.RequiresMcRestart
        public boolean enableGuiIntegration = true;
        @Config.Comment(value={"The maximum amount of bytes allowed to be transferred via the village NBT packet buffer."})
        @Config.LangKey(value="config.gui.maxNBTReadSize")
        @Config.RangeInt(min=2000000, max=10000000)
        public int maxNBTReadSize = 5000000;

        public static class TektopiaInformationBook {
            @Config.Comment(value={"If true, will show the TekTopia Information Book when the player right-clicks a villager with a book in hand. When connected to a server, both the client and server must have this option enabled to display to information book."})
            @Config.LangKey(value="config.gui.tektopiaInformationBook.enableTektopiaInformationBook")
            public boolean enableTektopiaInformationBook = true;
            @Config.Comment(value={"If true, opening the book will pause the game when in single-player."})
            @Config.LangKey(value="config.gui.tektopiaInformationBook.doesGuiPauseGame")
            public boolean doesGuiPauseGame = true;
            @Config.Comment(value={"If true, enemies will be shown in the book; otherwise the enemies section will be blank."})
            @Config.LangKey(value="config.gui.tektopiaInformationBook.showEnemies")
            public boolean showEnemies = true;
            @Config.Comment(value={"The number of seconds to wait before the book can be reopened."})
            @Config.LangKey(value="config.gui.tektopiaInformationBook.bookGracePeriod")
            @Config.RangeInt(min=0, max=60)
            public int bookGracePeriod = 0;
        }
    }

    public static class TheOneProbe {
        @Config.LangKey(value="config.top.blocks")
        public final Blocks blocks = new Blocks();
        @Config.LangKey(value="config.top.entities")
        public final Entities entities = new Entities();
        @Config.Comment(value={"If true, will integrate with The One Probe."})
        @Config.LangKey(value="config.top.enableTopIntegration")
        @Config.RequiresMcRestart
        public boolean enableTopIntegration = true;
        @Config.Comment(value={"If true, will only show information when Sneaking."})
        @Config.LangKey(value="config.top.useSneaking")
        public boolean useSneaking = true;

        public static class Entities {
            @Config.Comment(value={"If true, will show the entity information in The One Probe."})
            @Config.LangKey(value="config.top.entities.showEntityInformation")
            public boolean showEntityInformation = true;
        }

        public static class Blocks {
            @Config.Comment(value={"If true, will show the block tooltip in The One Probe."})
            @Config.LangKey(value="config.top.blocks.showBlockTooltip")
            public boolean showBlockTooltip = true;
            @Config.Comment(value={"If true, will show the block information in The One Probe."})
            @Config.LangKey(value="config.top.blocks.showBlockInformation")
            public boolean showBlockInformation = true;
        }
    }

    public static class Waila {
        @Config.LangKey(value="config.waila.blocks")
        public final Blocks blocks = new Blocks();
        @Config.LangKey(value="config.waila.entities")
        public final Entities entities = new Entities();
        @Config.Comment(value={"If true, will integrate with Waila."})
        @Config.LangKey(value="config.waila.enableWailaIntegration")
        @Config.RequiresMcRestart
        public boolean enableWailaIntegration = true;
        @Config.Comment(value={"If true, will only show information when Sneaking."})
        @Config.LangKey(value="config.waila.useSneaking")
        public boolean useSneaking = false;

        public static class Entities {
            @Config.Comment(value={"If true, will show the entity information in Waila."})
            @Config.LangKey(value="config.waila.entities.showEntityInformation")
            public boolean showEntityInformation = true;
        }

        public static class Blocks {
            @Config.Comment(value={"If true, will show the block tooltip in Waila."})
            @Config.LangKey(value="config.waila.blocks.showBlockTooltip")
            public boolean showBlockTooltip = true;
            @Config.Comment(value={"If true, will show the block information in Waila."})
            @Config.LangKey(value="config.waila.blocks.showBlockInformation")
            public boolean showBlockInformation = true;
        }
    }

    public static class Jei {
        @Config.Comment(value={"If true, will integrate with JEI."})
        @Config.LangKey(value="config.jei.enableJeiIntegration")
        @Config.RequiresMcRestart
        public boolean enableJeiIntegration = true;
        @Config.Comment(value={"If true, will show the information tab in JEI."})
        @Config.LangKey(value="config.jei.showJeiInformationTab")
        @Config.RequiresMcRestart
        public boolean showJeiInformationTab = true;
    }

    public static class Tooltips {
        @Config.Comment(value={"If true, will integrate with item tooltips."})
        @Config.LangKey(value="config.tooltips.enableTooltipIntegration")
        @Config.RequiresMcRestart
        public boolean enableTooltipIntegration = true;
        @Config.Comment(value={"If true, will only show tooltip information when Shift key pressed."})
        @Config.LangKey(value="config.tooltips.useShiftKey")
        public boolean useShiftKey = true;
        @Config.Comment(value={"If true, will only show tooltip information when Advanced Tooltips enabled (F3+H)."})
        @Config.LangKey(value="config.tooltips.restrictToAdvancedTooltips")
        public boolean restrictToAdvancedTooltips = false;
        @Config.Comment(value={"If true, will show the hold shift key for more information."})
        @Config.LangKey(value="config.tooltips.showShiftKeyInfo")
        public boolean showShiftKeyInfo = true;
    }

    public static class Debug {
        @Config.Comment(value={"If true, debug information will be output to the console."})
        @Config.LangKey(value="config.debug.enableDebug")
        public boolean enableDebug = false;
        @Config.Comment(value={"If true, will register new commands for debug use."})
        @Config.LangKey(value="config.debug.enableDebugCommands")
        @Config.RequiresWorldRestart
        public boolean enableDebugCommands = false;
        @Config.Comment(value={"If true, the item translation key will be show in the tooltip."})
        @Config.LangKey(value="config.debug.showTooltipTranslationKey")
        public boolean showTooltipTranslationKey = false;
        @Config.Comment(value={"If true, any blocks/items that are missing an Information record will be output to the console."})
        @Config.LangKey(value="config.debug.showJeiBlocksMissingInformation")
        @Config.RequiresMcRestart
        public boolean showJeiMissingInformation = false;
        @Config.Comment(value={"If true, any blocks/items that register an Information record will be output to the console."})
        @Config.LangKey(value="config.debug.showJeiBlocksRegisteredInformation")
        @Config.RequiresMcRestart
        public boolean showJeiRegisteredInformation = false;
        @Config.Comment(value={"If true, any blocks/items that are missing an Information record will be registered."})
        @Config.LangKey(value="config.debug.registerJeiBlocksMissingInformation")
        @Config.RequiresMcRestart
        public boolean registerJeiMissingInformation = false;
        @Config.Comment(value={"If true, the block translation key will be show in The One Probe."})
        @Config.LangKey(value="config.debug.showTopBlockTranslationKey")
        public boolean showTopBlockTranslationKey = false;
        @Config.Comment(value={"If true, any blocks that are registered will be output to the console."})
        @Config.LangKey(value="config.debug.showWailaBlocksRegistered")
        @Config.RequiresMcRestart
        public boolean showWailaBlocksRegistered = false;
        @Config.Comment(value={"If true, the block translation key will be show in Waila."})
        @Config.LangKey(value="config.debug.showWailaBlockTranslationKey")
        public boolean showWailaBlockTranslationKey = false;
        @Config.Comment(value={"If true, any entities that are registered will be output to the console."})
        @Config.LangKey(value="config.debug.showWailaEntitiesRegistered")
        @Config.RequiresMcRestart
        public boolean showWailaEntitiesRegistered = false;
    }
}

