/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.nio.FloatBuffer;
import java.util.Locale;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public class RenderableObject {
    public static final float Z_BUFFER_OFFSET = 2.0E-4f;
    public final String name;
    public String texture;
    public final ColorRGB color;
    public float alpha = 1.0f;
    public FloatBuffer vertices;
    public final boolean cacheVertices;
    public boolean changedSinceLastRender;
    public boolean isTranslucent;
    public int cachedVertexIndex = -1;
    public int worldLightValue;
    public boolean isLines = false;
    public final TransformationMatrix transform = new TransformationMatrix();
    public boolean disableLighting;
    public boolean ignoreWorldShading;
    public boolean enableBrightBlending;
    public static final String GLOBAL_TEXTURE_NAME = "GLOBAL";
    private static final int[][] FACE_POINT_INDEXES = new int[][]{{0, 1, 3, 2}, {5, 4, 6, 7}, {6, 2, 3, 7}, {5, 1, 0, 4}, {4, 0, 2, 6}, {1, 5, 7, 3}};
    private static final float[][] FACE_NORMALS = new float[][]{{-1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, 0.0f, 1.0f}};
    private static final int[][] WIREFRAME_POINT_INDEXES = new int[][]{{0, 1}, {4, 5}, {0, 4}, {1, 5}, {2, 3}, {6, 7}, {2, 6}, {3, 7}, {0, 2}, {1, 3}, {4, 6}, {5, 7}};
    private static final int BUFFERS_PER_LINE = 6;
    private static final int BUFFERS_PER_VERTEX = 8;
    private static final int BUFFERS_PER_FACE = 24;
    private static final int BUFFERS_PER_HOLGRAPHIC_BOX = 288;
    private static final int BUFFERS_PER_WIREFRAME_BOX = 72;

    public RenderableObject(String name, String texture, ColorRGB color, FloatBuffer vertices, boolean cacheVertices) {
        this.name = name;
        this.texture = texture;
        this.color = color;
        this.cacheVertices = cacheVertices;
        this.isTranslucent = name.toLowerCase(Locale.ROOT).contains("translucent") || texture != null && (texture.toLowerCase(Locale.ROOT).contains("translucent") || texture.endsWith("_lit.png"));
        this.vertices = vertices;
        this.transform.resetTransforms();
    }

    public RenderableObject(ColorRGB color, int numberLines) {
        this("", null, color, FloatBuffer.allocate(numberLines * 6), false);
        this.isLines = true;
        this.disableLighting = true;
    }

    public RenderableObject(ColorRGB color, boolean holgraphic) {
        this("", holgraphic ? "mts:textures/rendering/holobox.png" : null, color, FloatBuffer.allocate(holgraphic ? 288 : 72), false);
        if (holgraphic) {
            this.isTranslucent = true;
            this.alpha = 0.5f;
        } else {
            this.isLines = true;
        }
        this.disableLighting = true;
    }

    public boolean equals(Object object) {
        if (object instanceof RenderableObject) {
            RenderableObject otherProperties = (RenderableObject)object;
            return this.texture.equals(otherProperties.texture) && this.color.equals(otherProperties.color);
        }
        return false;
    }

    public void setAlpha(float alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            this.changedSinceLastRender = true;
        }
    }

    public void setColor(ColorRGB color) {
        if (!this.color.equals(color)) {
            this.color.setTo(color);
            this.changedSinceLastRender = true;
        }
    }

    public void render(Object objectAssociatedTo) {
        InterfaceManager.renderingInterface.renderVertices(this, objectAssociatedTo);
    }

    public void addLine(Point3D point1, Point3D point2) {
        this.vertices.put((float)point1.x);
        this.vertices.put((float)point1.y);
        this.vertices.put((float)point1.z);
        this.vertices.put((float)point2.x);
        this.vertices.put((float)point2.y);
        this.vertices.put((float)point2.z);
    }

    public void setHolographicBoundingBox(BoundingBox box) {
        float[][] points = box.getEdgePoints();
        for (int i = 0; i < 6; ++i) {
            block6: for (int j = 0; j < 6; ++j) {
                this.vertices.put(FACE_NORMALS[i]);
                this.vertices.put(0.0f);
                this.vertices.put(0.0f);
                switch (j) {
                    case 3: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][0]]);
                        continue block6;
                    }
                    case 4: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][2]]);
                        continue block6;
                    }
                    case 5: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][3]]);
                        continue block6;
                    }
                    default: {
                        this.vertices.put(points[FACE_POINT_INDEXES[i][j]]);
                    }
                }
            }
        }
        this.normalizeUVs();
        this.vertices.flip();
    }

    public void setWireframeBoundingBox(BoundingBox box) {
        float[][] points = box.getEdgePoints();
        for (int[] indexes : WIREFRAME_POINT_INDEXES) {
            this.vertices.put(points[indexes[0]]);
            this.vertices.put(points[indexes[1]]);
        }
        this.vertices.flip();
    }

    public void normalizeUVs() {
        int verticesInObject = this.vertices.capacity() / 8;
        block11: for (int i = 0; i < verticesInObject; ++i) {
            if (verticesInObject > 3 && i % 6 >= 3) {
                switch (i % 6) {
                    case 3: {
                        this.vertices.put(i * 8 + 3, 0.0f);
                        this.vertices.put(i * 8 + 4, 0.0f);
                        break;
                    }
                    case 4: {
                        this.vertices.put(i * 8 + 3, 1.0f);
                        this.vertices.put(i * 8 + 4, 1.0f);
                        break;
                    }
                    case 5: {
                        this.vertices.put(i * 8 + 3, 1.0f);
                        this.vertices.put(i * 8 + 4, 0.0f);
                    }
                }
                continue;
            }
            switch (i % 6) {
                case 0: 
                case 5: {
                    this.vertices.put(i * 8 + 3, 0.0f);
                    this.vertices.put(i * 8 + 4, 0.0f);
                    continue block11;
                }
                case 1: {
                    this.vertices.put(i * 8 + 3, 0.0f);
                    this.vertices.put(i * 8 + 4, 1.0f);
                    continue block11;
                }
                case 2: 
                case 3: {
                    this.vertices.put(i * 8 + 3, 1.0f);
                    this.vertices.put(i * 8 + 4, 1.0f);
                    continue block11;
                }
                case 4: {
                    this.vertices.put(i * 8 + 3, 1.0f);
                    this.vertices.put(i * 8 + 4, 0.0f);
                }
            }
        }
    }

    public void destroy(Object objectAssociatedTo) {
        InterfaceManager.renderingInterface.deleteVertices(this, objectAssociatedTo);
    }
}

