/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.rendering.ModelParserLT;
import minecrafttransportsimulator.rendering.ModelParserOBJ;
import minecrafttransportsimulator.rendering.RenderableModelObject;
import minecrafttransportsimulator.rendering.RenderableObject;

public abstract class AModelParser {
    private static final Map<String, AModelParser> parsers = new HashMap<String, AModelParser>();
    public static final String WINDOW_OBJECT_NAME = "window";
    public static final String ONLINE_TEXTURE_OBJECT_NAME = "url";
    public static final String TRANSLUCENT_OBJECT_NAME = "translucent";

    public AModelParser() {
        parsers.put(this.getModelSuffix(), this);
    }

    protected abstract String getModelSuffix();

    protected abstract List<RenderableObject> parseModelInternal(String var1);

    public static List<RenderableObject> parseModel(String modelLocation) {
        AModelParser parser = parsers.get(modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
        if (parser != null) {
            return parser.parseModelInternal(modelLocation);
        }
        throw new IllegalArgumentException("No parser found for model format of " + modelLocation.substring(modelLocation.lastIndexOf(".") + 1));
    }

    public static List<RenderableModelObject> generateRenderables(AEntityD_Definable<?> entity) {
        String modelLocation = ((AJSONMultiModelProvider)entity.definition).getModelLocation(entity.subDefinition);
        ArrayList<RenderableModelObject> modelObjects = new ArrayList<RenderableModelObject>();
        for (RenderableObject parsedObject : AModelParser.parseModel(modelLocation)) {
            modelObjects.add(new RenderableModelObject(modelLocation, parsedObject));
        }
        return modelObjects;
    }

    static {
        new ModelParserOBJ();
        new ModelParserLT();
    }
}

