/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packloading;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityRoad;
import minecrafttransportsimulator.items.instances.ItemPoleComponent;
import minecrafttransportsimulator.jsondefs.AJSONBase;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.AJSONMultiModelProvider;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONAnimatedObject;
import minecrafttransportsimulator.jsondefs.JSONAnimationDefinition;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.jsondefs.JSONCollisionBox;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.jsondefs.JSONConfigSettings;
import minecrafttransportsimulator.jsondefs.JSONConnection;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONCraftingBench;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONDoor;
import minecrafttransportsimulator.jsondefs.JSONInstrument;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONLight;
import minecrafttransportsimulator.jsondefs.JSONMuzzle;
import minecrafttransportsimulator.jsondefs.JSONMuzzleGroup;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONParticle;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONRendering;
import minecrafttransportsimulator.jsondefs.JSONRoadComponent;
import minecrafttransportsimulator.jsondefs.JSONSkin;
import minecrafttransportsimulator.jsondefs.JSONSound;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.AModelParser;
import minecrafttransportsimulator.rendering.RenderableObject;
import minecrafttransportsimulator.rendering.TreadRoller;
import minecrafttransportsimulator.systems.ConfigSystem;

public final class LegacyCompatSystem {
    public static void performLegacyCompats(AJSONBase definition) {
        AJSONMultiModelProvider provider;
        if (definition instanceof AJSONItem) {
            AJSONItem item = (AJSONItem)definition;
            if (item.general.materials != null) {
                item.general.materialLists = new ArrayList<List<String>>();
                item.general.materialLists.add(item.general.materials);
                item.general.materials = null;
            } else if (item.general.materialLists == null) {
                item.general.materialLists = new ArrayList<List<String>>();
                item.general.materialLists.add(new ArrayList());
            }
            if (item.general.repairMaterials != null) {
                item.general.repairMaterialLists = new ArrayList<List<String>>();
                item.general.repairMaterialLists.add(item.general.repairMaterials);
                item.general.repairMaterials = null;
            }
        }
        if (definition instanceof AJSONMultiModelProvider) {
            provider = (AJSONMultiModelProvider)definition;
            if (provider.definitions == null) {
                provider.definitions = new ArrayList<JSONSubDefinition>();
                JSONSubDefinition subDef = new JSONSubDefinition();
                subDef.extraMaterialLists = new ArrayList<List<String>>();
                provider.general.materialLists.forEach(entry -> subDef.extraMaterialLists.add(new ArrayList()));
                subDef.name = provider.general.name;
                subDef.subName = "";
                provider.definitions.add(subDef);
            }
            if (provider.general.modelName != null) {
                for (JSONSubDefinition subDef : provider.definitions) {
                    subDef.modelName = provider.general.modelName;
                }
                provider.general.modelName = null;
            }
            for (JSONSubDefinition subDef : provider.definitions) {
                if (subDef.extraMaterials == null) continue;
                subDef.extraMaterialLists = new ArrayList<List<String>>();
                subDef.extraMaterialLists.add(subDef.extraMaterials);
                subDef.extraMaterials = null;
            }
            if (provider.rendering == null) {
                provider.rendering = new JSONRendering();
            }
            if (provider.rendering.modelType == null) {
                provider.rendering.modelType = JSONRendering.ModelType.OBJ;
            }
            if (provider.rendering != null && provider.rendering.constants != null) {
                provider.constants = provider.rendering.constants;
                provider.rendering.constants = null;
            }
            if (provider.rendering != null && provider.rendering.initialVariables != null) {
                provider.initialVariables = provider.rendering.initialVariables;
                provider.rendering.initialVariables = null;
            }
            if (provider.constants != null) {
                provider.constantValues = new HashMap<String, Double>();
                provider.constants.forEach(key -> provider.constantValues.put((String)key, 1.0));
                provider.constants = null;
            }
        }
        if (definition instanceof JSONVehicle) {
            LegacyCompatSystem.performVehicleLegacyCompats((JSONVehicle)definition);
        } else if (definition instanceof JSONPart) {
            LegacyCompatSystem.performPartLegacyCompats((JSONPart)definition);
        } else if (definition instanceof JSONInstrument) {
            LegacyCompatSystem.performInstrumentLegacyCompats((JSONInstrument)definition);
        } else if (definition instanceof JSONPoleComponent) {
            LegacyCompatSystem.performPoleLegacyCompats((JSONPoleComponent)definition);
        } else if (definition instanceof JSONDecor) {
            LegacyCompatSystem.performDecorLegacyCompats((JSONDecor)definition);
        } else if (definition instanceof JSONRoadComponent) {
            LegacyCompatSystem.performRoadLegacyCompats((JSONRoadComponent)definition);
        } else if (definition instanceof JSONItem) {
            LegacyCompatSystem.performItemLegacyCompats((JSONItem)definition);
        } else if (definition instanceof JSONSkin) {
            LegacyCompatSystem.performSkinLegacyCompats((JSONSkin)definition);
        } else if (definition instanceof JSONBullet) {
            LegacyCompatSystem.performBulletLegacyCompats((JSONBullet)definition);
        }
        if (definition instanceof AJSONMultiModelProvider) {
            provider = (AJSONMultiModelProvider)definition;
            if (ConfigSystem.settings != null && ((Boolean)ConfigSystem.settings.general.doLegacyLightCompats.value).booleanValue() && !(definition instanceof JSONSkin) && provider.rendering.modelType.equals((Object)JSONRendering.ModelType.OBJ)) {
                LegacyCompatSystem.performModelLegacyCompats((AJSONMultiModelProvider)definition);
            }
            if (provider instanceof JSONVehicle) {
                JSONVehicle vehicleDef = (JSONVehicle)provider;
                if (vehicleDef.motorized.litVariable == null) {
                    vehicleDef.motorized.litVariable = vehicleDef.motorized.hasRunningLights ? "running_light" : (vehicleDef.motorized.hasHeadlights ? "headlight" : (vehicleDef.motorized.hasNavLights ? "navigation_light" : (vehicleDef.motorized.hasStrobeLights ? "strobe_light" : (vehicleDef.motorized.hasTaxiLights ? "taxi_light" : (vehicleDef.motorized.hasLandingLights ? "landing_light" : "running_light")))));
                }
            }
            if (provider.rendering.particles != null) {
                for (JSONParticle particleDef : provider.rendering.particles) {
                    LegacyCompatSystem.performParticleLegacyCompats(particleDef);
                }
            }
        }
    }

    private static void performVehicleLegacyCompats(JSONVehicle definition) {
        if (definition.general.emptyMass > 0) {
            definition.motorized.isAircraft = definition.general.isAircraft;
            definition.general.isAircraft = false;
            definition.motorized.isBlimp = definition.general.isBlimp;
            definition.general.isBlimp = false;
            definition.motorized.hasOpenTop = definition.general.openTop;
            definition.general.openTop = false;
            definition.motorized.emptyMass = definition.general.emptyMass;
            definition.general.emptyMass = 0;
        }
        if (definition.car != null) {
            definition.motorized.isBigTruck = definition.car.isBigTruck;
            definition.motorized.isFrontWheelDrive = definition.car.isFrontWheelDrive;
            definition.motorized.isRearWheelDrive = definition.car.isRearWheelDrive;
            definition.motorized.hasCruiseControl = definition.car.hasCruiseControl;
            definition.motorized.axleRatio = definition.car.axleRatio;
            definition.motorized.dragCoefficient = definition.car.dragCoefficient;
            definition.motorized.hornSound = definition.car.hornSound;
            definition.car = null;
        }
        if (definition.general.type != null) {
            if (definition.general.type.equals("plane") || definition.general.type.equals("blimp") || definition.general.type.equals("helicopter")) {
                definition.motorized.isAircraft = true;
            }
            if (definition.general.type.equals("blimp")) {
                definition.motorized.isBlimp = true;
            }
            definition.general.type = null;
        }
        if (definition.general.health == 0) {
            definition.general.health = 100;
        }
        if (definition.plane != null) {
            definition.general.isAircraft = true;
            definition.motorized.hasFlaps = definition.plane.hasFlaps;
            definition.motorized.hasAutopilot = definition.plane.hasAutopilot;
            definition.motorized.wingSpan = definition.plane.wingSpan;
            definition.motorized.wingArea = definition.plane.wingArea;
            definition.motorized.tailDistance = definition.plane.tailDistance;
            definition.motorized.aileronArea = definition.plane.aileronArea;
            definition.motorized.elevatorArea = definition.plane.elevatorArea;
            definition.motorized.rudderArea = definition.plane.rudderArea;
            definition.plane = null;
            if (definition.motorized.aileronArea == 0.0f) {
                definition.motorized.aileronArea = definition.motorized.wingArea / 5.0f;
            }
        }
        if (definition.blimp != null) {
            definition.general.isAircraft = true;
            definition.general.isBlimp = true;
            definition.motorized.isBlimp = true;
            definition.motorized.crossSectionalArea = definition.blimp.crossSectionalArea;
            definition.motorized.tailDistance = definition.blimp.tailDistance;
            definition.motorized.rudderArea = definition.blimp.rudderArea;
            definition.motorized.ballastVolume = definition.blimp.ballastVolume;
            definition.blimp = null;
        }
        if (definition.motorized.panel == null) {
            definition.motorized.panel = definition.motorized.isAircraft ? "mts:default_plane" : "mts:default_car";
        }
        if (definition.motorized.hitchPos != null) {
            definition.connections = new ArrayList();
            for (String hitchName : definition.motorized.hitchTypes) {
                JSONConnection connection = new JSONConnection();
                connection.hookup = false;
                connection.type = hitchName;
                connection.pos = definition.motorized.hitchPos;
                if (connection.mounted) {
                    connection.rot = new RotationMatrix();
                }
                definition.connections.add(connection);
            }
            definition.motorized.hitchPos = null;
            definition.motorized.hitchTypes = null;
        }
        if (definition.motorized.hookupPos != null) {
            if (definition.connections == null) {
                definition.connections = new ArrayList();
            }
            JSONConnection connection = new JSONConnection();
            connection.hookup = true;
            connection.type = definition.motorized.hookupType;
            connection.pos = definition.motorized.hookupPos;
            definition.connections.add(connection);
            definition.motorized.hookupType = null;
            definition.motorized.hookupPos = null;
        }
        if (definition.motorized.instruments != null) {
            definition.instruments = definition.motorized.instruments;
            definition.motorized.instruments = null;
            for (JSONInstrumentDefinition def : definition.instruments) {
                if (def.optionalPartNumber == 0) continue;
                def.placeOnPanel = true;
            }
        }
        if (definition.motorized.hasFlaps) {
            definition.motorized.flapSpeed = 0.1f;
            definition.motorized.flapNotches = new ArrayList<Float>();
            for (int i = 0; i <= 7; ++i) {
                definition.motorized.flapNotches.add(Float.valueOf(i * 5));
            }
            definition.motorized.hasFlaps = false;
        }
        if (definition.motorized.dragCoefficient == 0.0f) {
            float f = definition.motorized.dragCoefficient = definition.motorized.isAircraft || definition.motorized.isBlimp ? 0.03f : 2.0f;
        }
        if (definition.motorized.brakingFactor == 0.0f) {
            definition.motorized.brakingFactor = 1.0f;
        }
        if (definition.motorized.axleRatio == 0.0f) {
            definition.motorized.axleRatio = 3.55f;
        }
        if (definition.motorized.hasCruiseControl) {
            definition.motorized.hasAutopilot = true;
            definition.motorized.hasCruiseControl = false;
        }
        if (definition.motorized.downForce != 0.0f) {
            definition.motorized.steeringForceFactor = definition.motorized.downForce;
            definition.motorized.downForce = 0.0f;
        }
        if (definition.motorized.isTrailer && definition.motorized.hookupVariables == null) {
            definition.motorized.hookupVariables = new ArrayList<String>();
            definition.motorized.hookupVariables.add("electric_power");
            definition.motorized.hookupVariables.add("engine_gear_1");
            definition.motorized.hookupVariables.add("engines_on");
            definition.motorized.hookupVariables.add("right_turn_signal");
            definition.motorized.hookupVariables.add("left_turn_signal");
            definition.motorized.hookupVariables.add("runninglight");
            definition.motorized.hookupVariables.add("headlight");
            definition.motorized.hookupVariables.add("emergencylight");
        }
        for (JSONPartDefinition partDef : definition.parts) {
            try {
                LegacyCompatSystem.performVehiclePartDefLegacyCompats(partDef);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NullPointerException("Could not perform Legacy Compats on part entry #" + (definition.parts.indexOf(partDef) + 1) + " due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
        if (definition.parts != null) {
            LegacyCompatSystem.performPartSlotListingLegacyCompats(definition.parts, definition.motorized.isFrontWheelDrive, definition.motorized.isRearWheelDrive);
        }
        if (definition.motorized.isFrontWheelDrive || definition.motorized.isRearWheelDrive) {
            for (JSONPartDefinition partDef : definition.parts) {
                for (String partDefType : partDef.types) {
                    if (!partDefType.startsWith("engine")) continue;
                    if (partDef.linkedParts == null) {
                        partDef.linkedParts = new ArrayList<Integer>();
                    }
                    block10: for (JSONPartDefinition partDef2 : definition.parts) {
                        if (!(definition.motorized.isFrontWheelDrive && partDef2.pos.z > 0.0) && (!definition.motorized.isRearWheelDrive || !(partDef2.pos.z <= 0.0))) continue;
                        for (String partDefType2 : partDef2.types) {
                            if (!partDefType2.startsWith("ground") && !partDefType2.startsWith("generic")) continue;
                            if (partDef.linkedParts.contains(definition.parts.indexOf(partDef2) + 1)) continue block10;
                            partDef.linkedParts.add(definition.parts.indexOf(partDef2) + 1);
                            continue block10;
                        }
                    }
                }
            }
            definition.motorized.isFrontWheelDrive = false;
            definition.motorized.isRearWheelDrive = false;
        }
        LegacyCompatSystem.performVehicleConnectionLegacyCompats(definition);
        LegacyCompatSystem.performVehicleCollisionLegacyCompats(definition);
        if (definition.rendering != null) {
            if (definition.rendering.hudTexture != null) {
                definition.motorized.hudTexture = definition.rendering.hudTexture;
                definition.rendering.hudTexture = null;
            }
            if (definition.rendering.panelTexture != null) {
                definition.motorized.panelTexture = definition.rendering.panelTexture;
                definition.rendering.panelTexture = null;
            }
            if (definition.rendering.panelTextColor != null) {
                definition.motorized.panelTextColor = definition.rendering.panelTextColor;
                definition.rendering.panelTextColor = null;
            }
            if (definition.rendering.panelLitTextColor != null) {
                definition.motorized.panelLitTextColor = definition.rendering.panelLitTextColor;
                definition.rendering.panelLitTextColor = null;
            }
            if (definition.rendering.sounds == null) {
                definition.rendering.sounds = new ArrayList<JSONSound>();
                if (definition.motorized.hornSound != null) {
                    JSONSound hornSound = new JSONSound();
                    hornSound.name = definition.motorized.hornSound;
                    hornSound.looping = true;
                    hornSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition hornDef = new JSONAnimationDefinition();
                    hornDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    hornDef.variable = "horn";
                    hornDef.clampMin = 1.0f;
                    hornDef.clampMax = 1.0f;
                    hornSound.activeAnimations.add(hornDef);
                    definition.rendering.sounds.add(hornSound);
                    definition.motorized.hornSound = null;
                }
                if (definition.motorized.sirenSound != null) {
                    JSONSound sirenSound = new JSONSound();
                    sirenSound.name = definition.motorized.sirenSound;
                    sirenSound.looping = true;
                    sirenSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition sirenDef = new JSONAnimationDefinition();
                    sirenDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    sirenDef.variable = "siren";
                    sirenDef.clampMin = 1.0f;
                    sirenDef.clampMax = 1.0f;
                    sirenSound.activeAnimations.add(sirenDef);
                    definition.rendering.sounds.add(sirenSound);
                    if (definition.rendering.customVariables == null) {
                        definition.rendering.customVariables = new ArrayList<String>();
                    }
                    definition.rendering.customVariables.add("siren");
                    definition.motorized.sirenSound = null;
                }
                if (definition.motorized.isBigTruck) {
                    JSONSound airbrakeSound = new JSONSound();
                    airbrakeSound.name = InterfaceManager.coreModID + ":air_brake_activating";
                    airbrakeSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition airbrakeDef = new JSONAnimationDefinition();
                    airbrakeDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    airbrakeDef.variable = "p_brake";
                    airbrakeDef.clampMin = 1.0f;
                    airbrakeDef.clampMax = 1.0f;
                    airbrakeSound.activeAnimations.add(airbrakeDef);
                    definition.rendering.sounds.add(airbrakeSound);
                    JSONSound backupBeeperSound = new JSONSound();
                    backupBeeperSound.name = InterfaceManager.coreModID + ":backup_beeper";
                    backupBeeperSound.looping = true;
                    backupBeeperSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition backupBeeperDef = new JSONAnimationDefinition();
                    backupBeeperDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    backupBeeperDef.variable = "engine_gear_1";
                    backupBeeperDef.clampMin = -10.0f;
                    backupBeeperDef.clampMax = -1.0f;
                    backupBeeperSound.activeAnimations.add(backupBeeperDef);
                    definition.rendering.sounds.add(backupBeeperSound);
                    definition.motorized.isBigTruck = false;
                }
            }
            if (definition.rendering.particles == null) {
                definition.rendering.particles = new ArrayList<JSONParticle>();
            }
            int engineNumber = 0;
            for (JSONPartDefinition partDef : definition.parts) {
                if (partDef.particleObjects == null) continue;
                ++engineNumber;
                int pistonNumber = 0;
                for (JSONParticle exhaustDef : partDef.particleObjects) {
                    ++pistonNumber;
                    exhaustDef.type = JSONParticle.ParticleType.SMOKE;
                    exhaustDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    exhaustDef.initialVelocity = exhaustDef.velocityVector;
                    exhaustDef.velocityVector = null;
                    JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                    activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    activeAnimation.variable = "engine_piston_" + pistonNumber + "_" + partDef.particleObjects.size() + "_cam_" + engineNumber;
                    activeAnimation.clampMin = 1.0f;
                    activeAnimation.clampMax = 1.0f;
                    exhaustDef.activeAnimations.add(activeAnimation);
                    definition.rendering.particles.add(exhaustDef);
                    JSONParticle backfireDef = new JSONParticle();
                    backfireDef.type = exhaustDef.type;
                    backfireDef.color = ColorRGB.BLACK;
                    backfireDef.scale = 2.5f;
                    backfireDef.quantity = 5;
                    backfireDef.pos = exhaustDef.pos;
                    backfireDef.initialVelocity = exhaustDef.initialVelocity;
                    backfireDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    activeAnimation = new JSONAnimationDefinition();
                    activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    activeAnimation.variable = "engine_backfired_" + engineNumber;
                    activeAnimation.clampMin = 1.0f;
                    activeAnimation.clampMax = 1.0f;
                    backfireDef.activeAnimations.add(activeAnimation);
                    definition.rendering.particles.add(backfireDef);
                }
                partDef.particleObjects = null;
            }
            try {
                LegacyCompatSystem.performAnimationLegacyCompats(definition.rendering);
            }
            catch (Exception e) {
                throw new NullPointerException("Could not perform Legacy Compats on rendering section due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
    }

    private static void performPartLegacyCompats(JSONPart definition) {
        if (definition.general.type != null) {
            if (definition.generic == null) {
                definition.generic = new JSONPart.JSONPartGeneric();
            }
            definition.generic.type = definition.general.type;
            definition.general.type = null;
            definition.generic.customType = definition.general.customType;
            definition.general.customType = null;
            definition.generic.useVehicleTexture = definition.general.useVehicleTexture;
            definition.general.useVehicleTexture = false;
        }
        if (definition.subParts != null) {
            definition.parts = definition.subParts;
            definition.subParts = null;
        }
        switch (definition.generic.type) {
            case "wheel": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = new JSONPart.JSONPartGroundDevice();
                definition.ground.isWheel = true;
                definition.ground.width = definition.wheel.diameter / 2.0f;
                definition.ground.height = definition.wheel.diameter;
                definition.ground.lateralFriction = definition.wheel.lateralFriction;
                definition.ground.motiveFriction = definition.wheel.motiveFriction;
                definition.wheel = null;
                break;
            }
            case "skid": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = new JSONPart.JSONPartGroundDevice();
                definition.ground.width = definition.skid.width;
                definition.ground.height = definition.skid.width;
                definition.ground.lateralFriction = definition.skid.lateralFriction;
                definition.skid = null;
                break;
            }
            case "pontoon": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = new JSONPart.JSONPartGroundDevice();
                definition.ground.canFloat = true;
                definition.ground.width = definition.pontoon.width;
                definition.ground.height = definition.pontoon.width;
                definition.ground.lateralFriction = definition.pontoon.lateralFriction;
                definition.ground.extraCollisionBoxOffset = definition.pontoon.extraCollisionBoxOffset;
                definition.pontoon = null;
                break;
            }
            case "tread": {
                definition.generic.type = "ground_" + definition.generic.type;
                definition.ground = new JSONPart.JSONPartGroundDevice();
                definition.ground.isTread = true;
                definition.ground.width = definition.tread.width;
                definition.ground.height = definition.tread.width;
                definition.ground.lateralFriction = definition.tread.lateralFriction;
                definition.ground.motiveFriction = definition.tread.motiveFriction;
                definition.ground.extraCollisionBoxOffset = definition.tread.extraCollisionBoxOffset;
                definition.ground.spacing = definition.tread.spacing;
                definition.tread = null;
                break;
            }
            case "crate": {
                definition.generic.type = "interactable_crate";
                definition.interactable = new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.CRATE;
                definition.interactable.inventoryUnits = 1.0f;
                definition.interactable.feedsVehicles = true;
                break;
            }
            case "barrel": {
                definition.generic.type = "interactable_barrel";
                definition.interactable = new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.BARREL;
                definition.interactable.inventoryUnits = 1.0f;
                break;
            }
            case "crafting_table": {
                definition.generic.type = "interactable_crafting_table";
                definition.interactable = new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.CRAFTING_TABLE;
                break;
            }
            case "furnace": {
                definition.generic.type = "interactable_furnace";
                definition.interactable = new JSONPart.JSONPartInteractable();
                definition.interactable.interactionType = JSONPart.InteractableComponentType.FURNACE;
                break;
            }
            case "fertilizer": {
                definition.generic.type = "effector_fertilizer";
                definition.effector = new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.FERTILIZER;
                break;
            }
            case "harvester": {
                definition.generic.type = "effector_harvester";
                definition.effector = new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.HARVESTER;
                break;
            }
            case "planter": {
                definition.generic.type = "effector_planter";
                definition.effector = new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.PLANTER;
                break;
            }
            case "plow": {
                definition.generic.type = "effector_plow";
                definition.effector = new JSONPart.JSONPartEffector();
                definition.effector.type = JSONPart.EffectorComponentType.PLOW;
                break;
            }
            case "custom": {
                definition.generic.type = "generic";
                definition.generic.height = definition.custom.height;
                definition.generic.width = definition.custom.width;
                definition.custom = null;
            }
        }
        if (definition.engine != null) {
            if (definition.engine.type == null) {
                definition.engine.type = JSONPart.EngineType.NORMAL;
            }
            if (definition.generic.forwardsDamageMultiplier == 0.0) {
                definition.generic.forwardsDamageMultiplier = 1.0;
            }
            if (definition.engine.type == JSONPart.EngineType.MAGIC) {
                definition.engine.fuelType = JSONConfigSettings.FuelDefaults.NOTHING.name().toLowerCase();
            }
            if (definition.engine.fuelType == null) {
                definition.engine.fuelType = JSONConfigSettings.FuelDefaults.DIESEL.name().toLowerCase();
            }
            if (definition.generic.type.equals("engine_jet") && definition.engine.jetPowerFactor == 0.0f) {
                definition.engine.jetPowerFactor = 1.0f;
                definition.engine.bypassRatio = definition.engine.gearRatios.get(0).floatValue();
                definition.engine.gearRatios.set(0, Float.valueOf(1.0f));
            }
            if (definition.engine.gearRatios.size() == 1) {
                definition.engine.propellerRatio = 1.0f / definition.engine.gearRatios.get(0).floatValue();
                definition.engine.gearRatios.clear();
                definition.engine.gearRatios.add(Float.valueOf(-1.0f));
                definition.engine.gearRatios.add(Float.valueOf(0.0f));
                definition.engine.gearRatios.add(Float.valueOf(1.0f));
            }
            if (definition.engine.shiftSpeed == 0) {
                definition.engine.shiftSpeed = 20;
            } else if (definition.engine.shiftSpeed == -1) {
                definition.engine.shiftSpeed = 0;
            }
            if (definition.engine.revResistance == 0) {
                definition.engine.revResistance = 10;
            }
            if (definition.engine.idleRPM == 0) {
                definition.engine.idleRPM = definition.engine.maxRPM < 15000 ? 500 : 2000;
            } else if (definition.engine.idleRPM == -1) {
                definition.engine.idleRPM = 0;
            }
            if (definition.engine.maxSafeRPM == 0) {
                int n = definition.engine.maxSafeRPM = definition.engine.maxRPM < 15000 ? definition.engine.maxRPM - (definition.engine.maxRPM - 2500) / 2 : (int)((double)definition.engine.maxRPM / 1.1);
            }
            if (definition.engine.revlimitRPM == 0) {
                definition.engine.revlimitRPM = definition.engine.jetPowerFactor != 0.0f || definition.engine.gearRatios.size() == 3 ? -1 : (int)((double)definition.engine.maxSafeRPM * 0.95);
            }
            if (definition.engine.revlimitBounce == 0) {
                definition.engine.revlimitBounce = definition.engine.revResistance;
            }
            if (definition.engine.startRPM == 0) {
                definition.engine.startRPM = (int)((double)definition.engine.idleRPM * 1.2);
            } else if (definition.engine.startRPM == -1) {
                definition.engine.startRPM = 0;
            }
            if (definition.engine.stallRPM == 0) {
                definition.engine.stallRPM = (int)((double)definition.engine.idleRPM * 0.65);
            } else if (definition.engine.stallRPM == -1) {
                definition.engine.stallRPM = 0;
            }
            if (definition.engine.engineWinddownRate == 0) {
                definition.engine.engineWinddownRate = 10;
            }
            if (definition.engine.engineWearFactor == 0.0f) {
                definition.engine.engineWearFactor = 1.0f;
            }
            if (definition.engine.coolingCoefficient == 0.0f) {
                definition.engine.coolingCoefficient = 1.0f;
            }
            if (definition.engine.heatingCoefficient == 0.0f) {
                definition.engine.heatingCoefficient = 1.0f;
            }
            if (definition.engine.upShiftRPM != null) {
                while (definition.engine.upShiftRPM.size() < definition.engine.gearRatios.size()) {
                    definition.engine.upShiftRPM.add(0, 0);
                }
            }
            if (definition.engine.downShiftRPM != null) {
                while (definition.engine.downShiftRPM.size() < definition.engine.gearRatios.size()) {
                    definition.engine.downShiftRPM.add(0, 0);
                }
            }
        }
        if (definition.ground != null) {
            if (definition.ground.canGoFlat && definition.ground.flatHeight == 0.0f) {
                definition.ground.flatHeight = definition.ground.height / 2.0f;
                definition.ground.canGoFlat = false;
            }
            if (definition.ground.climbHeight == 0.0f) {
                definition.ground.climbHeight = 1.5f;
            }
            if (definition.ground.frictionModifiers == null) {
                definition.ground.frictionModifiers = new LinkedHashMap();
                definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.SNOW, Float.valueOf(-0.2f));
                definition.ground.frictionModifiers.put(ABlockBase.BlockMaterial.ICE, Float.valueOf(-0.2f));
            } else {
                definition.ground.frictionModifiers.remove((Object)ABlockBase.BlockMaterial.DIRT_WET);
                definition.ground.frictionModifiers.remove((Object)ABlockBase.BlockMaterial.SAND_WET);
                definition.ground.frictionModifiers.remove((Object)ABlockBase.BlockMaterial.NORMAL_WET);
            }
            if (definition.ground.wetFrictionPenalty == 0.0f && !definition.ground.isTread) {
                definition.ground.wetFrictionPenalty = -0.1f;
            }
        }
        if (definition.generic.type.startsWith("seat") && definition.seat == null) {
            definition.seat = new JSONPart.JSONPartSeat();
        }
        if (definition.seat != null && (definition.seat.widthScale != 0.0f || definition.seat.heightScale != 0.0f)) {
            if (definition.seat.widthScale == 0.0f) {
                definition.seat.widthScale = 1.0f;
            }
            if (definition.seat.heightScale == 0.0f) {
                definition.seat.heightScale = 1.0f;
            }
            definition.seat.playerScale = new Point3D(definition.seat.widthScale, definition.seat.heightScale, definition.seat.widthScale);
            definition.seat.widthScale = 0.0f;
            definition.seat.heightScale = 0.0f;
        }
        if (definition.gun != null) {
            if (definition.gun.yawSpeed == 0.0f) {
                definition.gun.yawSpeed = 50.0f / definition.gun.diameter + 1.0f / definition.gun.length;
            }
            if (definition.gun.pitchSpeed == 0.0f) {
                definition.gun.pitchSpeed = 50.0f / definition.gun.diameter + 1.0f / definition.gun.length;
            }
            if (definition.gun.muzzleGroups == null) {
                definition.gun.muzzleGroups = new ArrayList<JSONMuzzleGroup>();
                JSONMuzzleGroup muzzleGroup = new JSONMuzzleGroup();
                muzzleGroup.muzzles = new ArrayList<JSONMuzzle>();
                JSONMuzzle muzzle = new JSONMuzzle();
                muzzle.pos = new Point3D(0.0, 0.0, definition.gun.length);
                muzzleGroup.muzzles.add(muzzle);
                definition.gun.muzzleGroups.add(muzzleGroup);
            }
            if (definition.gun.lockOnType == null) {
                definition.gun.lockOnType = JSONPart.LockOnType.DEFAULT;
            }
            if (definition.gun.targetType == null) {
                definition.gun.targetType = JSONPart.TargetType.ALL;
            }
            definition.gun.length = 0.0f;
        }
        if (definition.interactable != null && definition.interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.FURNACE) && definition.interactable.furnaceType == null) {
            definition.interactable.furnaceType = JSONPart.FurnaceComponentType.STANDARD;
            definition.interactable.furnaceRate = 1.0f;
            definition.interactable.furnaceEfficiency = 1.0f;
        }
        if (definition.parts != null) {
            for (JSONPartDefinition subPartDef : definition.parts) {
                try {
                    LegacyCompatSystem.performVehiclePartDefLegacyCompats(subPartDef);
                }
                catch (Exception e) {
                    throw new NullPointerException("Could not perform Legacy Compats on sub-part entry #" + (definition.parts.indexOf(subPartDef) + 1) + " due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
                }
            }
        }
        if (definition.parts != null) {
            LegacyCompatSystem.performPartSlotListingLegacyCompats(definition.parts, false, false);
        }
        if (definition.rendering != null) {
            try {
                LegacyCompatSystem.performAnimationLegacyCompats(definition.rendering);
            }
            catch (Exception e) {
                throw new NullPointerException("Could not perform Legacy Compats on rendering section due to an unknown error.  This is likely due to a missing or incorrectly-named field.");
            }
        }
        LegacyCompatSystem.performVehicleConnectionLegacyCompats(definition);
        LegacyCompatSystem.performVehicleCollisionLegacyCompats(definition);
        if (definition.ground != null && definition.ground.isWheel) {
            if (definition.generic.movementAnimations != null) {
                boolean oldAnimationsDetected = false;
                for (JSONAnimationDefinition animation : definition.generic.movementAnimations) {
                    if (!animation.variable.equals("part_ismirrored")) continue;
                    oldAnimationsDetected = true;
                    break;
                }
                if (oldAnimationsDetected) {
                    definition.generic.movementAnimations = null;
                }
            }
            if (definition.generic.movementAnimations == null) {
                definition.generic.movementAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition animation = new JSONAnimationDefinition();
                animation = new JSONAnimationDefinition();
                animation.centerPoint = new Point3D(0.0, 0.0, 0.0);
                animation.axis = new Point3D(1.0, 0.0, 0.0);
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                animation.variable = "ground_rotation";
                definition.generic.movementAnimations.add(animation);
            }
        }
        if (definition.propeller != null && definition.generic.movementAnimations == null) {
            definition.generic.movementAnimations = new ArrayList<JSONAnimationDefinition>();
            JSONAnimationDefinition animation = new JSONAnimationDefinition();
            animation.centerPoint = new Point3D(0.0, 0.0, 0.0);
            animation.axis = new Point3D(0.0, 0.0, 1.0);
            animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
            animation.variable = "propeller_rotation";
            definition.generic.movementAnimations.add(animation);
        }
        if (definition.rendering == null || definition.rendering.sounds == null) {
            if (definition.engine != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound startingSound = new JSONSound();
                startingSound.name = definition.packID + ":" + definition.systemName + "_starting";
                startingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition startingActiveDef = new JSONAnimationDefinition();
                startingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                startingActiveDef.variable = "engine_running";
                startingActiveDef.clampMin = 1.0f;
                startingActiveDef.clampMax = 1.0f;
                startingSound.activeAnimations.add(startingActiveDef);
                definition.rendering.sounds.add(startingSound);
                JSONSound stoppingSound = new JSONSound();
                stoppingSound.name = definition.packID + ":" + definition.systemName + "_stopping";
                stoppingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition stoppingActiveDef = new JSONAnimationDefinition();
                stoppingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                stoppingActiveDef.variable = "engine_running";
                stoppingActiveDef.clampMin = 0.0f;
                stoppingActiveDef.clampMax = 0.0f;
                stoppingSound.activeAnimations.add(stoppingActiveDef);
                definition.rendering.sounds.add(stoppingSound);
                JSONSound sputteringSound = new JSONSound();
                sputteringSound.name = definition.packID + ":" + definition.systemName + "_sputter";
                sputteringSound.forceSound = true;
                sputteringSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition sputteringActiveDef = new JSONAnimationDefinition();
                sputteringActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                sputteringActiveDef.variable = "engine_backfired";
                sputteringActiveDef.clampMin = 1.0f;
                sputteringActiveDef.clampMax = 1.0f;
                sputteringSound.activeAnimations.add(sputteringActiveDef);
                definition.rendering.sounds.add(sputteringSound);
                JSONSound grindingSound = new JSONSound();
                grindingSound.name = InterfaceManager.coreModID + ":engine_shifting_grinding";
                grindingSound.forceSound = true;
                grindingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition grindingActiveDef = new JSONAnimationDefinition();
                grindingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                grindingActiveDef.variable = "engine_badshift";
                grindingActiveDef.clampMin = 1.0f;
                grindingActiveDef.clampMax = 1.0f;
                grindingSound.activeAnimations.add(grindingActiveDef);
                definition.rendering.sounds.add(grindingSound);
                JSONSound crankingSound = new JSONSound();
                crankingSound.name = definition.packID + ":" + definition.systemName + "_cranking";
                crankingSound.looping = true;
                crankingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition crankingActiveDef = new JSONAnimationDefinition();
                crankingActiveDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                crankingActiveDef.variable = "engine_starter";
                crankingActiveDef.clampMin = 1.0f;
                crankingActiveDef.clampMax = 1.0f;
                crankingSound.activeAnimations.add(crankingActiveDef);
                crankingSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition crankingPitchDef = new JSONAnimationDefinition();
                if (!definition.engine.isCrankingNotPitched) {
                    crankingPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    crankingPitchDef.variable = "electric_power";
                    crankingPitchDef.axis = new Point3D(0.0, 0.1, 0.0);
                    crankingPitchDef.offset = 0.3f;
                    crankingPitchDef.clampMax = 1.0f;
                    definition.engine.isCrankingNotPitched = false;
                } else {
                    crankingPitchDef = new JSONAnimationDefinition();
                    crankingPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    crankingPitchDef.variable = "engine_rpm";
                    crankingPitchDef.axis = new Point3D(0.0, 1.0 / (definition.engine.maxRPM < 15000 ? 500.0 : 2000.0), 0.0);
                }
                crankingSound.pitchAnimations.add(crankingPitchDef);
                definition.rendering.sounds.add(crankingSound);
                if (definition.engine.customSoundset != null) {
                    for (JSONPart.JSONPartEngine.EngineSound customSound : definition.engine.customSoundset) {
                        JSONSound runningSound = new JSONSound();
                        runningSound.name = customSound.soundName;
                        runningSound.looping = true;
                        runningSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                        runningSound.volumeAnimations = new ArrayList<JSONAnimationDefinition>();
                        runningSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                        JSONAnimationDefinition runningStartDef = new JSONAnimationDefinition();
                        runningStartDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        runningStartDef.variable = "engine_powered";
                        runningStartDef.clampMin = 1.0f;
                        runningStartDef.clampMax = 1.0f;
                        runningSound.activeAnimations.add(runningStartDef);
                        JSONAnimationDefinition runningVolumeDef = new JSONAnimationDefinition();
                        if (customSound.volumeAdvanced) {
                            runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                            runningVolumeDef.variable = "engine_rpm";
                            runningVolumeDef.centerPoint = new Point3D();
                            runningVolumeDef.axis = new Point3D(-1.0E-6 / (double)(customSound.volumeLength / 1000.0f), 0.0, customSound.volumeCenter);
                            runningVolumeDef.offset = customSound.volumeLength / 20000.0f + 1.0f;
                        } else {
                            runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                            runningVolumeDef.variable = "engine_rpm_percent";
                            runningVolumeDef.axis = new Point3D(0.0, customSound.volumeMax - customSound.volumeIdle, 0.0);
                            runningVolumeDef.offset = customSound.volumeIdle + (float)((definition.engine.maxRPM < 15000 ? 500 : 2000) / definition.engine.maxRPM);
                        }
                        runningSound.volumeAnimations.add(runningVolumeDef);
                        JSONAnimationDefinition runningPitchDef = new JSONAnimationDefinition();
                        if (customSound.pitchAdvanced) {
                            runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                            runningPitchDef.variable = "engine_rpm";
                            runningPitchDef.centerPoint = new Point3D();
                            runningPitchDef.axis = new Point3D(-1.0E-6 / (double)(customSound.pitchLength / 1000.0f), 0.0, customSound.pitchCenter);
                            runningPitchDef.offset = customSound.pitchLength / 20000.0f + 1.0f;
                        } else {
                            runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                            runningPitchDef.variable = "engine_rpm_percent";
                            runningPitchDef.axis = new Point3D(0.0, customSound.pitchMax - customSound.pitchIdle, 0.0);
                            runningPitchDef.offset = customSound.pitchIdle + (float)((definition.engine.maxRPM < 15000 ? 500 : 2000) / definition.engine.maxRPM);
                        }
                        runningSound.pitchAnimations.add(runningPitchDef);
                        definition.rendering.sounds.add(runningSound);
                    }
                    definition.engine.customSoundset = null;
                } else {
                    JSONSound runningSound = new JSONSound();
                    runningSound.name = definition.packID + ":" + definition.systemName + "_running";
                    runningSound.looping = true;
                    runningSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition runningVolumeDef = new JSONAnimationDefinition();
                    runningVolumeDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                    runningVolumeDef.variable = "engine_powered";
                    runningVolumeDef.clampMin = 1.0f;
                    runningVolumeDef.clampMax = 1.0f;
                    runningSound.activeAnimations.add(runningVolumeDef);
                    runningSound.pitchAnimations = new ArrayList<JSONAnimationDefinition>();
                    JSONAnimationDefinition runningPitchDef = new JSONAnimationDefinition();
                    runningPitchDef.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                    runningPitchDef.variable = "engine_rpm";
                    runningPitchDef.axis = new Point3D(0.0, 0.35 / (double)(definition.engine.maxRPM < 15000 ? 500 : 5000), 0.0);
                    runningPitchDef.offset = 0.35f;
                    runningSound.pitchAnimations.add(runningPitchDef);
                    definition.rendering.sounds.add(runningSound);
                }
            } else if (definition.gun != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound firingSound = new JSONSound();
                firingSound.name = definition.packID + ":" + definition.systemName + "_firing";
                firingSound.forceSound = true;
                firingSound.canPlayOnPartialTicks = definition.gun.fireDelay < 2.0f;
                firingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition firingDef = new JSONAnimationDefinition();
                firingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                firingDef.variable = "gun_fired";
                firingDef.clampMin = 1.0f;
                firingDef.clampMax = 1.0f;
                firingSound.activeAnimations.add(firingDef);
                definition.rendering.sounds.add(firingSound);
                JSONSound reloadingSound = new JSONSound();
                reloadingSound.name = definition.packID + ":" + definition.systemName + "_reloading";
                reloadingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition reloadingDef = new JSONAnimationDefinition();
                reloadingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                reloadingDef.variable = "gun_reload";
                reloadingDef.clampMin = 1.0f;
                reloadingDef.clampMax = 1.0f;
                reloadingSound.activeAnimations.add(reloadingDef);
                definition.rendering.sounds.add(reloadingSound);
            } else if (definition.ground != null) {
                if (definition.rendering == null) {
                    definition.rendering = new JSONRendering();
                }
                if (definition.rendering.sounds == null) {
                    definition.rendering.sounds = new ArrayList<JSONSound>();
                }
                JSONSound blowoutSound = new JSONSound();
                blowoutSound.name = InterfaceManager.coreModID + ":wheel_blowout";
                blowoutSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition blowoutDef = new JSONAnimationDefinition();
                blowoutDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                blowoutDef.variable = "ground_isflat";
                blowoutDef.clampMin = 1.0f;
                blowoutDef.clampMax = 1.0f;
                blowoutSound.activeAnimations.add(blowoutDef);
                definition.rendering.sounds.add(blowoutSound);
                JSONSound strikingSound = new JSONSound();
                strikingSound.name = InterfaceManager.coreModID + ":wheel_striking";
                strikingSound.forceSound = true;
                strikingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition strikingDef = new JSONAnimationDefinition();
                strikingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                strikingDef.variable = "ground_contacted";
                strikingDef.clampMin = 1.0f;
                strikingDef.clampMax = 1.0f;
                strikingSound.activeAnimations.add(strikingDef);
                definition.rendering.sounds.add(strikingSound);
                JSONSound skiddingSound = new JSONSound();
                skiddingSound.name = InterfaceManager.coreModID + ":wheel_skidding";
                skiddingSound.looping = true;
                skiddingSound.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition skiddingDef = new JSONAnimationDefinition();
                skiddingDef.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                skiddingDef.variable = "ground_slipping";
                skiddingDef.clampMin = 1.0f;
                skiddingDef.clampMax = 1.0f;
                skiddingSound.activeAnimations.add(skiddingDef);
                definition.rendering.sounds.add(skiddingSound);
            }
        }
        if (definition.rendering != null && definition.rendering.particles == null) {
            definition.rendering.particles = new ArrayList<JSONParticle>();
            if (definition.engine != null) {
                JSONParticle particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.BLACK;
                particleDef.spawnEveryTick = true;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_temp";
                activeAnimation.clampMin = 115.556f;
                activeAnimation.clampMax = 999.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.BLACK;
                particleDef.spawnEveryTick = true;
                particleDef.quantity = 1;
                particleDef.scale = 2.5f;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_temp";
                activeAnimation.clampMin = 121.111f;
                activeAnimation.clampMax = 999.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.DRIP;
                particleDef.color = ColorRGB.BLACK;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_oilleak";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "cycle_10_20";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.DRIP;
                particleDef.color = ColorRGB.RED;
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "engine_fuelleak";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "cycle_10_20";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                definition.rendering.particles.add(particleDef);
            } else if (definition.ground != null) {
                JSONParticle particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.WHITE;
                particleDef.quantity = 4;
                particleDef.initialVelocity = new Point3D(0.0, 0.15, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_contacted";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                particleDef.spawningAnimations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition spawningAnimation = new JSONAnimationDefinition();
                spawningAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                spawningAnimation.variable = "ground_rotation";
                spawningAnimation.centerPoint = new Point3D();
                spawningAnimation.axis = new Point3D(-1.0, 0.0, 0.0);
                particleDef.spawningAnimations.add(spawningAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.SMOKE;
                particleDef.color = ColorRGB.WHITE;
                particleDef.quantity = 4;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3D(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3D(0.0, 0.15, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_slipping";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                particleDef.spawningAnimations = new ArrayList<JSONAnimationDefinition>();
                spawningAnimation = new JSONAnimationDefinition();
                spawningAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                spawningAnimation.variable = "ground_rotation";
                spawningAnimation.centerPoint = new Point3D();
                spawningAnimation.axis = new Point3D(-1.0, 0.0, 0.0);
                particleDef.spawningAnimations.add(spawningAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.BREAK;
                particleDef.color = new ColorRGB("999999");
                particleDef.quantity = 4;
                particleDef.scale = 0.3f;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3D(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3D(0.0, 1.5, -1.5);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_skidding";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                particleDef.spawningAnimations = new ArrayList<JSONAnimationDefinition>();
                spawningAnimation = new JSONAnimationDefinition();
                spawningAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                spawningAnimation.variable = "ground_rotation";
                spawningAnimation.centerPoint = new Point3D();
                spawningAnimation.axis = new Point3D(-1.0, 0.0, 0.0);
                particleDef.spawningAnimations.add(spawningAnimation);
                definition.rendering.particles.add(particleDef);
                particleDef = new JSONParticle();
                particleDef.type = JSONParticle.ParticleType.BREAK;
                particleDef.color = new ColorRGB("999999");
                particleDef.quantity = 4;
                particleDef.scale = 0.3f;
                particleDef.spawnEveryTick = true;
                particleDef.pos = new Point3D(0.0, -definition.ground.height / 2.0f, 0.0);
                particleDef.initialVelocity = new Point3D(0.0, 1.5, 0.0);
                particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
                activeAnimation = new JSONAnimationDefinition();
                activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                activeAnimation.variable = "ground_slipping";
                activeAnimation.clampMin = 1.0f;
                activeAnimation.clampMax = 1.0f;
                particleDef.activeAnimations.add(activeAnimation);
                particleDef.spawningAnimations = new ArrayList<JSONAnimationDefinition>();
                spawningAnimation = new JSONAnimationDefinition();
                spawningAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                spawningAnimation.variable = "ground_rotation";
                spawningAnimation.centerPoint = new Point3D();
                spawningAnimation.axis = new Point3D(-1.0, 0.0, 0.0);
                particleDef.spawningAnimations.add(spawningAnimation);
                definition.rendering.particles.add(particleDef);
            }
        }
    }

    private static void performInstrumentLegacyCompats(JSONInstrument definition) {
        boolean oldDefinition = false;
        for (JSONInstrument.JSONInstrumentComponent component : definition.components) {
            if (component.rotationVariable == null && component.translationVariable == null) continue;
            oldDefinition = true;
            break;
        }
        for (JSONInstrument.JSONInstrumentComponent component : definition.components) {
            JSONAnimationDefinition animation;
            if (oldDefinition) {
                component.lightUpTexture = true;
                component.overlayTexture = component.lightOverlay;
                component.lightOverlay = false;
            }
            if (component.rotationVariable != null) {
                component.animations = new ArrayList<JSONAnimationDefinition>();
                animation = new JSONAnimationDefinition();
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                animation.variable = component.rotationVariable;
                animation.centerPoint = new Point3D();
                animation.axis = new Point3D(0.0, 0.0, component.rotationFactor);
                animation.offset = component.rotationOffset;
                animation.clampMin = component.rotationClampMin;
                animation.clampMax = component.rotationClampMax;
                animation.absolute = component.rotationAbsoluteValue;
                component.animations.add(animation);
                component.rotationVariable = null;
                component.rotationFactor = 0.0f;
                component.rotationOffset = 0.0f;
                component.rotationClampMin = 0.0f;
                component.rotationClampMax = 0.0f;
                component.rotationAbsoluteValue = false;
            }
            if (component.translationVariable != null) {
                if (component.animations == null) {
                    component.animations = new ArrayList<JSONAnimationDefinition>();
                }
                animation = new JSONAnimationDefinition();
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                animation.variable = component.translationVariable;
                animation.axis = component.translateHorizontal ? new Point3D(component.translationFactor, 0.0, 0.0) : new Point3D(0.0, component.translationFactor, 0.0);
                animation.clampMin = component.translationClampMin;
                animation.clampMax = component.translationClampMax;
                animation.absolute = component.translationAbsoluteValue;
                if (component.rotateWindow) {
                    component.animations.add(animation);
                } else {
                    component.animations.add(0, animation);
                }
                component.translateHorizontal = false;
                component.translationVariable = null;
                component.translationFactor = 0.0f;
                component.translationClampMin = 0.0f;
                component.translationClampMax = 0.0f;
                component.translationAbsoluteValue = false;
            }
            if ((double)component.scale == 0.0) {
                component.scale = 1.0f;
            }
            if (component.textObject == null || component.textObject.variableName != null) continue;
            component.textObject.variableName = component.textObject.fieldName;
            component.textObject.variableFormat = "%0" + component.textObject.maxLength + ".0f";
            component.textObject.variableFactor = 1.0f;
            component.textObject.fieldName = null;
            component.textObject.maxLength = 0;
        }
        if (definition.textureName == null) {
            definition.textureName = "instruments.png";
        }
    }

    private static void performPoleLegacyCompats(JSONPoleComponent definition) {
        if (definition.general.textLines != null) {
            definition.general.textObjects = new ArrayList<JSONText>();
            for (AJSONItem.General.TextLine line : definition.general.textLines) {
                JSONText object = new JSONText();
                object.color = line.color;
                object.scale = line.scale;
                object.maxLength = line.characters;
                object.pos = new Point3D(line.xPos, line.yPos, (double)line.zPos + 0.01);
                object.fieldName = "TextLine #" + (definition.general.textObjects.size() + 1);
                definition.general.textObjects.add(object);
            }
            definition.general.textLines = null;
        }
        if (definition.general.textObjects != null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            definition.rendering.textObjects = definition.general.textObjects;
            definition.general.textObjects = null;
        }
        if (definition.rendering != null && definition.rendering.textObjects != null) {
            for (JSONText text : definition.rendering.textObjects) {
                if (text.defaultText != null) continue;
                text.defaultText = "";
            }
        }
        if (definition.general.type != null) {
            definition.pole = new JSONPoleComponent.JSONPoleGeneric();
            definition.pole.type = ItemPoleComponent.PoleComponentType.valueOf(definition.general.type.toUpperCase(Locale.ROOT));
            definition.general.type = null;
            definition.pole.radius = definition.general.radius;
            definition.general.radius = 0.0f;
        }
        if (definition.pole.type.equals((Object)ItemPoleComponent.PoleComponentType.CORE) && definition.rendering.animatedObjects == null) {
            definition.rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                if (axis.equals((Object)ABlockBase.Axis.NONE)) continue;
                JSONAnimatedObject connectorModelObject = new JSONAnimatedObject();
                connectorModelObject.objectName = axis.name().toLowerCase(Locale.ROOT);
                connectorModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition connectorVisibilityInhibitor = new JSONAnimationDefinition();
                connectorVisibilityInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                connectorVisibilityInhibitor.variable = "solid_present_" + axis.name().toLowerCase(Locale.ROOT);
                connectorVisibilityInhibitor.clampMin = 1.0f;
                connectorVisibilityInhibitor.clampMax = 1.0f;
                connectorModelObject.animations.add(connectorVisibilityInhibitor);
                JSONAnimationDefinition connectorVisibility = new JSONAnimationDefinition();
                connectorVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                connectorVisibility.variable = "neighbor_present_" + axis.name().toLowerCase(Locale.ROOT);
                connectorVisibility.clampMin = 1.0f;
                connectorVisibility.clampMax = 1.0f;
                connectorModelObject.animations.add(connectorVisibility);
                definition.rendering.animatedObjects.add(connectorModelObject);
                JSONAnimatedObject solidModelObject = new JSONAnimatedObject();
                solidModelObject.objectName = axis.name().toLowerCase(Locale.ROOT) + "_solid";
                solidModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition solidVisibility = new JSONAnimationDefinition();
                solidVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                solidVisibility.variable = "solid_present_" + axis.name().toLowerCase(Locale.ROOT);
                solidVisibility.clampMin = 1.0f;
                solidVisibility.clampMax = 1.0f;
                solidModelObject.animations.add(solidVisibility);
                definition.rendering.animatedObjects.add(solidModelObject);
                if (!axis.equals((Object)ABlockBase.Axis.UP) && !axis.equals((Object)ABlockBase.Axis.DOWN)) continue;
                JSONAnimatedObject slabModelObject = new JSONAnimatedObject();
                slabModelObject.objectName = axis.name().toLowerCase(Locale.ROOT) + "_slab";
                slabModelObject.animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition slabVisibility = new JSONAnimationDefinition();
                slabVisibility.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                slabVisibility.variable = "slab_present_" + axis.name().toLowerCase(Locale.ROOT);
                slabVisibility.clampMin = 1.0f;
                slabVisibility.clampMax = 1.0f;
                slabModelObject.animations.add(slabVisibility);
                definition.rendering.animatedObjects.add(slabModelObject);
            }
        }
    }

    private static void performDecorLegacyCompats(JSONDecor definition) {
        if (definition.decor == null) {
            definition.decor = new JSONDecor.JSONDecorGeneric();
            if (definition.general.type != null) {
                definition.decor.type = JSONDecor.DecorComponentType.valueOf(definition.general.type.toUpperCase(Locale.ROOT));
                definition.general.type = null;
            }
            definition.decor.width = definition.general.width;
            definition.general.width = 0.0f;
            definition.decor.height = definition.general.height;
            definition.general.height = 0.0f;
            definition.decor.depth = definition.general.depth;
            definition.general.depth = 0.0f;
            definition.decor.itemTypes = definition.general.itemTypes;
            definition.general.itemTypes = null;
            definition.decor.partTypes = definition.general.partTypes;
            definition.general.partTypes = null;
            definition.decor.items = definition.general.items;
            definition.general.items = null;
        }
        if (definition.decor.type == null) {
            definition.decor.type = JSONDecor.DecorComponentType.GENERIC;
        }
        if ((definition.decor.type.equals((Object)JSONDecor.DecorComponentType.ITEM_LOADER) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.ITEM_UNLOADER)) && definition.decor.inventoryUnits == 0.0f) {
            definition.decor.inventoryUnits = 0.11111111f;
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FUEL_PUMP) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_LOADER) || definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FLUID_UNLOADER)) {
            if (definition.decor.fuelCapacity == 0) {
                definition.decor.fuelCapacity = 15000;
            }
            if (definition.decor.pumpRate == 0.0f) {
                definition.decor.pumpRate = 10.0f;
            }
        }
        if (definition.general.textLines != null) {
            definition.general.textObjects = new ArrayList<JSONText>();
            int lineNumber = 0;
            for (AJSONItem.General.TextLine line : definition.general.textLines) {
                JSONText object = new JSONText();
                object.lightsUp = true;
                object.color = line.color;
                object.scale = line.scale;
                if (lineNumber++ < 3) {
                    object.pos = new Point3D(line.xPos, line.yPos, (double)line.zPos + 1.0E-4);
                } else {
                    object.pos = new Point3D(line.xPos, line.yPos, (double)line.zPos - 1.0E-4);
                    object.rot = new RotationMatrix();
                    object.rot.setToAxisAngle(0.0, 1.0, 0.0, 180.0);
                }
                object.fieldName = "TextLine #" + (definition.general.textObjects.size() + 1);
                definition.general.textObjects.add(object);
            }
            definition.general.textLines = null;
        }
        if (definition.general.textObjects != null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            definition.rendering.textObjects = definition.general.textObjects;
            definition.general.textObjects = null;
        }
        if (definition.rendering != null && definition.rendering.textObjects != null) {
            for (JSONText text : definition.rendering.textObjects) {
                if (text.defaultText != null) continue;
                text.defaultText = "";
            }
        }
        if (definition.decor.items != null || definition.decor.itemTypes != null) {
            definition.decor.crafting = new JSONCraftingBench();
            definition.decor.crafting.itemTypes = definition.decor.itemTypes;
            definition.decor.itemTypes = null;
            definition.decor.crafting.partTypes = definition.decor.partTypes;
            definition.decor.partTypes = null;
            definition.decor.crafting.items = definition.decor.items;
            definition.decor.items = null;
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.FUEL_PUMP) && definition.rendering != null && definition.rendering.textObjects != null) {
            block7: for (int i = 0; i < definition.rendering.textObjects.size(); ++i) {
                JSONText textDef = definition.rendering.textObjects.get(i);
                if (textDef.variableName != null) continue;
                switch (i % 3) {
                    case 0: {
                        textDef.variableName = "fuelpump_fluid";
                        textDef.variableFormat = "%s";
                        continue block7;
                    }
                    case 1: {
                        textDef.variableName = "fuelpump_stored";
                        textDef.variableFactor = 0.001f;
                        textDef.variableFormat = "LVL:%04.1fb";
                        continue block7;
                    }
                    case 2: {
                        textDef.variableName = "fuelpump_dispensed";
                        textDef.variableFactor = 0.001f;
                        textDef.variableFormat = "DISP:%04.1fb";
                    }
                }
            }
        }
        if (definition.decor.type.equals((Object)JSONDecor.DecorComponentType.BEACON)) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            if (definition.rendering.textObjects == null) {
                definition.rendering.textObjects = new ArrayList<JSONText>();
                JSONText nameTextObject = new JSONText();
                nameTextObject.pos = new Point3D(0.0, -500.0, 0.0);
                nameTextObject.fieldName = "Beacon Name";
                nameTextObject.defaultText = "NONE";
                nameTextObject.maxLength = 5;
                nameTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(nameTextObject);
                JSONText glideslopeTextObject = new JSONText();
                glideslopeTextObject.pos = new Point3D(0.0, -500.0, 0.0);
                glideslopeTextObject.fieldName = "Glide Slope (Deg)";
                glideslopeTextObject.defaultText = "10.0";
                glideslopeTextObject.maxLength = 5;
                glideslopeTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(glideslopeTextObject);
                JSONText bearingTextObject = new JSONText();
                bearingTextObject.pos = new Point3D(0.0, -500.0, 0.0);
                bearingTextObject.fieldName = "Bearing (Deg)";
                bearingTextObject.defaultText = "0.0";
                bearingTextObject.maxLength = 5;
                bearingTextObject.color = ColorRGB.WHITE;
                definition.rendering.textObjects.add(bearingTextObject);
            }
        }
    }

    private static void performRoadLegacyCompats(JSONRoadComponent definition) {
        if (definition.road.type.equals((Object)TileEntityRoad.RoadComponent.CORE_DYNAMIC) && definition.road.segmentLength == 0.0f) {
            definition.road.segmentLength = 1.0f;
        }
    }

    private static void performItemLegacyCompats(JSONItem definition) {
        if (definition.item == null) {
            definition.item = new JSONItem.JSONItemGeneric();
            if (definition.general.type != null) {
                definition.item.type = JSONItem.ItemComponentType.valueOf(definition.general.type.toUpperCase(Locale.ROOT));
                definition.general.type = null;
            }
        }
        if (definition.item.type == null) {
            definition.item.type = JSONItem.ItemComponentType.NONE;
        }
        if (definition.booklet != null) {
            for (JSONText text : definition.booklet.titleText) {
                text.fieldName = "";
            }
            for (JSONItem.JSONBooklet.BookletPage page : definition.booklet.pages) {
                for (JSONText text : page.pageText) {
                    text.fieldName = "";
                }
            }
        }
    }

    private static void performSkinLegacyCompats(JSONSkin definition) {
        if (definition.general.packID != null) {
            definition.skin = new JSONSkin.Skin();
            definition.skin.packID = definition.general.packID;
            definition.general.packID = null;
            definition.skin.systemName = definition.general.systemName;
            definition.general.systemName = null;
        }
    }

    private static void performBulletLegacyCompats(JSONBullet definition) {
        if (definition.definitions == null) {
            definition.definitions = new ArrayList();
            JSONSubDefinition subDefinition = new JSONSubDefinition();
            subDefinition.extraMaterials = new ArrayList<String>();
            subDefinition.name = definition.general.name;
            subDefinition.subName = "";
            definition.definitions.add(subDefinition);
        }
        if (definition.bullet.damage == 0.0f) {
            definition.bullet.damage = definition.bullet.diameter / 5.0f;
        }
        if (definition.bullet.guidanceType == null && definition.bullet.turnRate > 0.0f) {
            definition.bullet.guidanceType = JSONBullet.GuidanceType.ACTIVE;
        }
        if (definition.bullet.seekerMaxAngle == 0.0) {
            definition.bullet.seekerMaxAngle = 90.0;
        }
        if (definition.bullet.seekerRange == 0) {
            definition.bullet.seekerRange = 1024;
        }
        if (definition.rendering == null || definition.rendering.particles == null) {
            if (definition.rendering == null) {
                definition.rendering = new JSONRendering();
            }
            if (definition.rendering.particles == null) {
                definition.rendering.particles = new ArrayList<JSONParticle>();
            }
            JSONParticle particleDef = new JSONParticle();
            particleDef.type = JSONParticle.ParticleType.BREAK;
            particleDef.color = new ColorRGB("999999");
            particleDef.quantity = 4;
            particleDef.scale = 0.3f;
            particleDef.pos = new Point3D(0.0, 0.5, 0.0);
            particleDef.initialVelocity = new Point3D(0.0, 1.5, 0.0);
            particleDef.activeAnimations = new ArrayList<JSONAnimationDefinition>();
            JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
            activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
            activeAnimation.variable = "bullet_hit_block";
            activeAnimation.clampMin = 1.0f;
            activeAnimation.clampMax = 1.0f;
            particleDef.activeAnimations.add(activeAnimation);
            definition.rendering.particles.add(particleDef);
        }
    }

    private static void performParticleLegacyCompats(JSONParticle particleDef) {
        if (particleDef.spreadFactorVertical != 0.0f || particleDef.spreadFactorHorizontal != 0.0f) {
            particleDef.spreadRandomness = new Point3D(particleDef.initialVelocity.x * (double)particleDef.spreadFactorHorizontal, (double)particleDef.spreadFactorVertical / 2.0, particleDef.initialVelocity.z * (double)particleDef.spreadFactorHorizontal);
            particleDef.spreadFactorVertical = 0.0f;
            particleDef.spreadFactorHorizontal = 0.0f;
        }
        if (particleDef.renderingOrientation == null) {
            JSONParticle.ParticleRenderingOrientation particleRenderingOrientation = particleDef.renderingOrientation = particleDef.axisAligned ? JSONParticle.ParticleRenderingOrientation.FIXED : JSONParticle.ParticleRenderingOrientation.PLAYER;
        }
        if (particleDef.spawningOrientation == null) {
            particleDef.spawningOrientation = JSONParticle.ParticleSpawningOrientation.ENTITY;
        }
        if (particleDef.subParticles != null) {
            for (JSONParticle.JSONSubParticle subParticleDef : particleDef.subParticles) {
                LegacyCompatSystem.performParticleLegacyCompats(subParticleDef.particle);
            }
        }
        if (particleDef.hitboxSize == 0.0f) {
            particleDef.hitboxSize = particleDef.type == JSONParticle.ParticleType.BREAK ? 0.1f : 0.2f;
            particleDef.scale *= particleDef.hitboxSize;
            particleDef.toScale *= particleDef.hitboxSize;
        }
    }

    private static void performPartSlotListingLegacyCompats(List<JSONPartDefinition> partDefs, boolean linkFrontWheels, boolean linkRearWheels) {
        for (int i = 0; i < partDefs.size(); ++i) {
            JSONPartDefinition partDef = partDefs.get(i);
            if (partDef.additionalParts == null) continue;
            for (JSONPartDefinition additionalDef : partDef.additionalParts) {
                if (i + 1 == partDefs.size()) {
                    partDefs.add(additionalDef);
                } else {
                    partDefs.add(i + 1, additionalDef);
                }
                if (additionalDef.interactableVariables == null) {
                    additionalDef.interactableVariables = new ArrayList<List<String>>();
                }
                ArrayList<String> presenceList = new ArrayList<String>();
                presenceList.add("part_present_" + (i + 1));
                additionalDef.interactableVariables.add(presenceList);
                if (partDef.interactableVariables == null) continue;
                for (List<String> list : partDef.interactableVariables) {
                    ArrayList<String> copiedList = new ArrayList<String>(list);
                    additionalDef.interactableVariables.add((List<String>)copiedList);
                }
            }
            partDef.additionalParts = null;
        }
        boolean linkedPartsPresent = false;
        for (JSONPartDefinition partDef : partDefs) {
            if (partDef.linkedParts == null) continue;
            linkedPartsPresent = true;
            break;
        }
        if (!linkedPartsPresent) {
            for (JSONPartDefinition partDef : partDefs) {
                if (partDef.linkedParts != null) continue;
                for (String partDefType : partDef.types) {
                    if (partDefType.startsWith("engine")) {
                        partDef.linkedParts = new ArrayList<Integer>();
                        block6: for (JSONPartDefinition jSONPartDefinition : partDefs) {
                            for (String string : jSONPartDefinition.types) {
                                if (!string.startsWith("propeller") && (!string.startsWith("ground") || !(linkFrontWheels && jSONPartDefinition.pos.z > 0.0) && (!linkRearWheels || !(jSONPartDefinition.pos.z <= 0.0)))) continue;
                                if (partDef.linkedParts.contains(partDefs.indexOf(jSONPartDefinition) + 1)) continue block6;
                                partDef.linkedParts.add(partDefs.indexOf(jSONPartDefinition) + 1);
                                continue block6;
                            }
                        }
                        continue;
                    }
                    if (partDefType.startsWith("gun")) {
                        partDef.linkedParts = new ArrayList<Integer>();
                        boolean foundLink = false;
                        if (partDef.interactableVariables != null) {
                            for (List<String> variables : partDef.interactableVariables) {
                                for (String variable : variables) {
                                    if (!variable.startsWith("part_present")) continue;
                                    if (!partDef.linkedParts.contains(Integer.parseInt(variable.substring("part_present_".length())))) {
                                        partDef.linkedParts.add(Integer.parseInt(variable.substring("part_present_".length())));
                                    }
                                    foundLink = true;
                                    break;
                                }
                                if (!foundLink) continue;
                                break;
                            }
                        }
                        if (foundLink) continue;
                        block10: for (JSONPartDefinition partDef22 : partDefs) {
                            if (!partDef22.isController) continue;
                            for (String partDefType22 : partDef22.types) {
                                if (!partDefType22.startsWith("seat")) continue;
                                if (partDef.linkedParts.contains(partDefs.indexOf(partDef22) + 1)) continue block10;
                                partDef.linkedParts.add(partDefs.indexOf(partDef22) + 1);
                                continue block10;
                            }
                        }
                        continue;
                    }
                    if (!partDefType.startsWith("effector")) continue;
                    partDef.linkedParts = new ArrayList<Integer>();
                    block12: for (JSONPartDefinition jSONPartDefinition : partDefs) {
                        for (String string : jSONPartDefinition.types) {
                            if (!string.startsWith("interactable")) continue;
                            if (partDef.linkedParts.contains(partDefs.indexOf(jSONPartDefinition) + 1)) continue block12;
                            partDef.linkedParts.add(partDefs.indexOf(jSONPartDefinition) + 1);
                            continue block12;
                        }
                    }
                }
            }
        }
    }

    private static void performVehiclePartDefLegacyCompats(JSONPartDefinition partDef) {
        String partName;
        int i;
        if (partDef.additionalPart != null) {
            partDef.additionalParts = new ArrayList<JSONPartDefinition>();
            partDef.additionalParts.add(partDef.additionalPart);
            partDef.additionalPart = null;
        }
        if (partDef.linkedDoor != null) {
            partDef.linkedDoors = new ArrayList<String>();
            partDef.linkedDoors.add(partDef.linkedDoor);
            partDef.linkedDoor = null;
        }
        if (partDef.linkedDoors != null) {
            partDef.linkedVariables = partDef.linkedDoors;
            partDef.linkedDoors = null;
        }
        if (partDef.linkedVariables != null) {
            partDef.interactableVariables = new ArrayList<List<String>>();
            partDef.interactableVariables.add(partDef.linkedVariables);
            partDef.linkedVariables = null;
        }
        if (partDef.exhaustPos != null) {
            partDef.particleObjects = new ArrayList<JSONParticle>();
            for (i = 0; i < partDef.exhaustPos.length; i += 3) {
                JSONParticle particle = new JSONParticle();
                particle.type = JSONParticle.ParticleType.SMOKE;
                particle.pos = new Point3D(partDef.exhaustPos[i], partDef.exhaustPos[i + 1], partDef.exhaustPos[i + 2]);
                particle.velocityVector = new Point3D(partDef.exhaustVelocity[i], partDef.exhaustVelocity[i + 1], partDef.exhaustVelocity[i + 2]);
                particle.scale = 1.0f;
                particle.color = new ColorRGB("#D9D9D9");
                particle.transparency = 0.25f;
                particle.toTransparency = 0.25f;
                partDef.particleObjects.add(particle);
            }
            partDef.exhaustPos = null;
            partDef.exhaustVelocity = null;
        }
        if (partDef.exhaustObjects != null) {
            partDef.particleObjects = new ArrayList<JSONParticle>();
            for (JSONPartDefinition.ExhaustObject exhaust : partDef.exhaustObjects) {
                Object particle = new JSONParticle();
                ((JSONParticle)particle).type = JSONParticle.ParticleType.SMOKE;
                ((JSONParticle)particle).pos = exhaust.pos;
                ((JSONParticle)particle).velocityVector = exhaust.velocity;
                ((JSONParticle)particle).scale = exhaust.scale;
                ((JSONParticle)particle).color = new ColorRGB("#D9D9D9");
                ((JSONParticle)particle).transparency = 0.25f;
                ((JSONParticle)particle).toTransparency = 0.25f;
                partDef.particleObjects.add((JSONParticle)particle);
            }
            partDef.exhaustObjects = null;
        }
        if (partDef.rotationVariable != null) {
            partDef.animations = new ArrayList<JSONAnimationDefinition>();
            JSONAnimationDefinition animation = new JSONAnimationDefinition();
            animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
            animation.variable = partDef.rotationVariable;
            animation.centerPoint = partDef.rotationPosition;
            animation.axis = partDef.rotationAngles;
            animation.clampMin = partDef.rotationClampMin;
            animation.clampMax = partDef.rotationClampMax;
            animation.absolute = partDef.rotationAbsolute;
            partDef.animations.add(animation);
            partDef.rotationVariable = null;
            partDef.rotationPosition = null;
            partDef.rotationAngles = null;
            partDef.rotationClampMin = 0.0f;
            partDef.rotationClampMax = 0.0f;
            partDef.rotationAbsolute = false;
        }
        if (partDef.translationVariable != null) {
            if (partDef.animations == null) {
                partDef.animations = new ArrayList<JSONAnimationDefinition>();
            }
            JSONAnimationDefinition animation = new JSONAnimationDefinition();
            animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
            animation.variable = partDef.translationVariable;
            animation.axis = partDef.translationPosition;
            animation.clampMin = partDef.translationClampMin;
            animation.clampMax = partDef.translationClampMax;
            animation.absolute = partDef.translationAbsolute;
            partDef.animations.add(animation);
            partDef.translationVariable = null;
            partDef.translationPosition = null;
            partDef.translationClampMin = 0.0f;
            partDef.translationClampMax = 0.0f;
            partDef.translationAbsolute = false;
        }
        for (i = 0; i < partDef.types.size(); i = (int)((byte)(i + 1))) {
            partName = partDef.types.get(i);
            switch (partName) {
                case "wheel": 
                case "skid": 
                case "pontoon": 
                case "tread": {
                    if (partName.equals("tread")) {
                        partDef.turnsWithSteer = true;
                    }
                    partDef.types.set(i, "ground_" + partName);
                    break;
                }
                case "crate": 
                case "barrel": 
                case "crafting_table": 
                case "furnace": 
                case "brewing_stand": {
                    partDef.types.set(i, "interactable_" + partName);
                    partDef.minValue = 0.0f;
                    partDef.maxValue = 1.0f;
                    break;
                }
                case "fertilizer": 
                case "harvester": 
                case "planter": 
                case "plow": {
                    partDef.types.set(i, "effector_" + partName);
                    break;
                }
                case "custom": {
                    partDef.types.set(i, "generic");
                }
            }
            partName = partDef.types.get(i);
            if (partName.startsWith("ground_wheel") && partDef.turnsWithSteer) {
                if (partDef.animations == null) {
                    if (partDef.applyAfter == null) {
                        partDef.animations = new ArrayList<JSONAnimationDefinition>();
                        JSONAnimationDefinition animation = new JSONAnimationDefinition();
                        animation.centerPoint = partDef.pos.copy();
                        animation.axis = new Point3D(0.0, partDef.pos.z > 0.0 ? -1.0 : 1.0, 0.0);
                        animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                        animation.variable = "rudder";
                        partDef.animations.add(animation);
                    }
                } else {
                    for (JSONAnimationDefinition animation : partDef.animations) {
                        if (!animation.animationType.equals((Object)JSONAnimationDefinition.AnimationComponentType.ROTATION) || !animation.variable.equals("rudder") || !animation.centerPoint.isZero()) continue;
                        animation.centerPoint.set(partDef.pos);
                    }
                }
            }
            if (partDef.additionalParts == null) continue;
            for (JSONPartDefinition additionalPartDef : partDef.additionalParts) {
                LegacyCompatSystem.performVehiclePartDefLegacyCompats(additionalPartDef);
            }
        }
        if (partDef.widthScale != 0.0f || partDef.heightScale != 0.0f) {
            if (partDef.widthScale == 0.0f) {
                partDef.widthScale = 1.0f;
            }
            if (partDef.heightScale == 0.0f) {
                partDef.heightScale = 1.0f;
            }
            partDef.playerScale = new Point3D(partDef.widthScale, partDef.heightScale, partDef.widthScale);
            partDef.widthScale = 0.0f;
            partDef.heightScale = 0.0f;
        }
        for (i = 0; i < partDef.types.size(); i = (int)((byte)(i + 1))) {
            partName = partDef.types.get(i);
            if (partDef.rot != null || !partName.startsWith("ground_wheel") && !partDef.inverseMirroring) continue;
            boolean bl = partDef.isMirrored = partDef.pos.x < 0.0 && !partDef.inverseMirroring || partDef.pos.x >= 0.0 && partDef.inverseMirroring;
            if (partDef.isMirrored && partDef.rot == null) {
                partDef.rot = new RotationMatrix().rotateY(180.0);
            }
            partDef.inverseMirroring = false;
            break;
        }
    }

    private static void performVehicleConnectionLegacyCompats(AJSONInteractableEntity interactableDef) {
        if (interactableDef.connections != null) {
            interactableDef.connectionGroups = new ArrayList<JSONConnectionGroup>();
            JSONConnectionGroup hitchGroup = null;
            JSONConnectionGroup hookupGroup = null;
            for (JSONConnection connection : interactableDef.connections) {
                if (connection.hookup) {
                    if (hookupGroup == null) {
                        hookupGroup = new JSONConnectionGroup();
                        hookupGroup.connections = new ArrayList<JSONConnection>();
                        hookupGroup.groupName = "HOOKUP";
                        hookupGroup.hookup = true;
                    }
                    connection.hookup = false;
                    hookupGroup.connections.add(connection);
                    continue;
                }
                if (hitchGroup == null) {
                    hitchGroup = new JSONConnectionGroup();
                    hitchGroup.connections = new ArrayList<JSONConnection>();
                    hitchGroup.groupName = "TRAILER";
                    hitchGroup.canInitiateConnections = true;
                }
                hitchGroup.connections.add(connection);
            }
            if (hookupGroup != null) {
                interactableDef.connectionGroups.add(hookupGroup);
            }
            if (hitchGroup != null) {
                interactableDef.connectionGroups.add(hitchGroup);
            }
            interactableDef.connections = null;
        }
        if (interactableDef.connectionGroups != null) {
            for (JSONConnectionGroup connectionGroup : interactableDef.connectionGroups) {
                if (connectionGroup.hookup) {
                    connectionGroup.isHookup = true;
                    connectionGroup.hookup = false;
                }
                if (!connectionGroup.isHookup && !connectionGroup.isHitch) {
                    connectionGroup.isHitch = true;
                }
                for (JSONConnection connection : connectionGroup.connections) {
                    if (connection.distance != 0.0) continue;
                    connection.distance = 2.0;
                }
                if (connectionGroup.canIntiateConnections) {
                    connectionGroup.canInitiateConnections = true;
                    connectionGroup.canIntiateConnections = false;
                }
                if (!connectionGroup.canIntiateSubConnections) continue;
                connectionGroup.canInitiateSubConnections = true;
                connectionGroup.canIntiateSubConnections = false;
            }
        }
    }

    private static void performVehicleCollisionLegacyCompats(AJSONInteractableEntity interactableDef) {
        Object collisionGroup;
        if (interactableDef.doors != null) {
            if (interactableDef.collisionGroups == null) {
                interactableDef.collisionGroups = new ArrayList<JSONCollisionGroup>();
            }
            for (JSONDoor door : interactableDef.doors) {
                if (!door.closedByDefault) {
                    if (interactableDef.rendering.initialVariables == null) {
                        interactableDef.rendering.initialVariables = new ArrayList<String>();
                    }
                    interactableDef.rendering.initialVariables.add(door.name);
                }
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = new ArrayList<JSONCollisionBox>();
                ((JSONCollisionGroup)collisionGroup).isInterior = true;
                JSONCollisionBox collision = new JSONCollisionBox();
                collision.variableName = door.ignoresClicks ? null : door.name;
                collision.pos = door.closedPos;
                collision.width = door.width;
                collision.height = door.height;
                collision.armorThickness = door.armorThickness;
                ((JSONCollisionGroup)collisionGroup).collisions.add(collision);
                ((JSONCollisionGroup)collisionGroup).animations = new ArrayList<JSONAnimationDefinition>();
                JSONAnimationDefinition animation = new JSONAnimationDefinition();
                animation.axis = door.openPos.subtract(door.closedPos);
                animation.animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                animation.variable = door.name;
                ((JSONCollisionGroup)collisionGroup).animations.add(animation);
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            interactableDef.doors = null;
        }
        if (interactableDef.collision != null) {
            if (interactableDef.collisionGroups == null) {
                interactableDef.collisionGroups = new ArrayList<JSONCollisionGroup>();
            }
            ArrayList<JSONCollisionBox> interiorBoxes = new ArrayList<JSONCollisionBox>();
            ArrayList<JSONCollisionBox> exteriorBoxes = new ArrayList<JSONCollisionBox>();
            for (JSONCollisionBox boxDef : interactableDef.collision) {
                if (boxDef.isInterior) {
                    interiorBoxes.add(boxDef);
                    boxDef.isInterior = false;
                    continue;
                }
                exteriorBoxes.add(boxDef);
            }
            if (!interiorBoxes.isEmpty()) {
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = interiorBoxes;
                ((JSONCollisionGroup)collisionGroup).isInterior = true;
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            if (!exteriorBoxes.isEmpty()) {
                collisionGroup = new JSONCollisionGroup();
                ((JSONCollisionGroup)collisionGroup).collisions = exteriorBoxes;
                interactableDef.collisionGroups.add((JSONCollisionGroup)collisionGroup);
            }
            interactableDef.collision = null;
        }
        if (interactableDef.collisionGroups != null) {
            for (JSONCollisionGroup group : interactableDef.collisionGroups) {
                for (JSONCollisionBox box : group.collisions) {
                    if (box.variableName == null || box.variableType != null) continue;
                    box.variableType = JSONCollisionBox.VariableType.TOGGLE;
                }
            }
        }
    }

    private static void performAnimationLegacyCompats(JSONRendering rendering) {
        Object animation;
        Object object;
        if (rendering.textMarkings != null) {
            rendering.textObjects = new ArrayList<JSONText>();
            for (JSONRendering.VehicleDisplayText marking : rendering.textMarkings) {
                object = new JSONText();
                ((JSONText)object).lightsUp = rendering.textLighted;
                ((JSONText)object).color = marking.color;
                ((JSONText)object).scale = marking.scale;
                ((JSONText)object).maxLength = rendering.displayTextMaxLength;
                ((JSONText)object).pos = marking.pos;
                ((JSONText)object).rot = marking.rot;
                ((JSONText)object).fieldName = "Text";
                ((JSONText)object).defaultText = rendering.defaultDisplayText;
                rendering.textObjects.add((JSONText)object);
            }
            rendering.textMarkings = null;
            rendering.defaultDisplayText = null;
            rendering.displayTextMaxLength = 0;
            rendering.textLighted = false;
        }
        if (rendering.rotatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            }
            for (JSONRendering.VehicleRotatableModelObject rotatable : rendering.rotatableModelObjects) {
                object = null;
                for (JSONAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(rotatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = new JSONAnimatedObject();
                    ((JSONAnimatedObject)object).objectName = rotatable.partName;
                    ((JSONAnimatedObject)object).animations = new ArrayList<JSONAnimationDefinition>();
                    rendering.animatedObjects.add((JSONAnimatedObject)object);
                }
                animation = new JSONAnimationDefinition();
                ((JSONAnimationDefinition)animation).animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                ((JSONAnimationDefinition)animation).variable = rotatable.rotationVariable;
                ((JSONAnimationDefinition)animation).centerPoint = rotatable.rotationPoint;
                ((JSONAnimationDefinition)animation).axis = rotatable.rotationAxis != null ? rotatable.rotationAxis : new Point3D();
                ((JSONAnimationDefinition)animation).clampMin = rotatable.rotationClampMin;
                ((JSONAnimationDefinition)animation).clampMax = rotatable.rotationClampMax;
                ((JSONAnimationDefinition)animation).absolute = rotatable.absoluteValue;
                if (rotatable.rotationVariable.equals("steering_wheel")) {
                    ((JSONAnimationDefinition)animation).variable = "rudder";
                    ((JSONAnimationDefinition)animation).axis.invert();
                }
                if (rotatable.rotationVariable.equals("door")) {
                    ((JSONAnimationDefinition)animation).duration = 30;
                }
                ((JSONAnimatedObject)object).animations.add((JSONAnimationDefinition)animation);
            }
            rendering.rotatableModelObjects = null;
        }
        if (rendering.translatableModelObjects != null) {
            if (rendering.animatedObjects == null) {
                rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
            }
            for (JSONRendering.VehicleTranslatableModelObject translatable : rendering.translatableModelObjects) {
                object = null;
                for (JSONAnimatedObject testObject : rendering.animatedObjects) {
                    if (!testObject.objectName.equals(translatable.partName)) continue;
                    object = testObject;
                    break;
                }
                if (object == null) {
                    object = new JSONAnimatedObject();
                    ((JSONAnimatedObject)object).objectName = translatable.partName;
                    ((JSONAnimatedObject)object).animations = new ArrayList<JSONAnimationDefinition>();
                    rendering.animatedObjects.add((JSONAnimatedObject)object);
                }
                animation = new JSONAnimationDefinition();
                ((JSONAnimationDefinition)animation).animationType = JSONAnimationDefinition.AnimationComponentType.TRANSLATION;
                ((JSONAnimationDefinition)animation).variable = translatable.translationVariable;
                ((JSONAnimationDefinition)animation).axis = translatable.translationAxis;
                ((JSONAnimationDefinition)animation).clampMin = translatable.translationClampMin;
                ((JSONAnimationDefinition)animation).clampMax = translatable.translationClampMax;
                ((JSONAnimationDefinition)animation).absolute = translatable.absoluteValue;
                if (translatable.translationVariable.equals("steering_wheel")) {
                    ((JSONAnimationDefinition)animation).variable = "rudder";
                    ((JSONAnimationDefinition)animation).axis.invert();
                }
                if (translatable.translationVariable.equals("door")) {
                    ((JSONAnimationDefinition)animation).duration = 30;
                }
                ((JSONAnimatedObject)object).animations.add((JSONAnimationDefinition)animation);
            }
            rendering.translatableModelObjects = null;
        }
        if (rendering.particles != null) {
            for (JSONParticle particle : rendering.particles) {
                if (particle.quantity != 0) continue;
                particle.quantity = 1;
            }
        }
    }

    private static void performModelLegacyCompats(AJSONMultiModelProvider definition) {
        if (definition.rendering == null) {
            definition.rendering = new JSONRendering();
        } else if (definition.rendering.particles != null) {
            definition.rendering.particles.removeIf(particle -> particle.type == JSONParticle.ParticleType.DRIP);
        }
        try {
            List<RenderableObject> parsedModel = AModelParser.parseModel(definition.getModelLocation(definition.definitions.get(0)));
            if (definition.rendering.lightObjects == null) {
                definition.rendering.lightObjects = new ArrayList<JSONLight>();
                for (RenderableObject object : parsedModel) {
                    boolean renderBeam;
                    Object lightProperties;
                    if (!object.name.contains("&")) continue;
                    JSONLight lightDef = new JSONLight();
                    lightDef.objectName = object.name;
                    lightDef.brightnessAnimations = new ArrayList<JSONAnimationDefinition>();
                    lightDef.color = new ColorRGB(object.name.substring(object.name.indexOf(95) + 1, object.name.indexOf(95) + 7));
                    lightDef.brightnessAnimations = new ArrayList<JSONAnimationDefinition>();
                    String lowerCaseName = object.name.toLowerCase(Locale.ROOT);
                    JSONAnimationDefinition activeAnimation = new JSONAnimationDefinition();
                    if (lowerCaseName.contains("brakelight")) {
                        activeAnimation.variable = "brake";
                    } else if (lowerCaseName.contains("backuplight")) {
                        activeAnimation.variable = "engine_reversed_1";
                    } else if (lowerCaseName.contains("daytimelight")) {
                        activeAnimation.variable = "engines_on";
                    } else if (lowerCaseName.contains("navigationlight")) {
                        activeAnimation.variable = "navigation_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasNavLights = true;
                        }
                    } else if (lowerCaseName.contains("strobelight")) {
                        activeAnimation.variable = "strobe_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasStrobeLights = true;
                        }
                    } else if (lowerCaseName.contains("taxilight")) {
                        activeAnimation.variable = "taxi_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTaxiLights = true;
                        }
                    } else if (lowerCaseName.contains("landinglight")) {
                        activeAnimation.variable = "landing_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasLandingLights = true;
                        }
                    } else if (lowerCaseName.contains("runninglight")) {
                        activeAnimation.variable = "running_light";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasRunningLights = true;
                        }
                    } else if (lowerCaseName.contains("headlight")) {
                        activeAnimation.variable = "headlight";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasHeadlights = true;
                        }
                    } else if (lowerCaseName.contains("leftturnlight")) {
                        activeAnimation.variable = "left_turn_signal";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTurnSignals = true;
                        }
                    } else if (lowerCaseName.contains("rightturnlight")) {
                        activeAnimation.variable = "right_turn_signal";
                        if (definition instanceof JSONVehicle) {
                            ((JSONVehicle)definition).motorized.hasTurnSignals = true;
                        }
                    } else if (lowerCaseName.contains("emergencylight")) {
                        activeAnimation.variable = "EMERLTS";
                        if (definition.rendering.customVariables == null) {
                            definition.rendering.customVariables = new ArrayList<String>();
                        }
                        if (definition instanceof JSONVehicle) {
                            definition.rendering.customVariables.add("EMERLTS");
                        }
                    } else if (lowerCaseName.contains("stoplight") || lowerCaseName.contains("cautionlight") || lowerCaseName.contains("golight")) {
                        String[] lightNames = lowerCaseName.split("light");
                        lightNames[0] = lightNames[0].replace("&", "");
                        activeAnimation.variable = lightNames[0] + "_light";
                        if (lightNames.length > 2) {
                            activeAnimation.variable = activeAnimation.variable + "_" + lightNames[2];
                        }
                        if (lightNames[0].equals("stop")) {
                            JSONAnimationDefinition cycleInhibitor = new JSONAnimationDefinition();
                            cycleInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                            cycleInhibitor.variable = "linked";
                            cycleInhibitor.clampMin = 1.0f;
                            cycleInhibitor.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(cycleInhibitor);
                            JSONAnimationDefinition cycleAnimation = new JSONAnimationDefinition();
                            cycleAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                            cycleAnimation.variable = "0_10_10_cycle";
                            cycleAnimation.clampMin = 1.0f;
                            cycleAnimation.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(cycleAnimation);
                            JSONAnimationDefinition lightActivator = new JSONAnimationDefinition();
                            lightActivator.animationType = JSONAnimationDefinition.AnimationComponentType.ACTIVATOR;
                            lightActivator.variable = "linked";
                            lightActivator.clampMin = 1.0f;
                            lightActivator.clampMax = 1.0f;
                            lightDef.brightnessAnimations.add(lightActivator);
                            JSONAnimationDefinition lightInhibitor = new JSONAnimationDefinition();
                            lightInhibitor.animationType = JSONAnimationDefinition.AnimationComponentType.INHIBITOR;
                            lightInhibitor.variable = "linked";
                            lightInhibitor.clampMin = 0.0f;
                            lightInhibitor.clampMax = 0.0f;
                            lightDef.brightnessAnimations.add(lightInhibitor);
                        }
                    }
                    if (activeAnimation.variable != null) {
                        activeAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        activeAnimation.clampMin = activeAnimation.variable.equals("brake") ? 0.01f : 1.0f;
                        activeAnimation.clampMax = 1.0f;
                        lightDef.brightnessAnimations.add(activeAnimation);
                    }
                    lightDef.isElectric = true;
                    int flashBits = Integer.decode("0x" + object.name.substring(object.name.indexOf(95, object.name.indexOf(95) + 7) + 1, object.name.lastIndexOf(95)));
                    int ticksTillOn = 0;
                    int ticksOn = 0;
                    boolean foundOn = false;
                    for (int i = 0; i < 20; i = (int)((byte)(i + 1))) {
                        if ((flashBits >> i & 1) == 1) {
                            if (!foundOn) {
                                foundOn = true;
                                ticksTillOn = i;
                            }
                            ++ticksOn;
                            continue;
                        }
                        if (foundOn) break;
                    }
                    if (ticksOn - ticksTillOn != 20) {
                        JSONAnimationDefinition cycleAnimation = new JSONAnimationDefinition();
                        cycleAnimation.animationType = JSONAnimationDefinition.AnimationComponentType.VISIBILITY;
                        cycleAnimation.variable = ticksTillOn + "_" + ticksOn + "_" + (20 - ticksOn - ticksTillOn) + "_cycle";
                        cycleAnimation.clampMin = 1.0f;
                        cycleAnimation.clampMax = 1.0f;
                        lightDef.brightnessAnimations.add(cycleAnimation);
                    }
                    boolean renderFlare = Integer.parseInt(((String)(lightProperties = object.name.substring(object.name.lastIndexOf(95) + 1))).substring(0, 1)) > 0;
                    lightDef.emissive = Integer.parseInt(((String)lightProperties).substring(1, 2)) > 0;
                    boolean bl = lightDef.covered = Integer.parseInt(((String)lightProperties).substring(2, 3)) > 0;
                    boolean bl2 = ((String)lightProperties).length() == 4 ? Integer.parseInt(((String)lightProperties).substring(3)) > 0 : (renderBeam = lowerCaseName.contains("headlight") || lowerCaseName.contains("landinglight") || lowerCaseName.contains("taxilight") || lowerCaseName.contains("streetlight"));
                    if (renderFlare || renderBeam) {
                        if (lightDef.blendableComponents == null) {
                            lightDef.blendableComponents = new ArrayList<JSONLight.JSONLightBlendableComponent>();
                        }
                        float[] masterVertex = new float[8];
                        for (int i = 0; i < object.vertices.capacity(); i += 24) {
                            float minX = 999.0f;
                            float maxX = -999.0f;
                            float minY = 999.0f;
                            float maxY = -999.0f;
                            float minZ = 999.0f;
                            float maxZ = -999.0f;
                            for (int j = 0; j < 24; j = (int)((byte)(j + 8))) {
                                object.vertices.get(masterVertex);
                                minX = Math.min(masterVertex[5], minX);
                                maxX = Math.max(masterVertex[5], maxX);
                                minY = Math.min(masterVertex[6], minY);
                                maxY = Math.max(masterVertex[6], maxY);
                                minZ = Math.min(masterVertex[7], minZ);
                                maxZ = Math.max(masterVertex[7], maxZ);
                            }
                            JSONLight.JSONLightBlendableComponent blendable = new JSONLight.JSONLightBlendableComponent();
                            if (renderFlare) {
                                blendable.flareWidth = blendable.flareHeight = 3.0f * Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
                            }
                            if (renderBeam) {
                                blendable.beamDiameter = Math.max(Math.max(maxX - minX, maxZ - minZ), maxY - minY) * 64.0f;
                                blendable.beamLength = blendable.beamDiameter * 3.0f;
                            }
                            blendable.pos = new Point3D((double)minX + (double)(maxX - minX) / 2.0, (double)minY + (double)(maxY - minY) / 2.0, (double)minZ + (double)(maxZ - minZ) / 2.0);
                            blendable.axis = new Point3D(masterVertex[0], masterVertex[1], masterVertex[2]);
                            lightDef.blendableComponents.add(blendable);
                        }
                    }
                    definition.rendering.lightObjects.add(lightDef);
                }
            }
            ArrayList<String> leftRollers = new ArrayList<String>();
            ArrayList<String> rightRollers = new ArrayList<String>();
            for (RenderableObject object : parsedModel) {
                if (!object.name.toLowerCase(Locale.ROOT).contains("roller")) continue;
                if (object.name.toLowerCase(Locale.ROOT).startsWith("l") || object.name.toLowerCase(Locale.ROOT).startsWith("$l")) {
                    leftRollers.add(object.name);
                    continue;
                }
                rightRollers.add(object.name);
            }
            if (!leftRollers.isEmpty() || !rightRollers.isEmpty()) {
                Comparator sorter = (roller1, roller2) -> {
                    int roller1Index = Integer.parseInt(roller1.substring(roller1.lastIndexOf(95) + 1));
                    int roller2Index = Integer.parseInt(roller2.substring(roller2.lastIndexOf(95) + 1));
                    return Integer.compare(roller1Index, roller2Index);
                };
                leftRollers.sort(sorter);
                rightRollers.sort(sorter);
                if (leftRollers.isEmpty()) {
                    leftRollers.addAll(rightRollers);
                }
                int leftSlotIndex = -1;
                int rightSlotIndex = -1;
                for (JSONPartDefinition partDef : ((AJSONPartProvider)definition).parts) {
                    if (!partDef.types.contains("ground_tread")) continue;
                    if (partDef.pos.x <= 0.0) {
                        rightSlotIndex = ((AJSONPartProvider)definition).parts.indexOf(partDef) + 1;
                        if (partDef.treadPath != null) continue;
                        partDef.treadPath = rightRollers;
                        continue;
                    }
                    leftSlotIndex = ((AJSONPartProvider)definition).parts.indexOf(partDef) + 1;
                    if (partDef.treadPath != null) continue;
                    partDef.treadPath = leftRollers;
                }
                HashSet<String> allRollers = new HashSet<String>();
                allRollers.addAll(leftRollers);
                allRollers.addAll(rightRollers);
                for (String rollerName : allRollers) {
                    boolean animationPresent = false;
                    if (definition.rendering != null && definition.rendering.animatedObjects != null) {
                        for (JSONAnimatedObject animatedObject : definition.rendering.animatedObjects) {
                            if (!rollerName.equals(animatedObject.objectName)) continue;
                            animationPresent = true;
                            break;
                        }
                    }
                    if (animationPresent) continue;
                    RenderableObject rollerObject = null;
                    TreadRoller roller = null;
                    for (RenderableObject object : parsedModel) {
                        if (!object.name.equals(rollerName)) continue;
                        rollerObject = object;
                        roller = new TreadRoller(object);
                        break;
                    }
                    JSONAnimationDefinition animation = new JSONAnimationDefinition();
                    animation.animationType = JSONAnimationDefinition.AnimationComponentType.ROTATION;
                    animation.variable = "ground_rotation_" + (leftRollers.contains(rollerName) ? leftSlotIndex : rightSlotIndex);
                    animation.centerPoint = roller.centerPoint;
                    animation.axis = new Point3D(0.3183098861837907 / (roller.radius * 2.0), 0.0, 0.0);
                    if (definition.rendering == null) {
                        definition.rendering = new JSONRendering();
                    }
                    if (definition.rendering.animatedObjects == null) {
                        definition.rendering.animatedObjects = new ArrayList<JSONAnimatedObject>();
                    }
                    JSONAnimatedObject animatedObject = new JSONAnimatedObject();
                    animatedObject.objectName = rollerObject.name;
                    animatedObject.animations = new ArrayList<JSONAnimationDefinition>();
                    animatedObject.animations.add(animation);
                    definition.rendering.animatedObjects.add(animatedObject);
                }
            }
        }
        catch (Exception e) {
            InterfaceManager.coreInterface.logError("Could not do model-based legacy compats on " + definition.packID + ":" + definition.systemName + ".  Lights and treads will likely not be present on this model.");
            InterfaceManager.coreInterface.logError(e.getMessage());
        }
    }
}

