/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;

public class PacketPlayerItemTransfer
extends APacketEntityInteract<EntityInventoryContainer, IWrapperPlayer> {
    private final int inventorySlot;
    private final int playerSlot;
    private final boolean saveToPlayer;

    public PacketPlayerItemTransfer(EntityInventoryContainer inventory, IWrapperPlayer player, int inventorySlot, int playerSlot, boolean saveToPlayer) {
        super(inventory, player);
        this.inventorySlot = inventorySlot;
        this.playerSlot = playerSlot;
        this.saveToPlayer = saveToPlayer;
    }

    public PacketPlayerItemTransfer(ByteBuf buf) {
        super(buf);
        this.inventorySlot = buf.readInt();
        this.playerSlot = buf.readInt();
        this.saveToPlayer = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        buf.writeInt(this.inventorySlot);
        buf.writeInt(this.playerSlot);
        buf.writeBoolean(this.saveToPlayer);
    }

    @Override
    public boolean handle(AWrapperWorld world, EntityInventoryContainer inventory, IWrapperPlayer player) {
        IWrapperItemStack stackToTransfer;
        IWrapperInventory playerInventory = player.getInventory();
        if (this.inventorySlot != -1) {
            stackToTransfer = inventory.getStack(this.inventorySlot);
            if (playerInventory.addStack(stackToTransfer)) {
                inventory.setStack(stackToTransfer, this.inventorySlot);
            }
        } else if (this.playerSlot != -1) {
            stackToTransfer = playerInventory.getStack(this.playerSlot);
            AItemBase item = stackToTransfer.getItem();
            if (item instanceof ItemPartInteractable && ((JSONPart)((ItemPartInteractable)item).definition).interactable.inventoryUnits != 0.0f) {
                return false;
            }
            if (item instanceof ItemDecor && ((JSONDecor)((ItemDecor)item).definition).decor.inventoryUnits != 0.0f) {
                return false;
            }
            if (inventory.addStack(stackToTransfer)) {
                playerInventory.setStack(stackToTransfer, this.playerSlot);
            }
        }
        if (this.saveToPlayer) {
            IWrapperNBT newData = InterfaceManager.coreInterface.getNewNBTWrapper();
            newData.setData("inventory", inventory.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
            player.getHeldStack().setData(newData);
        }
        return false;
    }
}

