/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public abstract class APacketEntityInteractHitbox
extends APacketEntity<AEntityE_Interactable<?>> {
    private final Point3D hitBoxLocalCenter;

    public APacketEntityInteractHitbox(AEntityE_Interactable<?> entity, BoundingBox hitBox) {
        super(entity);
        this.hitBoxLocalCenter = hitBox.localCenter;
    }

    public APacketEntityInteractHitbox(ByteBuf buf) {
        super(buf);
        this.hitBoxLocalCenter = APacketEntityInteractHitbox.readPoint3dFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        APacketEntityInteractHitbox.writePoint3dToBuffer(this.hitBoxLocalCenter, buf);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityE_Interactable<?> entity) {
        for (BoundingBox box : entity.damageCollisionBoxes) {
            if (!box.localCenter.equals(this.hitBoxLocalCenter)) continue;
            return this.handle(world, entity, box);
        }
        for (BoundingBox box : entity.inactiveCollisionBoxes) {
            if (!box.localCenter.equals(this.hitBoxLocalCenter)) continue;
            return this.handle(world, entity, box);
        }
        return false;
    }

    protected abstract boolean handle(AWrapperWorld var1, AEntityE_Interactable<?> var2, BoundingBox var3);
}

