/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.instances;

import java.util.List;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartInteractable;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.components.IItemEntityInteractable;
import minecrafttransportsimulator.items.components.IItemFood;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONPoleComponent;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.packets.instances.PacketPartInteractable;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class ItemItem
extends AItemPack<JSONItem>
implements IItemEntityInteractable,
IItemFood {
    public int pageNumber;
    public List<LanguageSystem.LanguageEntry> languageTitle;
    public List<LanguageSystem.LanguageEntry> languagePageTitle;
    public List<List<LanguageSystem.LanguageEntry>> languagePageText;
    private static PartEngine firstEngineClicked;
    private static PartInteractable firstPartClicked;

    public ItemItem(JSONItem definition) {
        super(definition, null);
    }

    @Override
    public boolean canBreakBlocks() {
        return !((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.WRENCH) && !((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.SCREWDRIVER);
    }

    @Override
    public void addTooltipLines(List<String> tooltipLines, IWrapperNBT data) {
        super.addTooltipLines(tooltipLines, data);
        switch (((JSONItem)this.definition).item.type) {
            case SCANNER: {
                tooltipLines.add(LanguageSystem.ITEMINFO_SCANNER.getCurrentValue());
                break;
            }
            case WRENCH: {
                tooltipLines.add(LanguageSystem.ITEMINFO_WRENCH.getCurrentValue());
                break;
            }
            case SCREWDRIVER: {
                tooltipLines.add(LanguageSystem.ITEMINFO_SCREWDRIVER.getCurrentValue());
                break;
            }
            case PAINT_GUN: {
                tooltipLines.add(LanguageSystem.ITEMINFO_PAINTGUN.getCurrentValue());
                break;
            }
            case KEY: {
                tooltipLines.add(LanguageSystem.ITEMINFO_KEY.getCurrentValue());
                break;
            }
            case TICKET: {
                tooltipLines.add(LanguageSystem.ITEMINFO_TICKET.getCurrentValue());
                break;
            }
            case FUEL_HOSE: {
                tooltipLines.add(LanguageSystem.ITEMINFO_FUELHOSE.getCurrentValue());
                break;
            }
            case JUMPER_CABLES: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JUMPERCABLES.getCurrentValue());
                break;
            }
            case JUMPER_PACK: {
                tooltipLines.add(LanguageSystem.ITEMINFO_JUMPERPACK.getCurrentValue());
                break;
            }
            case REPAIR_PACK: {
                tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK.getCurrentValue() + ((JSONItem)this.definition).repair.amount + " HP");
                if (!((JSONItem)this.definition).repair.canRepairTotaled) break;
                tooltipLines.add(LanguageSystem.ITEMINFO_REPAIRPACK_UNTOTAL.getCurrentValue());
                break;
            }
            case Y2K_BUTTON: {
                tooltipLines.add(LanguageSystem.ITEMINFO_Y2KBUTTON.getCurrentValue());
                break;
            }
        }
    }

    @Override
    public IItemEntityInteractable.CallbackType doEntityInteraction(AEntityE_Interactable<?> entity, BoundingBox hitBox, IWrapperPlayer player, AEntityE_Interactable.PlayerOwnerState ownerState, boolean rightClick) {
        switch (((JSONItem)this.definition).item.type) {
            case WRENCH: 
            case SCREWDRIVER: {
                if (!entity.world.isClient()) {
                    if (!ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                        if (rightClick) {
                            if (player.isSneaking()) {
                                if (entity instanceof APart && entity.text.isEmpty()) {
                                    player.sendPacket(new PacketEntityGUIRequest(((APart)((Object)entity)).masterEntity, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                                } else {
                                    player.sendPacket(new PacketEntityGUIRequest(entity, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                                }
                            } else if (entity instanceof EntityVehicleF_Physics) {
                                EntityVehicleF_Physics vehicle = entity;
                                if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && vehicle.allParts.contains(player.getEntityRiding())) {
                                    player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.PACK_EXPORTER));
                                } else if (!vehicle.allParts.contains(player.getEntityRiding())) {
                                    player.sendPacket(new PacketEntityGUIRequest(vehicle, player, PacketEntityGUIRequest.EntityGUIType.INSTRUMENTS));
                                }
                            }
                        } else if (player.isSneaking()) {
                            EntityVehicleF_Physics vehicle = entity instanceof APart ? ((APart)((Object)entity)).vehicleOn : (entity instanceof EntityVehicleF_Physics ? entity : null);
                            if (!(vehicle == null || ((Boolean)ConfigSystem.settings.general.opPickupVehiclesOnly.value).booleanValue() && !ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.ADMIN) || ((Boolean)ConfigSystem.settings.general.creativePickupVehiclesOnly.value).booleanValue() && !player.isCreative() || !entity.isValid)) {
                                vehicle.disconnectAllConnections();
                                vehicle.world.spawnItemStack(vehicle.getStack(), hitBox.globalCenter);
                                vehicle.remove();
                            }
                        } else if (entity instanceof APart) {
                            APart part = (APart)((Object)entity);
                            if (!part.isPermanent && part.isValid) {
                                LanguageSystem.LanguageEntry partResult = part.checkForRemoval();
                                if (partResult != null) {
                                    player.sendPacket(new PacketPlayerChatMessage(player, partResult, new Object[0]));
                                    return IItemEntityInteractable.CallbackType.NONE;
                                }
                                part.entityOn.world.spawnItemStack(part.getStack(), part.position);
                                part.entityOn.removePart(part, true, null);
                            }
                        }
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_OWNED, new Object[0]));
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case PAINT_GUN: {
                if (!entity.world.isClient() && rightClick) {
                    if (!ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                        player.sendPacket(new PacketEntityGUIRequest(entity, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                    } else {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_OWNED, new Object[0]));
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case KEY: {
                EntityVehicleF_Physics vehicle;
                EntityVehicleF_Physics entityVehicleF_Physics = vehicle = entity instanceof APart ? ((APart)((Object)entity)).vehicleOn : null;
                if (vehicle != null && rightClick && !entity.world.isClient()) {
                    UUID keyVehicleUUID;
                    IWrapperItemStack stack = player.getHeldStack();
                    IWrapperNBT data = stack.getData();
                    UUID uUID = keyVehicleUUID = data != null ? data.getUUID("vehicle") : null;
                    if (keyVehicleUUID == null) {
                        if (vehicle.ownerUUID != null && ownerState.equals((Object)AEntityE_Interactable.PlayerOwnerState.USER)) {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_NOTOWNER, new Object[0]));
                        } else {
                            keyVehicleUUID = vehicle.uniqueUUID;
                            data = InterfaceManager.coreInterface.getNewNBTWrapper();
                            data.setUUID("vehicle", keyVehicleUUID);
                            stack.setData(data);
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_BIND, new Object[0]));
                        }
                        return IItemEntityInteractable.CallbackType.NONE;
                    }
                    if (!keyVehicleUUID.equals(vehicle.uniqueUUID)) {
                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_WRONGKEY, new Object[0]));
                    } else {
                        if (entity instanceof PartSeat) {
                            return IItemEntityInteractable.CallbackType.SKIP;
                        }
                        if (vehicle.locked) {
                            vehicle.toggleLock();
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_UNLOCK, new Object[0]));
                            if (hitBox.definition != null && hitBox.definition.variableName != null && !entity.isVariableActive(hitBox.definition.variableName) && hitBox.definition.variableName.startsWith("door")) {
                                return IItemEntityInteractable.CallbackType.SKIP;
                            }
                        } else {
                            vehicle.toggleLock();
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_KEY_LOCK, new Object[0]));
                            if (hitBox.definition != null && hitBox.definition.variableName != null && entity.isVariableActive(hitBox.definition.variableName) && !hitBox.definition.variableName.startsWith("door")) {
                                return IItemEntityInteractable.CallbackType.SKIP;
                            }
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case TICKET: {
                if (!entity.world.isClient() && rightClick) {
                    if (entity instanceof PartSeat) {
                        if (player.isSneaking()) {
                            if (entity.rider != null) {
                                entity.removeRider();
                            }
                        } else if (entity.rider == null) {
                            entity.world.loadEntities(new BoundingBox(player.getPosition(), 8.0, 8.0, 8.0), entity);
                        }
                    } else if (entity instanceof APart) {
                        AEntityF_Multipart<?> master = ((APart)((Object)entity)).masterEntity;
                        if (player.isSneaking()) {
                            for (APart otherPart : master.allParts) {
                                if (otherPart.rider == null) continue;
                                otherPart.removeRider();
                            }
                        } else {
                            master.world.loadEntities(new BoundingBox(player.getPosition(), 8.0, 8.0, 8.0), master);
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case FUEL_HOSE: {
                if (!entity.world.isClient() && rightClick) {
                    if (firstPartClicked == null) {
                        if (entity instanceof PartInteractable) {
                            PartInteractable interactable = (PartInteractable)((Object)entity);
                            if (interactable.tank != null) {
                                if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                                    firstPartClicked = interactable;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_FIRSTLINK, new Object[0]));
                                } else {
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_ALREADYLINKED, new Object[0]));
                                }
                            }
                        }
                    } else if (entity instanceof PartInteractable) {
                        PartInteractable interactable = (PartInteractable)((Object)entity);
                        if (interactable.tank != null && !interactable.equals(firstPartClicked)) {
                            if (interactable.linkedPart == null && interactable.linkedVehicle == null) {
                                if (interactable.position.isDistanceToCloserThan(ItemItem.firstPartClicked.position, 16.0)) {
                                    if (interactable.tank.getFluid().isEmpty() || ItemItem.firstPartClicked.tank.getFluid().isEmpty() || interactable.tank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid())) {
                                        ItemItem.firstPartClicked.linkedPart = interactable;
                                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartInteractable(firstPartClicked, player));
                                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_SECONDLINK, new Object[0]));
                                        firstPartClicked = null;
                                    } else {
                                        firstPartClicked = null;
                                        player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_DIFFERENTFLUIDS, new Object[0]));
                                    }
                                } else {
                                    firstPartClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_TOOFAR, new Object[0]));
                                }
                            } else {
                                firstPartClicked = null;
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_ALREADYLINKED, new Object[0]));
                            }
                        }
                    } else if (entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = entity;
                        if (vehicle.position.isDistanceToCloserThan(ItemItem.firstPartClicked.position, 16.0)) {
                            if (vehicle.fuelTank.getFluid().isEmpty() || ItemItem.firstPartClicked.tank.getFluid().isEmpty() || vehicle.fuelTank.getFluid().equals(ItemItem.firstPartClicked.tank.getFluid())) {
                                ItemItem.firstPartClicked.linkedVehicle = vehicle;
                                InterfaceManager.packetInterface.sendToAllClients(new PacketPartInteractable(firstPartClicked, player));
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_SECONDLINK, new Object[0]));
                                firstPartClicked = null;
                            } else {
                                firstPartClicked = null;
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_DIFFERENTFLUIDS, new Object[0]));
                            }
                        } else {
                            firstPartClicked = null;
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_FUELHOSE_TOOFAR, new Object[0]));
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case JUMPER_CABLES: {
                if (!entity.world.isClient() && rightClick && entity instanceof PartEngine) {
                    PartEngine engine = (PartEngine)((Object)entity);
                    if (engine.vehicleOn != null) {
                        if (engine.linkedEngine == null) {
                            if (firstEngineClicked == null) {
                                firstEngineClicked = engine;
                                player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_FIRSTLINK, new Object[0]));
                            } else if (!firstEngineClicked.equals(engine)) {
                                if (ItemItem.firstEngineClicked.vehicleOn.equals(engine.vehicleOn)) {
                                    firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_SAMEVEHICLE, new Object[0]));
                                } else if (engine.position.isDistanceToCloserThan(ItemItem.firstEngineClicked.position, 15.0)) {
                                    engine.linkedEngine = firstEngineClicked;
                                    ItemItem.firstEngineClicked.linkedEngine = engine;
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(engine, firstEngineClicked));
                                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(firstEngineClicked, engine));
                                    firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_SECONDLINK, new Object[0]));
                                } else {
                                    firstEngineClicked = null;
                                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_TOOFAR, new Object[0]));
                                }
                            }
                        } else {
                            player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_JUMPERCABLE_ALREADYLINKED, new Object[0]));
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case JUMPER_PACK: {
                if (rightClick && entity instanceof EntityVehicleF_Physics) {
                    ((EntityVehicleF_Physics)entity).electricPower = 12.0;
                    if (!entity.world.isClient()) {
                        InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_JUMPERPACK, new Object[0]), player);
                        if (!player.isCreative()) {
                            player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                        }
                        return IItemEntityInteractable.CallbackType.ALL;
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
            case REPAIR_PACK: {
                if (rightClick && !entity.world.isClient()) {
                    if (entity instanceof APart) {
                        entity = ((APart)((Object)entity)).vehicleOn;
                    }
                    if (entity instanceof EntityVehicleF_Physics) {
                        EntityVehicleF_Physics vehicle = entity;
                        if (vehicle.repairCooldownTicks == 0) {
                            if (!vehicle.outOfHealth || ((JSONItem)this.definition).repair.canRepairTotaled) {
                                if (entity.damageAmount == 0.0) {
                                    InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_NONEED, new Object[0]), player);
                                    return IItemEntityInteractable.CallbackType.NONE;
                                }
                                double amountRepaired = ((JSONItem)this.definition).repair.amount;
                                if (vehicle.damageAmount < amountRepaired) {
                                    amountRepaired = vehicle.damageAmount;
                                }
                                double newDamage = vehicle.damageAmount - amountRepaired;
                                vehicle.setVariable("damage", newDamage);
                                vehicle.repairCooldownTicks = 200;
                                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(vehicle, "damage", newDamage));
                                InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_PASS, amountRepaired, (double)((AJSONInteractableEntity)entity.definition).general.health - newDamage, ((AJSONInteractableEntity)entity.definition).general.health), player);
                                if (!player.isCreative()) {
                                    player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                                }
                            } else {
                                InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_TOTALED, new Object[0]), player);
                            }
                        } else {
                            InterfaceManager.packetInterface.sendToPlayer(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_REPAIR_TOOSOON, new Object[0]), player);
                        }
                    }
                }
                return IItemEntityInteractable.CallbackType.NONE;
            }
        }
        return IItemEntityInteractable.CallbackType.SKIP;
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (((JSONItem)this.definition).item.type == JSONItem.ItemComponentType.PAINT_GUN && !world.isClient()) {
            Object tile = world.getTileEntity(position);
            if (tile instanceof TileEntityDecor) {
                player.sendPacket(new PacketEntityGUIRequest((AEntityB_Existing)tile, player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                return true;
            }
            if (tile instanceof TileEntityPole) {
                TileEntityPole pole = (TileEntityPole)tile;
                axis = ABlockBase.Axis.getFromRotation(player.getYaw(), ((JSONPoleComponent)pole.definition).pole.allowsDiagonals).getOpposite();
                if (pole.components.containsKey((Object)axis)) {
                    player.sendPacket(new PacketEntityGUIRequest(pole.components.get((Object)axis), player, PacketEntityGUIRequest.EntityGUIType.PAINT_GUN));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onUsed(AWrapperWorld world, IWrapperPlayer player) {
        if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.BOOKLET)) {
            if (!world.isClient()) {
                player.sendPacket(new PacketGUIRequest(player, PacketGUIRequest.GUIType.BOOKLET));
            }
        } else if (((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.Y2K_BUTTON) && !world.isClient() && player.isOP()) {
            for (EntityVehicleF_Physics vehicle : world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                vehicle.setVariable("throttle", 0.0);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(vehicle, "throttle", 0.0));
                if (!vehicle.isVariableActive("p_brake")) {
                    vehicle.setVariable("p_brake", 1.0);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(vehicle, "p_brake"));
                }
                vehicle.engines.forEach(engine -> {
                    if (engine.isVariableActive("engine_magneto")) {
                        engine.setVariable("engine_magneto", 0.0);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle((AEntityD_Definable<?>)engine, "engine_magneto"));
                    }
                });
            }
        }
        return true;
    }

    @Override
    public int getTimeToEat() {
        return ((JSONItem)this.definition).item.type.equals((Object)JSONItem.ItemComponentType.FOOD) ? ((JSONItem)this.definition).food.timeToEat : 0;
    }

    @Override
    public boolean isDrink() {
        return ((JSONItem)this.definition).food.isDrink;
    }

    @Override
    public int getHungerAmount() {
        return ((JSONItem)this.definition).food.hungerAmount;
    }

    @Override
    public float getSaturationAmount() {
        return ((JSONItem)this.definition).food.saturationAmount;
    }

    @Override
    public List<JSONPotionEffect> getEffects() {
        return ((JSONItem)this.definition).food.effects;
    }
}

