/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;

public class GUIHUD
extends AGUIBase {
    private static final int HUD_WIDTH = 400;
    private static final int HUD_HEIGHT = 140;
    private final EntityVehicleF_Physics vehicle;
    private final PartSeat seat;
    private final List<GUIComponentInstrument> instruments = new ArrayList<GUIComponentInstrument>();
    private GUIComponentLabel healthLabel;
    private GUIComponentLabel gunTypeLabel;
    private boolean halfHUDActive;

    public GUIHUD(EntityVehicleF_Physics vehicle, PartSeat seat) {
        this.vehicle = vehicle;
        this.seat = seat;
        this.halfHUDActive = ((JSONVehicle)vehicle.definition).motorized.halfHUDOnly || !((JSONVehicle)vehicle.definition).motorized.fullHUDOnly && (InterfaceManager.clientInterface.inFirstPerson() ? (Boolean)ConfigSystem.client.renderingSettings.fullHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.fullHUD_3P.value == false);
    }

    @Override
    public void setupComponents() {
        if (this.seat.placementDefinition.isController) {
            if (this.halfHUDActive) {
                this.guiTop += this.getHeight() / 2;
            }
            super.setupComponents();
            this.instruments.clear();
            for (int i = 0; i < this.vehicle.instruments.size(); ++i) {
                if (this.vehicle.instruments.get(i) == null || ((JSONInstrumentDefinition)((JSONVehicle)this.vehicle.definition).instruments.get((int)i)).placeOnPanel) continue;
                GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, this.vehicle, i);
                this.instruments.add(instrument);
                this.addComponent(instrument);
            }
            for (APart part : this.vehicle.parts) {
                for (int i = 0; i < part.instruments.size(); ++i) {
                    if (part.instruments.get(i) == null || ((JSONInstrumentDefinition)((JSONPart)part.definition).instruments.get((int)i)).placeOnPanel) continue;
                    GUIComponentInstrument instrument = new GUIComponentInstrument(this.guiLeft, this.guiTop, part, i);
                    this.instruments.add(instrument);
                    this.addComponent(instrument);
                }
            }
            if (this.halfHUDActive) {
                this.guiTop -= this.getHeight() / 2;
            }
        } else {
            super.setupComponents();
        }
        this.healthLabel = new GUIComponentLabel(this.screenWidth, 0, ColorRGB.WHITE, "", RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
        this.addComponent(this.healthLabel);
        this.healthLabel.ignoreGUILightingState = true;
        this.gunTypeLabel = new GUIComponentLabel(this.screenWidth, 8, ColorRGB.WHITE, "", RenderText.TextAlignment.RIGHT_ALIGNED, 1.0f);
        this.addComponent(this.gunTypeLabel);
        this.gunTypeLabel.ignoreGUILightingState = true;
    }

    @Override
    public void setStates() {
        if (this.halfHUDActive ^ (((JSONVehicle)this.vehicle.definition).motorized.halfHUDOnly || !((JSONVehicle)this.vehicle.definition).motorized.fullHUDOnly && (InterfaceManager.clientInterface.inFirstPerson() ? (Boolean)ConfigSystem.client.renderingSettings.fullHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.fullHUD_3P.value == false))) {
            this.halfHUDActive = !this.halfHUDActive;
            this.setupComponents();
        }
        super.setStates();
        for (GUIComponentInstrument instrument : this.instruments) {
            instrument.visible = CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceManager.clientInterface.inFirstPerson() ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value) != false;
        }
        this.healthLabel.text = String.format("Health: %.0f/%d", (double)((JSONVehicle)this.vehicle.definition).general.health - this.vehicle.damageAmount, ((JSONVehicle)this.vehicle.definition).general.health);
        this.healthLabel.visible = this.seat.placementDefinition.isController || this.seat.canControlGuns;
        ColorRGB colorRGB = this.healthLabel.color = this.vehicle.outOfHealth ? ColorRGB.RED : ColorRGB.WHITE;
        if (this.seat.canControlGuns && !InterfaceManager.clientInterface.isChatOpen()) {
            this.gunTypeLabel.visible = true;
            this.gunTypeLabel.text = "Active Gun: ";
            this.gunTypeLabel.text = this.seat.activeGunItem != null ? this.gunTypeLabel.text + this.seat.activeGunItem.getItemName() + (((JSONPart)this.seat.activeGunItem.definition).gun.fireSolo ? " [" + (this.seat.gunIndex + 1) + "]" : "") : this.gunTypeLabel.text + "None";
        } else {
            this.gunTypeLabel.visible = false;
        }
    }

    @Override
    protected boolean renderBackground() {
        return CameraSystem.customCameraOverlay == null && this.seat.placementDefinition.isController && (InterfaceManager.clientInterface.inFirstPerson() ? (Boolean)ConfigSystem.client.renderingSettings.renderHUD_1P.value != false && (Boolean)ConfigSystem.client.renderingSettings.transpHUD_1P.value == false : (Boolean)ConfigSystem.client.renderingSettings.renderHUD_3P.value != false && (Boolean)ConfigSystem.client.renderingSettings.transpHUD_3P.value == false);
    }

    @Override
    protected AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.renderTextLit() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    public boolean capturesPlayer() {
        return false;
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.seat.rider != null;
    }

    @Override
    public int getWidth() {
        return 400;
    }

    @Override
    public int getHeight() {
        return 140;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return ((JSONVehicle)this.vehicle.definition).motorized.hudTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.hudTexture : "mts:textures/guis/hud.png";
    }
}

