/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import java.nio.FloatBuffer;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableObject;

public abstract class GUIComponentButton
extends GUIComponentCutout {
    private static final int DEFAULT_BUTTON_SECTION_WIDTH = 100;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT = 20;
    private static final int DEFAULT_BUTTON_SECTION_BORDER = 6;
    private static final int DEFAULT_BUTTON_SECTION_WIDTH_OFFSET = 0;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT_OFFSET = 196;
    public static final int ITEM_BUTTON_SIZE = 18;
    public final boolean centeredText;
    public boolean enabled = true;
    public boolean isDynamicTexture;
    public final ColorRGB textColor;
    protected RenderableObject renderable2;
    protected RenderableObject renderable2L;
    protected RenderableObject renderable3;
    protected RenderableObject renderable3L;

    public GUIComponentButton(int x, int y, int width, int height, String text) {
        this(x, y, width, height, text, true, ColorRGB.DARK_GRAY, 0, 196, 100, 20);
    }

    public GUIComponentButton(int x, int y, boolean renderBackground) {
        this(x, y, 18, 18, renderBackground ? 194 : 0, 0, renderBackground ? 18 : 0, renderBackground ? 18 : 0);
    }

    public GUIComponentButton(int x, int y, int width, int height) {
        this(x, y, width, height, "", true, ColorRGB.DARK_GRAY, 0, 0, 0, 0);
    }

    public GUIComponentButton(int x, int y, int width, int height, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        this(x, y, width, height, "", true, ColorRGB.DARK_GRAY, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
    }

    public GUIComponentButton(int x, int y, int width, int height, String text, boolean centeredText, ColorRGB textColor, boolean renderBackground) {
        this(x, y, width, height, text, centeredText, textColor, 0, 196, renderBackground ? 100 : 0, renderBackground ? 20 : 0);
    }

    private GUIComponentButton(int x, int y, int width, int height, String text, boolean centeredText, ColorRGB textColor, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(x, y, width, height, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
        this.textPosition.set(centeredText ? this.position.x + (double)(width / 2) : this.position.x, this.position.y - (double)((height - 8) / 2), this.textPosition.z);
        this.text = text;
        this.centeredText = centeredText;
        this.textColor = textColor;
    }

    public boolean canClick(int mouseX, int mouseY) {
        return this.visible && this.enabled && this.isMouseInBounds(mouseX, mouseY);
    }

    public abstract void onClicked(boolean var1);

    public void onReleased() {
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (this.textureSectionWidth != 0 && this.textureSectionHeight != 0) {
            RenderableObject currentRenderable;
            if (this.renderable == null) {
                for (int i = 0; i < (this.isDynamicTexture ? 1 : 3); ++i) {
                    int textureUStart = this.textureYOffset + i * this.textureSectionHeight;
                    FloatBuffer buffer = this.generateOffsetBuffer(gui, textureUStart);
                    if (i == 0) {
                        this.renderable = new RenderableObject("gui_button_disabled", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                        this.renderableL = new RenderableObject("gui_button_disabled", gui.getTexture().replace(".png", "_lit.png"), ColorRGB.WHITE, buffer, false);
                        continue;
                    }
                    if (i == 1) {
                        this.renderable2 = new RenderableObject("gui_button_normal", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                        this.renderable2L = new RenderableObject("gui_button_normal", gui.getTexture().replace(".png", "_lit.png"), ColorRGB.WHITE, buffer, false);
                        continue;
                    }
                    this.renderable3 = new RenderableObject("gui_button_highlight", gui.getTexture(), ColorRGB.WHITE, buffer, false);
                    this.renderable3L = new RenderableObject("gui_button_highlight", gui.getTexture().replace(".png", "_lit.png"), ColorRGB.WHITE, buffer, false);
                }
            }
            if (this.enabled && !this.isDynamicTexture) {
                currentRenderable = this.isMouseInBounds(mouseX, mouseY) ? (renderLitTexture ? this.renderable3L : this.renderable3) : (renderLitTexture ? this.renderable2L : this.renderable2);
            } else {
                RenderableObject renderableObject = currentRenderable = renderLitTexture ? this.renderableL : this.renderable;
                if (this.isDynamicTexture) {
                    currentRenderable.vertices = this.generateOffsetBuffer(gui, this.textureYOffset);
                }
            }
            if (currentRenderable.isTranslucent == blendingEnabled) {
                currentRenderable.ignoreWorldShading = true;
                currentRenderable.worldLightValue = gui.worldLightValue;
                currentRenderable.disableLighting = renderBright || this.ignoreGUILightingState;
                currentRenderable.transform.setTranslation(this.position);
                currentRenderable.render(null);
            }
        }
    }

    @Override
    public void renderText(boolean renderTextLit, int worldLightValue) {
        RenderText.drawText(this.text, null, this.textPosition, this.textColor, this.centeredText ? RenderText.TextAlignment.CENTERED : RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, 0, renderTextLit || this.ignoreGUILightingState, worldLightValue);
    }

    private FloatBuffer generateOffsetBuffer(AGUIBase gui, int textureUStart) {
        FloatBuffer buffer = FloatBuffer.allocate(144);
        gui.addRenderToBuffer(buffer, 0, 0, 6, this.height, this.textureXOffset, textureUStart, this.textureXOffset + 6, textureUStart + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
        gui.addRenderToBuffer(buffer, 6, 0, this.width - 12, this.height, this.textureXOffset + 6, textureUStart, this.textureXOffset + this.textureSectionWidth - 6, textureUStart + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
        gui.addRenderToBuffer(buffer, this.width - 6, 0, 6, this.height, this.textureXOffset + this.textureSectionWidth - 6, textureUStart, this.textureXOffset + this.textureSectionWidth, textureUStart + this.textureSectionHeight, gui.getTextureWidth(), gui.getTextureHeight());
        buffer.flip();
        return buffer;
    }
}

