/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityPole_Component;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityPole_TrafficSignal;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;

public class TileEntitySignalController
extends TileEntityDecor {
    private static final TransformationMatrix holoboxTransform = new TransformationMatrix();
    public boolean isRightHandDrive;
    public boolean timedMode;
    public boolean unsavedClientChangesPreset;
    public ABlockBase.Axis mainDirectionAxis = ABlockBase.Axis.NORTH;
    public Point3D intersectionCenterPoint;
    public int greenMainTime = 400;
    public int greenCrossTime = 200;
    public int yellowMainTime = 40;
    public int yellowCrossTime = 40;
    public int allRedTime = 20;
    public final Set<Point3D> componentLocations = new HashSet<Point3D>();
    private final Set<Point3D> missingLocations = new HashSet<Point3D>();
    public final Map<ABlockBase.Axis, Set<SignalGroup>> signalGroups = new HashMap<ABlockBase.Axis, Set<SignalGroup>>();
    public final Set<TileEntityPole_TrafficSignal> controlledSignals = new HashSet<TileEntityPole_TrafficSignal>();
    public final Map<ABlockBase.Axis, IntersectionProperties> intersectionProperties = new HashMap<ABlockBase.Axis, IntersectionProperties>();

    public TileEntitySignalController(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.initializeController(data);
    }

    @Override
    public void update() {
        super.update();
        if ((this.ticksExisted % 20L == 0L || this.unsavedClientChangesPreset) && !this.missingLocations.isEmpty()) {
            Iterator<Point3D> iterator = this.missingLocations.iterator();
            while (iterator.hasNext()) {
                Point3D poleLocation = iterator.next();
                TileEntityPole pole = (TileEntityPole)this.world.getTileEntity(poleLocation);
                if (pole == null) continue;
                iterator.remove();
                for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
                    ATileEntityPole_Component component;
                    if (!axis.xzPlanar || !((component = pole.components.get((Object)axis)) instanceof TileEntityPole_TrafficSignal)) continue;
                    TileEntityPole_TrafficSignal signal = (TileEntityPole_TrafficSignal)component;
                    this.intersectionProperties.get((Object)((Object)axis)).isActive = true;
                    signal.linkedController = this;
                    this.controlledSignals.add(signal);
                }
            }
        }
        for (Set<SignalGroup> signalGroupSet : this.signalGroups.values()) {
            for (SignalGroup signalGroup : signalGroupSet) {
                if (signalGroup.laneCount == 0) continue;
                signalGroup.update();
            }
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.clearFoundPoles();
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.SIGNAL_CONTROLLER));
        return true;
    }

    public void initializeController(IWrapperNBT data) {
        if (data == null) {
            data = this.save(InterfaceManager.coreInterface.getNewNBTWrapper());
        }
        this.isRightHandDrive = data.getBoolean("isRightHandDrive");
        this.timedMode = data.getBoolean("timedMode");
        String axisName = data.getString("mainDirectionAxis");
        this.mainDirectionAxis = axisName.isEmpty() ? ABlockBase.Axis.NORTH : ABlockBase.Axis.valueOf(axisName);
        this.intersectionCenterPoint = data.getPoint3d("intersectionCenterPoint");
        if (this.intersectionCenterPoint.isZero()) {
            this.intersectionCenterPoint.set(this.position);
        }
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (!axis.xzPlanar) continue;
            this.intersectionProperties.put(axis, new IntersectionProperties(data.getData(axis.name() + "properties")));
        }
        if (data.getBoolean("hasCustomTimes")) {
            this.greenMainTime = data.getInteger("greenMainTime");
            this.greenCrossTime = data.getInteger("greenCrossTime");
            this.yellowMainTime = data.getInteger("yellowMainTime");
            this.yellowCrossTime = data.getInteger("yellowCrossTime");
            this.allRedTime = data.getInteger("allRedTime");
        }
        this.componentLocations.clear();
        this.componentLocations.addAll(data.getPoint3dsCompact("componentLocations"));
        this.signalGroups.clear();
        for (ABlockBase.Axis axis : ABlockBase.Axis.values()) {
            if (!axis.xzPlanar) continue;
            HashSet<SignalGroup> signalSet = new HashSet<SignalGroup>();
            signalSet.add(new SignalGroupCenter(axis, data.getData(axis.name() + SignalDirection.CENTER.name())));
            signalSet.add(new SignalGroupLeft(axis, data.getData(axis.name() + SignalDirection.LEFT.name())));
            signalSet.add(new SignalGroupRight(axis, data.getData(axis.name() + SignalDirection.RIGHT.name())));
            this.signalGroups.put(axis, signalSet);
        }
        for (Set set : this.signalGroups.values()) {
            for (SignalGroup signalGroup : set) {
                signalGroup.requestedLight = signalGroup.isMainSignal && signalGroup.direction.equals((Object)SignalDirection.CENTER) ? signalGroup.getGreenLight() : signalGroup.getRedLight();
                if (signalGroup.requestedLight.equals((Object)signalGroup.currentLight)) {
                    signalGroup.requestedLight = null;
                }
                signalGroup.currentCooldown = 0;
            }
        }
        this.clearFoundPoles();
    }

    public void clearFoundPoles() {
        this.controlledSignals.clear();
        this.missingLocations.clear();
        this.missingLocations.addAll(this.componentLocations);
    }

    @Override
    protected void renderHolographicBoxes(TransformationMatrix transform) {
        if (this.unsavedClientChangesPreset || InterfaceManager.renderingInterface.shouldRenderBoundingBoxes()) {
            for (Set<SignalGroup> signalGroupSet : this.signalGroups.values()) {
                for (SignalGroup signalGroup : signalGroupSet) {
                    if (signalGroup.signalLineWidth == 0.0 || !this.intersectionProperties.get((Object)((Object)signalGroup.axis)).isActive) continue;
                    Point3D boxRelativeCenter = signalGroup.signalLineCenter.copy();
                    boxRelativeCenter.add(0.0, 0.0, 8.0);
                    boxRelativeCenter.rotate(signalGroup.axis.yRotation);
                    boxRelativeCenter.add(this.intersectionCenterPoint).subtract(this.position);
                    boxRelativeCenter.y += 1.0;
                    BoundingBox box = new BoundingBox(boxRelativeCenter, signalGroup.signalLineWidth / 2.0, 1.0, 8.0);
                    holoboxTransform.set(transform).applyTranslation(boxRelativeCenter).applyRotation(signalGroup.axis.yRotation);
                    box.renderHolographic(holoboxTransform, null, signalGroup.direction.equals((Object)SignalDirection.LEFT) ? ColorRGB.BLUE : (signalGroup.direction.equals((Object)SignalDirection.RIGHT) ? ColorRGB.YELLOW : ColorRGB.GREEN));
                }
            }
        }
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("isRightHandDrive", this.isRightHandDrive);
        data.setBoolean("timedMode", this.timedMode);
        data.setString("mainDirectionAxis", this.mainDirectionAxis.name());
        if (this.intersectionCenterPoint != null) {
            data.setPoint3d("intersectionCenterPoint", this.intersectionCenterPoint);
        }
        for (ABlockBase.Axis axis : this.intersectionProperties.keySet()) {
            if (!this.intersectionProperties.containsKey((Object)axis)) continue;
            data.setData(axis.name() + "properties", this.intersectionProperties.get((Object)axis).getData());
        }
        data.setBoolean("hasCustomTimes", true);
        data.setInteger("greenMainTime", this.greenMainTime);
        data.setInteger("greenCrossTime", this.greenCrossTime);
        data.setInteger("yellowMainTime", this.yellowMainTime);
        data.setInteger("yellowCrossTime", this.yellowCrossTime);
        data.setInteger("allRedTime", this.allRedTime);
        data.setPoint3dsCompact("componentLocations", this.componentLocations);
        for (Set set : this.signalGroups.values()) {
            for (SignalGroup signalGroup : set) {
                data.setData(signalGroup.axis.name() + signalGroup.direction.name(), signalGroup.getData());
            }
        }
        return data;
    }

    public static enum SignalDirection {
        CENTER,
        LEFT,
        RIGHT;

    }

    public static enum LightType {
        STOP_LIGHT,
        CAUTION_LIGHT,
        GO_LIGHT,
        STOP_LIGHT_LEFT,
        CAUTION_LIGHT_LEFT,
        GO_LIGHT_LEFT,
        STOP_LIGHT_RIGHT,
        CAUTION_LIGHT_RIGHT,
        GO_LIGHT_RIGHT;

        public final String lowercaseName = this.name().toLowerCase(Locale.ROOT);
    }

    private class SignalGroupRight
    extends SignalGroup {
        private SignalGroupRight(ABlockBase.Axis axis, IWrapperNBT data) {
            super(axis, SignalDirection.RIGHT, data);
            this.requestedLight = LightType.STOP_LIGHT_RIGHT;
        }

        @Override
        protected LightType getNextLight() {
            switch (this.currentLight) {
                case GO_LIGHT_RIGHT: {
                    return LightType.CAUTION_LIGHT_RIGHT;
                }
                case CAUTION_LIGHT_RIGHT: {
                    return LightType.STOP_LIGHT_RIGHT;
                }
                case STOP_LIGHT_RIGHT: {
                    return LightType.GO_LIGHT_RIGHT;
                }
            }
            return null;
        }

        @Override
        protected LightType getRedLight() {
            return LightType.STOP_LIGHT_RIGHT;
        }

        @Override
        protected LightType getGreenLight() {
            return LightType.GO_LIGHT_RIGHT;
        }

        @Override
        protected int getSignalCooldown() {
            switch (this.currentLight) {
                case GO_LIGHT_RIGHT: {
                    return (this.isMainSignal ? TileEntitySignalController.this.greenMainTime : TileEntitySignalController.this.greenCrossTime) / 4;
                }
                case CAUTION_LIGHT_RIGHT: {
                    return (this.isMainSignal ? TileEntitySignalController.this.yellowMainTime : TileEntitySignalController.this.yellowCrossTime) / 4;
                }
                case STOP_LIGHT_RIGHT: {
                    return TileEntitySignalController.this.allRedTime;
                }
            }
            return 0;
        }

        @Override
        protected boolean isSignalBlocking(SignalGroup otherSignal) {
            switch (ABlockBase.Axis.getFromRotation(otherSignal.axis.yRotation.angles.y - this.axis.yRotation.angles.y, true)) {
                case SOUTH: {
                    return false;
                }
                case EAST: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return true;
                        }
                        case LEFT: {
                            return false;
                        }
                        case RIGHT: {
                            return TileEntitySignalController.this.isRightHandDrive;
                        }
                    }
                }
                case NORTH: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return TileEntitySignalController.this.isRightHandDrive;
                        }
                        case LEFT: {
                            return true;
                        }
                        case RIGHT: {
                            return false;
                        }
                    }
                }
                case WEST: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return true;
                        }
                        case LEFT: {
                            return false;
                        }
                        case RIGHT: {
                            return TileEntitySignalController.this.isRightHandDrive;
                        }
                    }
                }
            }
            return true;
        }
    }

    private class SignalGroupLeft
    extends SignalGroup {
        private SignalGroupLeft(ABlockBase.Axis axis, IWrapperNBT data) {
            super(axis, SignalDirection.LEFT, data);
            this.requestedLight = LightType.STOP_LIGHT_LEFT;
        }

        @Override
        protected LightType getNextLight() {
            switch (this.currentLight) {
                case GO_LIGHT_LEFT: {
                    return LightType.CAUTION_LIGHT_LEFT;
                }
                case CAUTION_LIGHT_LEFT: {
                    return LightType.STOP_LIGHT_LEFT;
                }
                case STOP_LIGHT_LEFT: {
                    return LightType.GO_LIGHT_LEFT;
                }
            }
            return null;
        }

        @Override
        protected LightType getRedLight() {
            return LightType.STOP_LIGHT_LEFT;
        }

        @Override
        protected LightType getGreenLight() {
            return LightType.GO_LIGHT_LEFT;
        }

        @Override
        protected int getSignalCooldown() {
            switch (this.currentLight) {
                case GO_LIGHT_LEFT: {
                    return (this.isMainSignal ? TileEntitySignalController.this.greenMainTime : TileEntitySignalController.this.greenCrossTime) / 4;
                }
                case CAUTION_LIGHT_LEFT: {
                    return (this.isMainSignal ? TileEntitySignalController.this.yellowMainTime : TileEntitySignalController.this.yellowCrossTime) / 4;
                }
                case STOP_LIGHT_LEFT: {
                    return TileEntitySignalController.this.allRedTime;
                }
            }
            return 0;
        }

        @Override
        protected boolean isSignalBlocking(SignalGroup otherSignal) {
            switch (ABlockBase.Axis.getFromRotation(otherSignal.axis.yRotation.angles.y - this.axis.yRotation.angles.y, true)) {
                case SOUTH: {
                    return false;
                }
                case EAST: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return true;
                        }
                        case LEFT: {
                            return !TileEntitySignalController.this.isRightHandDrive;
                        }
                        case RIGHT: {
                            return false;
                        }
                    }
                }
                case NORTH: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return !TileEntitySignalController.this.isRightHandDrive;
                        }
                        case LEFT: {
                            return false;
                        }
                        case RIGHT: {
                            return true;
                        }
                    }
                }
                case WEST: {
                    switch (otherSignal.direction) {
                        case CENTER: 
                        case LEFT: {
                            return !TileEntitySignalController.this.isRightHandDrive;
                        }
                        case RIGHT: {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
    }

    private class SignalGroupCenter
    extends SignalGroup {
        private SignalGroupCenter(ABlockBase.Axis axis, IWrapperNBT data) {
            super(axis, SignalDirection.CENTER, data);
            this.requestedLight = LightType.STOP_LIGHT;
        }

        @Override
        protected LightType getNextLight() {
            switch (this.currentLight) {
                case GO_LIGHT: {
                    return LightType.CAUTION_LIGHT;
                }
                case CAUTION_LIGHT: {
                    return LightType.STOP_LIGHT;
                }
                case STOP_LIGHT: {
                    return LightType.GO_LIGHT;
                }
            }
            return null;
        }

        @Override
        protected LightType getRedLight() {
            return LightType.STOP_LIGHT;
        }

        @Override
        protected LightType getGreenLight() {
            return LightType.GO_LIGHT;
        }

        @Override
        protected int getSignalCooldown() {
            switch (this.currentLight) {
                case GO_LIGHT: {
                    return this.isMainSignal ? TileEntitySignalController.this.greenMainTime : TileEntitySignalController.this.greenCrossTime;
                }
                case CAUTION_LIGHT: {
                    return this.isMainSignal ? TileEntitySignalController.this.yellowMainTime : TileEntitySignalController.this.yellowCrossTime;
                }
                case STOP_LIGHT: {
                    return TileEntitySignalController.this.allRedTime;
                }
            }
            return 0;
        }

        @Override
        protected boolean isSignalBlocking(SignalGroup otherSignal) {
            switch (ABlockBase.Axis.getFromRotation(otherSignal.axis.yRotation.angles.y - this.axis.yRotation.angles.y, true)) {
                case SOUTH: {
                    return false;
                }
                case EAST: {
                    switch (otherSignal.direction) {
                        case CENTER: 
                        case RIGHT: {
                            return true;
                        }
                        case LEFT: {
                            return !TileEntitySignalController.this.isRightHandDrive;
                        }
                    }
                }
                case NORTH: {
                    switch (otherSignal.direction) {
                        case CENTER: {
                            return false;
                        }
                        case LEFT: {
                            return !TileEntitySignalController.this.isRightHandDrive;
                        }
                        case RIGHT: {
                            return TileEntitySignalController.this.isRightHandDrive;
                        }
                    }
                }
                case WEST: {
                    switch (otherSignal.direction) {
                        case CENTER: 
                        case LEFT: {
                            return true;
                        }
                        case RIGHT: {
                            return TileEntitySignalController.this.isRightHandDrive;
                        }
                    }
                }
            }
            return true;
        }
    }

    public abstract class SignalGroup {
        public final ABlockBase.Axis axis;
        public final SignalDirection direction;
        public final boolean isMainSignal;
        public boolean isActive;
        protected LightType currentLight;
        protected LightType requestedLight;
        protected int currentCooldown;
        protected boolean stateChangeRequested;
        public final int laneCount;
        public final double signalLineWidth;
        public final Point3D signalLineCenter;

        private SignalGroup(ABlockBase.Axis axis, SignalDirection direction, IWrapperNBT data) {
            this.axis = axis;
            this.direction = direction;
            boolean bl = this.isMainSignal = axis.equals((Object)TileEntitySignalController.this.mainDirectionAxis) || axis.equals((Object)TileEntitySignalController.this.mainDirectionAxis.getOpposite());
            if (data != null) {
                String currentLightName = data.getString("currentLight");
                this.currentLight = !currentLightName.isEmpty() ? LightType.valueOf(currentLightName) : this.getRedLight();
                String requestedLightName = data.getString("requestedLight");
                if (!requestedLightName.isEmpty()) {
                    this.requestedLight = LightType.valueOf(requestedLightName);
                }
                this.currentCooldown = data.getInteger("currentCooldown");
            } else {
                this.currentLight = this.getRedLight();
            }
            IntersectionProperties properties = TileEntitySignalController.this.intersectionProperties.get((Object)axis);
            int totalLaneCount = properties.leftLaneCount + properties.centerLaneCount + properties.rightLaneCount;
            double laneWidth = totalLaneCount != 0 ? properties.roadWidth / (double)totalLaneCount : 0.0;
            switch (direction) {
                case CENTER: {
                    this.laneCount = properties.centerLaneCount;
                    this.signalLineWidth = (double)properties.centerLaneCount * laneWidth;
                    this.signalLineCenter = new Point3D(properties.centerOffset + ((double)properties.leftLaneCount + (double)properties.centerLaneCount / 2.0) * laneWidth, 0.0, properties.centerDistance);
                    break;
                }
                case LEFT: {
                    this.laneCount = properties.leftLaneCount;
                    this.signalLineWidth = (double)properties.leftLaneCount * laneWidth;
                    this.signalLineCenter = new Point3D(properties.centerOffset + (double)properties.leftLaneCount / 2.0 * laneWidth, 0.0, properties.centerDistance);
                    break;
                }
                case RIGHT: {
                    this.laneCount = properties.rightLaneCount;
                    this.signalLineWidth = (double)properties.rightLaneCount * laneWidth;
                    this.signalLineCenter = new Point3D(properties.centerOffset + ((double)(properties.leftLaneCount + properties.centerLaneCount) + (double)properties.rightLaneCount / 2.0) * laneWidth, 0.0, properties.centerDistance);
                    break;
                }
                default: {
                    throw new IllegalStateException("We'll never get here, shut up compiler!");
                }
            }
        }

        protected void update() {
            block12: {
                block13: {
                    block11: {
                        if (this.currentCooldown > 0) {
                            --this.currentCooldown;
                        }
                        if (this.requestedLight == null) break block11;
                        if (this.currentCooldown != 0) break block12;
                        this.currentLight = this.getNextLight();
                        if (this.currentLight.equals((Object)this.requestedLight)) {
                            this.requestedLight = null;
                            this.currentCooldown = this.currentLight.equals((Object)this.getRedLight()) ? TileEntitySignalController.this.allRedTime + 20 : 0;
                        } else {
                            this.currentCooldown = this.getSignalCooldown();
                        }
                        break block12;
                    }
                    if (this.stateChangeRequested || this.requestedLight != null || this.currentCooldown != 0 || this.currentLight.equals((Object)this.getGreenLight())) break block12;
                    if (!TileEntitySignalController.this.timedMode) break block13;
                    if (!this.direction.equals((Object)SignalDirection.CENTER)) break block12;
                    this.stateChangeRequested = true;
                    break block12;
                }
                if (TileEntitySignalController.this.ticksExisted % 40L == 0L) {
                    if (this.isMainSignal && this.direction.equals((Object)SignalDirection.CENTER)) {
                        this.stateChangeRequested = true;
                    } else {
                        for (EntityVehicleF_Physics vehicle : TileEntitySignalController.this.world.getEntitiesOfType(EntityVehicleF_Physics.class)) {
                            Point3D adjustedPos = vehicle.position.copy().subtract(TileEntitySignalController.this.intersectionCenterPoint).reOrigin(this.axis.yRotation);
                            if (!(adjustedPos.x > this.signalLineCenter.x - this.signalLineWidth / 2.0) || !(adjustedPos.x < this.signalLineCenter.x + this.signalLineWidth / 2.0) || !(adjustedPos.z > this.signalLineCenter.z) || !(adjustedPos.z < this.signalLineCenter.z + 16.0)) continue;
                            this.stateChangeRequested = true;
                            break;
                        }
                    }
                }
            }
            if (this.stateChangeRequested) {
                boolean foundBlockingSignal = false;
                for (Set<SignalGroup> signalGroupSet : TileEntitySignalController.this.signalGroups.values()) {
                    for (SignalGroup otherSignal : signalGroupSet) {
                        if (otherSignal.currentLight.equals((Object)otherSignal.getRedLight()) || !this.isSignalBlocking(otherSignal)) continue;
                        foundBlockingSignal = true;
                        if (otherSignal.requestedLight != null || otherSignal.currentCooldown != 0) continue;
                        otherSignal.requestedLight = otherSignal.getRedLight();
                        otherSignal.currentCooldown = otherSignal.getSignalCooldown();
                    }
                }
                if (!foundBlockingSignal) {
                    this.requestedLight = this.getGreenLight();
                    this.currentCooldown = this.getSignalCooldown();
                    this.stateChangeRequested = false;
                }
            }
        }

        protected abstract LightType getNextLight();

        protected abstract LightType getRedLight();

        protected abstract LightType getGreenLight();

        protected abstract int getSignalCooldown();

        protected abstract boolean isSignalBlocking(SignalGroup var1);

        protected IWrapperNBT getData() {
            IWrapperNBT data = InterfaceManager.coreInterface.getNewNBTWrapper();
            data.setString("currentLight", this.currentLight.name());
            if (this.requestedLight != null) {
                data.setString("requestedLight", this.requestedLight.name());
            }
            data.setInteger("currentCooldown", this.currentCooldown);
            return data;
        }
    }

    public static class IntersectionProperties {
        public boolean isActive;
        public int centerLaneCount;
        public int leftLaneCount;
        public int rightLaneCount;
        public double roadWidth;
        public double centerDistance;
        public double centerOffset;

        public IntersectionProperties(IWrapperNBT data) {
            if (data != null) {
                this.centerLaneCount = data.getInteger("centerLaneCount");
                this.leftLaneCount = data.getInteger("leftLaneCount");
                this.rightLaneCount = data.getInteger("rightLaneCount");
                this.roadWidth = data.getDouble("roadWidth");
                this.centerDistance = data.getDouble("centerDistance");
                this.centerOffset = data.getDouble("centerOffset");
            }
        }

        public IWrapperNBT getData() {
            IWrapperNBT data = InterfaceManager.coreInterface.getNewNBTWrapper();
            data.setInteger("centerLaneCount", this.centerLaneCount);
            data.setInteger("leftLaneCount", this.leftLaneCount);
            data.setInteger("rightLaneCount", this.rightLaneCount);
            data.setDouble("roadWidth", this.roadWidth);
            data.setDouble("centerDistance", this.centerDistance);
            data.setDouble("centerOffset", this.centerOffset);
            return data;
        }
    }
}

