/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.jsondefs.JSONVariableModifier;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;

public class TileEntityDecor
extends ATileEntityBase<JSONDecor> {
    public static final String CLICKED_VARIABLE = "clicked";
    public static final String ACTIVATED_VARIABLE = "activated";
    private float lightLevel;

    public TileEntityDecor(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        if (world.isBlockBelowBottomSlab(position)) {
            this.position.y -= 0.5;
            this.boundingBox.globalCenter.set(this.position);
        }
        this.boundingBox.heightRadius = (double)((JSONDecor)this.definition).decor.height / 2.0;
        this.boundingBox.globalCenter.y += this.boundingBox.heightRadius;
        if (Math.abs(new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)this.orientation).z) == 1.0) {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
        } else {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
        }
    }

    @Override
    public void update() {
        this.updateVariableModifiers();
        super.update();
        this.setVariable(CLICKED_VARIABLE, 0.0);
    }

    @Override
    public boolean updateRider() {
        if (super.updateRider()) {
            this.position.y += (double)((JSONDecor)this.definition).decor.sittingOffset;
            this.rider.setPosition(this.position, false);
            this.position.y -= (double)((JSONDecor)this.definition).decor.sittingOffset;
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (player.isHoldingItemType(JSONItem.ItemComponentType.PAINT_GUN)) {
            return false;
        }
        if (((JSONDecor)this.definition).decor.crafting != null) {
            player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.PART_BENCH));
        } else if (!this.text.isEmpty()) {
            if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH) && player.isSneaking()) {
                player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
            } else {
                this.setVariable(CLICKED_VARIABLE, 1.0);
                this.toggleVariable(ACTIVATED_VARIABLE);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, CLICKED_VARIABLE, 1.0));
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, ACTIVATED_VARIABLE));
            }
        } else if (((JSONDecor)this.definition).decor.type == JSONDecor.DecorComponentType.SEAT) {
            this.setRider(player, true);
        } else {
            this.setVariable(CLICKED_VARIABLE, 1.0);
            this.toggleVariable(ACTIVATED_VARIABLE);
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableSet(this, CLICKED_VARIABLE, 1.0));
            InterfaceManager.packetInterface.sendToAllClients(new PacketEntityVariableToggle(this, ACTIVATED_VARIABLE));
        }
        return true;
    }

    @Override
    public int getRotationIncrement() {
        return 90;
    }

    @Override
    public float getLightProvided() {
        return this.lightLevel;
    }

    @Override
    protected void updateVariableModifiers() {
        this.lightLevel = ((JSONDecor)this.definition).decor.lightLevel;
        if (((JSONDecor)this.definition).variableModifiers != null) {
            block6: for (JSONVariableModifier modifier : ((JSONDecor)this.definition).variableModifiers) {
                switch (modifier.variable) {
                    case "lightLevel": {
                        this.lightLevel = this.adjustVariable(modifier, this.lightLevel);
                        continue block6;
                    }
                }
                this.setVariable(modifier.variable, this.adjustVariable(modifier, (float)this.getVariable(modifier.variable)));
            }
        }
    }
}

