/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1122;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.guis.instances.GUIConfig;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.mcinterface.IInterfaceInput;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPackImport;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class InterfaceInput
implements IInterfaceInput {
    private static KeyBinding configKey;
    private static KeyBinding importKey;
    private static boolean betterCombatDetected;
    private static boolean leftMouseButtonDown;
    private static boolean rightMouseButtonDown;
    private static boolean runningJoystickThread;
    private static boolean runningClassicMode;
    private static boolean joystickLoadingAttempted;
    private static boolean joystickEnabled;
    private static boolean joystickBlocked;
    private static boolean joystickInhibited;
    private static final Map<String, Integer> joystickNameCounters;
    private static final Map<String, Controller> joystickMap;
    private static final Map<String, Integer> joystickAxisCountMap;
    private static final Map<String, net.java.games.input.Controller> classicJoystickMap;

    @Override
    public int getKeysetID() {
        return 12;
    }

    @Override
    public void initConfigKey() {
        configKey = new KeyBinding(LanguageSystem.GUI_MASTERCONFIG.getCurrentValue(), 25, "Immersive Vehicles (MTS)");
        ClientRegistry.registerKeyBinding((KeyBinding)configKey);
        importKey = new KeyBinding(LanguageSystem.GUI_IMPORT.getCurrentValue(), 0, "Immersive Vehicles (MTS)");
        ClientRegistry.registerKeyBinding((KeyBinding)importKey);
        betterCombatDetected = InterfaceManager.coreInterface.isModPresent("bettercombatmod");
    }

    @Override
    public void initJoysticks() {
        if (!runningJoystickThread) {
            runningJoystickThread = true;
            joystickBlocked = true;
            Thread joystickThread = new Thread(() -> {
                try {
                    joystickNameCounters.clear();
                    if (runningClassicMode) {
                        classicJoystickMap.clear();
                        for (net.java.games.input.Controller joystick : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
                            joystickEnabled = true;
                            if (joystick.getType() == null || joystick.getType().equals(Controller.Type.MOUSE) || joystick.getType().equals(Controller.Type.KEYBOARD) || joystick.getName() == null || joystick.getComponents().length == 0) continue;
                            String joystickName = joystick.getName();
                            if (!joystickNameCounters.containsKey(joystickName)) {
                                joystickNameCounters.put(joystickName, 0);
                            }
                            classicJoystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
                            joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
                        }
                    } else {
                        if (!Controllers.isCreated()) {
                            Controllers.create();
                        }
                        joystickMap.clear();
                        joystickAxisCountMap.clear();
                        for (int i = 0; i < Controllers.getControllerCount(); ++i) {
                            joystickEnabled = true;
                            Controller joystick = Controllers.getController((int)i);
                            if (joystick.getAxisCount() <= 0 || joystick.getButtonCount() <= 0 || joystick.getName() == null) continue;
                            String joystickName = joystick.getName();
                            if (!joystickNameCounters.containsKey(joystickName)) {
                                joystickNameCounters.put(joystickName, 0);
                            }
                            joystickMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick);
                            joystickAxisCountMap.put(joystickName + "_" + joystickNameCounters.get(joystickName), joystick.getAxisCount());
                            joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
                        }
                    }
                    Iterator<Map.Entry<String, JSONConfigClient.ConfigJoystick>> iterator = ConfigSystem.client.controls.joystick.entrySet().iterator();
                    while (iterator.hasNext()) {
                        try {
                            Map.Entry<String, JSONConfigClient.ConfigJoystick> controllerEntry = iterator.next();
                            ControlSystem.ControlsJoystick control = ControlSystem.ControlsJoystick.valueOf(controllerEntry.getKey().toUpperCase(Locale.ROOT));
                            JSONConfigClient.ConfigJoystick config = controllerEntry.getValue();
                            if (runningClassicMode) {
                                if (!classicJoystickMap.containsKey(config.joystickName) || classicJoystickMap.get(config.joystickName).getComponents().length > config.buttonIndex) continue;
                                iterator.remove();
                                InterfaceManager.coreInterface.logError("Removed classic joystick with too low count.  Had " + classicJoystickMap.get(config.joystickName).getComponents().length + " requested " + config.buttonIndex);
                                continue;
                            }
                            if (!joystickMap.containsKey(config.joystickName)) continue;
                            if (control.isAxis) {
                                if (joystickMap.get(config.joystickName).getAxisCount() > config.buttonIndex) continue;
                                iterator.remove();
                                InterfaceManager.coreInterface.logError("Removed joystick with too low axis count.  Had " + joystickMap.get(config.joystickName).getAxisCount() + " requested " + config.buttonIndex);
                                continue;
                            }
                            if (joystickMap.get(config.joystickName).getButtonCount() > config.buttonIndex - joystickAxisCountMap.get(config.joystickName)) continue;
                            iterator.remove();
                            InterfaceManager.coreInterface.logError("Removed joystick with too low button count.  Had " + joystickMap.get(config.joystickName).getButtonCount() + " requested " + (config.buttonIndex - joystickAxisCountMap.get(config.joystickName)));
                        }
                        catch (Exception e) {
                            iterator.remove();
                        }
                    }
                    joystickBlocked = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    InterfaceManager.coreInterface.logError(e.getMessage());
                    for (StackTraceElement s : e.getStackTrace()) {
                        InterfaceManager.coreInterface.logError(s.toString());
                    }
                }
                runningJoystickThread = false;
            });
            joystickThread.start();
        }
    }

    @Override
    public String getNameForKeyCode(int keyCode) {
        return Keyboard.getKeyName((int)keyCode);
    }

    @Override
    public int getKeyCodeForName(String name) {
        return Keyboard.getKeyIndex((String)name);
    }

    @Override
    public boolean isKeyPressed(int keyCode) {
        return Keyboard.isKeyDown((int)keyCode);
    }

    @Override
    public void setGUIControls(boolean enabled) {
        Keyboard.enableRepeatEvents((boolean)enabled);
        if (enabled) {
            leftMouseButtonDown = false;
            rightMouseButtonDown = false;
        }
    }

    @Override
    public boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    @Override
    public boolean isJoystickSupportBlocked() {
        return joystickBlocked;
    }

    @Override
    public boolean isJoystickPresent(String joystickName) {
        return !joystickInhibited && runningClassicMode ? classicJoystickMap.containsKey(joystickName) : joystickMap.containsKey(joystickName);
    }

    @Override
    public List<String> getAllJoystickNames() {
        return new ArrayList<String>(runningClassicMode ? classicJoystickMap.keySet() : joystickMap.keySet());
    }

    @Override
    public int getJoystickComponentCount(String joystickName) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents().length : joystickMap.get(joystickName).getAxisCount() + joystickMap.get(joystickName).getButtonCount();
    }

    @Override
    public String getJoystickComponentName(String joystickName, int index) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents()[index].getName() : (this.isJoystickComponentAxis(joystickName, index) ? joystickMap.get(joystickName).getAxisName(index) : joystickMap.get(joystickName).getButtonName(index - joystickAxisCountMap.get(joystickName)));
    }

    @Override
    public boolean isJoystickComponentAxis(String joystickName, int index) {
        return runningClassicMode ? classicJoystickMap.get(joystickName).getComponents()[index].isAnalog() : joystickMap.get(joystickName).getAxisCount() > index;
    }

    @Override
    public float getJoystickAxisValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData();
            }
            return 0.0f;
        }
        if (joystickMap.containsKey(joystickName)) {
            if (this.isJoystickComponentAxis(joystickName, index)) {
                joystickMap.get(joystickName).poll();
                return joystickMap.get(joystickName).getAxisValue(index);
            }
            return this.getJoystickButtonValue(joystickName, index) ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean getJoystickButtonValue(String joystickName, int index) {
        if (runningClassicMode) {
            if (classicJoystickMap.containsKey(joystickName)) {
                classicJoystickMap.get(joystickName).poll();
                return classicJoystickMap.get(joystickName).getComponents()[index].getPollData() > 0.0f;
            }
            return false;
        }
        if (joystickMap.containsKey(joystickName)) {
            joystickMap.get(joystickName).poll();
            return joystickMap.get(joystickName).isButtonPressed(index - joystickAxisCountMap.get(joystickName));
        }
        return false;
    }

    @Override
    public void inhibitJoysticks(boolean inhibited) {
        joystickInhibited = inhibited;
    }

    @Override
    public int getTrackedMouseWheel() {
        return Mouse.hasWheel() ? Mouse.getDWheel() : 0;
    }

    @Override
    public boolean isLeftMouseButtonDown() {
        return betterCombatDetected ? leftMouseButtonDown : Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d();
    }

    @Override
    public boolean isRightMouseButtonDown() {
        return betterCombatDetected ? rightMouseButtonDown : Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d();
    }

    @SubscribeEvent
    public static void onIVMouseInput(MouseEvent event) {
        if (betterCombatDetected) {
            int button = event.getButton();
            if (button == 0) {
                leftMouseButtonDown = event.isButtonstate();
            } else if (button == 1) {
                rightMouseButtonDown = event.isButtonstate();
            }
        }
    }

    @SubscribeEvent
    public static void onIVKeyInput(InputEvent.KeyInputEvent event) {
        if (runningClassicMode ^ (Boolean)ConfigSystem.client.controlSettings.classicJystk.value) {
            runningClassicMode = (Boolean)ConfigSystem.client.controlSettings.classicJystk.value;
            joystickLoadingAttempted = false;
        }
        if (!joystickLoadingAttempted) {
            InterfaceManager.inputInterface.initJoysticks();
            joystickLoadingAttempted = true;
        }
        if (configKey.func_151468_f() && !InterfaceManager.clientInterface.isGUIOpen()) {
            new GUIConfig();
        } else if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && importKey.func_151468_f()) {
            IWrapperPlayer clientPlayer = InterfaceManager.clientInterface.getClientPlayer();
            clientPlayer.displayChatMessage(LanguageSystem.SYSTEM_DEBUG, JSONParser.importAllJSONs(true));
            JSONParser.applyImports(clientPlayer.getWorld());
            InterfaceManager.packetInterface.sendToServer(new PacketPackImport());
        }
    }

    static {
        runningJoystickThread = false;
        runningClassicMode = false;
        joystickLoadingAttempted = false;
        joystickEnabled = false;
        joystickBlocked = false;
        joystickInhibited = false;
        joystickNameCounters = new HashMap<String, Integer>();
        joystickMap = new LinkedHashMap<String, Controller>();
        joystickAxisCountMap = new LinkedHashMap<String, Integer>();
        classicJoystickMap = new LinkedHashMap<String, net.java.games.input.Controller>();
    }
}

