/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class EVRenderer {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EVClient.shouldRender()) {
            ArrayList<String> warnings = new ArrayList<String>();
            if (OptifineHelper.isActive() && OptifineHelper.isFastRender()) {
                warnings.add(ChatFormatting.RED + "(EnhancedVisuals) Optifine detected - Disable Fast Render");
            }
            if (OptifineHelper.isActive() && OptifineHelper.isAnisotropicFiltering()) {
                warnings.add(ChatFormatting.RED + "(EnhancedVisuals) Optifine detected - Disable Anisotropic Filtering");
            }
            if (OptifineHelper.isActive() && OptifineHelper.isAntialiasing()) {
                warnings.add(ChatFormatting.RED + "(EnhancedVisuals) Optifine detected - Disable Antialiasing");
            }
            if (!warnings.isEmpty()) {
                GlStateManager.func_179094_E();
                for (int i = 0; i < warnings.size(); ++i) {
                    String warning = (String)warnings.get(i);
                    int k = EVRenderer.mc.field_71466_p.func_78256_a(warning);
                    int i1 = 2 + EVRenderer.mc.field_71466_p.field_78288_b * i;
                    Gui.func_73734_a((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + EVRenderer.mc.field_71466_p.field_78288_b - 1), (int)-1873784752);
                    EVRenderer.mc.field_71466_p.func_78276_b(warning, 2, i1, 0xE0E0E0);
                }
                GlStateManager.func_179121_F();
            }
            if (!(EVRenderer.mc.field_71462_r instanceof GuiGameOver)) {
                if (EVRenderer.mc.field_71439_g != null && EVRenderer.mc.field_71439_g.field_70738_aO > 0 && EVRenderer.mc.field_71439_g.field_70737_aN == EVRenderer.mc.field_71439_g.field_70738_aO) {
                    VisualHandlers.DAMAGE.clientHurt();
                }
                if (EVRenderer.mc.func_147110_a().field_147621_c != framebufferWidth || EVRenderer.mc.func_147110_a().field_147618_d != framebufferHeight) {
                    for (VisualType type : VisualType.getTypes()) {
                        type.resize(mc.func_147110_a());
                    }
                    framebufferWidth = EVRenderer.mc.func_147110_a().field_147621_c;
                    framebufferHeight = EVRenderer.mc.func_147110_a().field_147618_d;
                }
                ScaledResolution resolution = new ScaledResolution(mc);
                int screenWidth = resolution.func_78326_a();
                int screenHeight = resolution.func_78328_b();
                GlStateManager.func_179094_E();
                TextureManager manager = mc.func_110434_K();
                float partialTicks = event.renderTickTime;
                RenderHelper.func_74519_b();
                GlStateManager.func_179140_f();
                GlStateManager.func_179086_m((int)256);
                GlStateManager.func_179128_n((int)5889);
                GlStateManager.func_179096_D();
                GlStateManager.func_179130_a((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)1000.0, (double)3000.0);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179096_D();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179097_i();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179118_c();
                GlStateManager.func_179147_l();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.overlay), manager, screenWidth, screenHeight, partialTicks);
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.particle), manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179096_D();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.shader), manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.func_179121_F();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179126_j();
                GlStateManager.func_179141_d();
                GlStateManager.func_179140_f();
                mc.func_147110_a().func_147610_a(false);
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179121_F();
                lastRenderedMessage = null;
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = EnhancedVisuals.MESSAGES.pickRandomDeathMessage();
                }
                if (lastRenderedMessage != null) {
                    EVRenderer.mc.field_71466_p.func_78276_b("\"" + lastRenderedMessage + "\"", EVRenderer.mc.field_71462_r.field_146294_l / 2 - EVRenderer.mc.field_71466_p.func_78256_a(lastRenderedMessage) / 2, 114, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderVisuals(Collection<Visual> visuals, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                GlStateManager.func_179094_E();
                visual.render(manager, screenWidth, screenHeight, partialTicks);
                GlStateManager.func_179121_F();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

