/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.render.TextureCache;

public abstract class VisualTypeTexture
extends VisualType {
    @CreativeConfig
    public int animationSpeed;
    public String domain;
    @SideOnly(value=Side.CLIENT)
    public TextureCache[] resources;
    @SideOnly(value=Side.CLIENT)
    public Dimension dimension;

    public VisualTypeTexture(VisualCategory category, String name, String domain, int animationSpeed) {
        super(name, category);
        this.domain = domain;
        this.animationSpeed = animationSpeed;
    }

    public VisualTypeTexture(VisualCategory category, String name, int animationSpeed) {
        this(category, name, null, animationSpeed);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadResources(IResourceManager manager) {
        String baseLocation = "visuals/" + this.cat.name() + "/" + this.name + "/" + this.name;
        ArrayList<TextureCache> caches = new ArrayList<TextureCache>();
        int i = 0;
        TextureCache resource = null;
        String domain = this.domain == null ? "enhancedvisuals" : this.domain;
        try {
            while ((resource = TextureCache.parse(manager, domain, baseLocation + i)) != null) {
                if (i == 0) {
                    BufferedImage image = ImageIO.read(manager.func_110536_a(resource.getFirst()).func_110527_b());
                    this.dimension = new Dimension(image.getWidth(), image.getHeight());
                }
                caches.add(resource);
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.resources = caches.toArray(new TextureCache[0]);
        if (this.resources.length == 0) {
            EnhancedVisuals.LOGGER.warn("Could not find any resources for '" + this.name + "'!");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getVariantAmount() {
        return this.resources.length;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getResource(Visual visual) {
        if (this.animationSpeed > 0) {
            long time = Math.abs(System.nanoTime() / 3000000L / (long)this.animationSpeed);
            return this.resources[(int)(time % (long)this.resources.length)].getResource();
        }
        return this.resources[visual.variant].getResource();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(VisualHandler handler, Visual visual, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        manager.func_110577_a(this.getResource(visual));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        float red = visual.color != null ? (float)visual.color.getRed() / 255.0f : 1.0f;
        float green = visual.color != null ? (float)visual.color.getGreen() / 255.0f : 1.0f;
        float blue = visual.color != null ? (float)visual.color.getBlue() / 255.0f : 1.0f;
        double z = -90.0;
        int width = visual.getWidth(screenWidth);
        int height = visual.getHeight(screenHeight);
        float opacity = visual.getOpacity();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        renderer.func_181662_b(0.0, (double)height, z).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, opacity).func_181675_d();
        renderer.func_181662_b((double)width, (double)height, z).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, opacity).func_181675_d();
        renderer.func_181662_b((double)width, 0.0, z).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, opacity).func_181675_d();
        renderer.func_181662_b(0.0, 0.0, z).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, opacity).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    public int getWidth(int screenWidth) {
        return this.dimension.width;
    }

    @Override
    public int getHeight(int screenHeight) {
        return this.dimension.height;
    }
}

