/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Arrays;
import java.util.Collection;
import javax.sound.sampled.Control;
import org.tritonus.share.TDebug;

public abstract class EnumControl
extends Control {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Object m_value;
    private Collection<Object> m_values;

    protected EnumControl(Type type, Object[] aValues, Object value) {
        super(type);
        if (TDebug.TraceControl) {
            TDebug.out("EnumControl.<init>: begin");
        }
        this.m_values = Arrays.asList(aValues);
        this.setValue(value);
        if (TDebug.TraceControl) {
            TDebug.out("EnumControl.<init>: end");
        }
    }

    public void setValue(Object value) {
        if (!this.m_values.contains(value)) {
            throw new IllegalArgumentException("illegal value " + value);
        }
        this.m_value = value;
    }

    public Object getValue() {
        return this.m_value;
    }

    public Object[] getValues() {
        return this.m_values.toArray(EMPTY_OBJECT_ARRAY);
    }

    public String toString() {
        return super.toString() + " [value = " + this.getValue() + "]";
    }

    public static class Type
    extends Control.Type {
        public static final Type REVERB = new Type("REVERB");

        protected Type(String strName) {
            super(strName);
        }
    }
}

