/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class ShortMessage
extends MidiMessage {
    private static final boolean CHECK_SECOND_BYTE = false;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    public static final int MIDI_TIME_CODE = 241;
    public static final int SONG_POSITION_POINTER = 242;
    public static final int SONG_SELECT = 243;
    public static final int TUNE_REQUEST = 246;
    public static final int END_OF_EXCLUSIVE = 247;
    public static final int TIMING_CLOCK = 248;
    public static final int START = 250;
    public static final int CONTINUE = 251;
    public static final int STOP = 252;
    public static final int ACTIVE_SENSING = 254;
    public static final int SYSTEM_RESET = 255;
    private static final int[] sm_anChannelMessageLength = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, 2, 2, 2, 2, 1, 1, 2};
    private static final int[] sm_anSystemMessageLength = new int[]{-1, 2, 3, 2, -1, -1, 1, 0, 1, -1, 1, 1, 1, -1, 1, 1};

    public ShortMessage() {
        this(null);
    }

    protected ShortMessage(byte[] abData) {
        super(abData);
    }

    public Object clone() {
        byte[] abData = this.getMessage();
        ShortMessage message = new ShortMessage(abData);
        return message;
    }

    public void setMessage(int nStatus) throws InvalidMidiDataException {
        if (this.getDataLength(nStatus) != 0) {
            throw new InvalidMidiDataException("not a one-byte command");
        }
        byte[] abData = new byte[]{(byte)nStatus};
        this.setMessage(abData, 1);
    }

    public void setMessage(int nStatus, int nData1, int nData2) throws InvalidMidiDataException {
        int nDataLength = this.getDataLength(nStatus);
        if (nDataLength < 1) {
            throw new InvalidMidiDataException("not a two- or three-byte command");
        }
        byte[] abData = new byte[nDataLength + 1];
        abData[0] = (byte)nStatus;
        abData[1] = (byte)nData1;
        if (nDataLength == 2) {
            abData[2] = (byte)nData2;
        } else if (nData2 != 0) {
            // empty if block
        }
        this.setMessage(abData, nDataLength + 1);
    }

    public void setMessage(int nCommand, int nChannel, int nData1, int nData2) throws InvalidMidiDataException {
        this.setMessage(nCommand & 0xF0 | nChannel & 0xF, nData1, nData2);
    }

    public int getChannel() {
        return this.getStatus() & 0xF;
    }

    public int getCommand() {
        return this.getStatus() & 0xF0;
    }

    public int getData1() {
        return this.getDataByte(1);
    }

    public int getData2() {
        return this.getDataByte(2);
    }

    private int getDataByte(int nNumber) {
        int nDataByte = 0;
        if (this.getLength() >= nNumber) {
            nDataByte = this.getMessage()[nNumber];
        }
        return nDataByte;
    }

    protected final int getDataLength(int nStatus) throws InvalidMidiDataException {
        int nDataLength = 0;
        nDataLength = nStatus < 240 ? sm_anChannelMessageLength[nStatus >> 4 & 0xF] : sm_anSystemMessageLength[nStatus & 0xF];
        if (nDataLength == -1) {
            throw new InvalidMidiDataException("status byte not usable for ShortMessage");
        }
        return nDataLength;
    }
}

