/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiFileFormat {
    public static final int UNKNOWN_LENGTH = -1;
    protected int type;
    protected float divisionType;
    protected int resolution;
    protected int byteLength;
    protected long microsecondLength;
    private Map<String, Object> m_properties;
    private Map<String, Object> m_unmodifiableProperties;

    public MidiFileFormat(int nType, float fDivisionType, int nResolution, int nByteLength, long lMicrosecondLength) {
        this(nType, fDivisionType, nResolution, nByteLength, lMicrosecondLength, null);
    }

    public MidiFileFormat(int nType, float fDivisionType, int nResolution, int nByteLength, long lMicrosecondLength, Map<String, Object> properties) {
        this.type = nType;
        this.divisionType = fDivisionType;
        this.resolution = nResolution;
        this.byteLength = nByteLength;
        this.microsecondLength = lMicrosecondLength;
        this.m_properties = new HashMap<String, Object>();
        if (properties != null) {
            this.m_properties.putAll(properties);
        }
        this.m_unmodifiableProperties = Collections.unmodifiableMap(this.m_properties);
    }

    public int getType() {
        return this.type;
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    public Map<String, Object> properties() {
        return this.m_unmodifiableProperties;
    }

    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    protected void setProperty(String key, Object value) {
        this.m_properties.put(key, value);
    }
}

