/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server.util;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ChunkedIterator<T>
extends AbstractIterator<Collection<T>> {
    private final Iterator<T> iterator;
    private final int chunkSize;
    private final List<T> buffer;

    private ChunkedIterator(Iterator<T> iterator, int chunkSize) {
        this.iterator = iterator;
        this.chunkSize = chunkSize;
        this.buffer = new ArrayList<T>(chunkSize);
    }

    public static <T> Iterator<Collection<T>> of(Iterator<T> iterator, int chunkSize) {
        return new ChunkedIterator<T>(iterator, chunkSize);
    }

    public static <T> Iterable<Collection<T>> of(Iterable<T> iterable, int chunkSize) {
        return () -> new ChunkedIterator(iterable.iterator(), chunkSize);
    }

    protected Collection<T> computeNext() {
        this.buffer.clear();
        for (int i = 0; i < this.chunkSize && this.iterator.hasNext(); ++i) {
            this.buffer.add(this.iterator.next());
        }
        if (this.buffer.isEmpty()) {
            return (Collection)this.endOfData();
        }
        return this.buffer;
    }
}

