/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.server;

import dev.gegy.gengen.api.GenericWorldType;
import java.util.Collection;
import net.gegy1000.terrarium.server.capability.TerrariumAuxCaps;
import net.gegy1000.terrarium.server.capability.TerrariumCapabilities;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.util.Profiler;
import net.gegy1000.terrarium.server.util.ThreadedProfiler;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.gegy1000.terrarium.server.world.coordinate.Coordinate;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.source.DataSourceReader;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="terrarium")
public class ServerEventHandler {
    private static final long DATA_TRACK_INTERVAL = 2000L;
    private static long lastDataTrackTime;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSetWorldSpawn(WorldEvent.CreateSpawnPosition event) {
        Coordinate spawnPosition;
        TerrariumWorld terrarium;
        World world = event.getWorld();
        if (!world.field_72995_K && ServerEventHandler.shouldHandle(world) && (terrarium = TerrariumWorld.get(world)) != null && (spawnPosition = terrarium.getSpawnPosition()) != null) {
            world.func_175652_B(spawnPosition.toBlockPos());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        TerrariumWorld worldData;
        World world = event.getWorld();
        if (!world.field_72995_K && ServerEventHandler.shouldHandle(world) && (worldData = TerrariumWorld.get(world)) != null) {
            worldData.getDataCache().close();
            DataSourceReader.INSTANCE.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        World world = (World)event.getObject();
        if (ServerEventHandler.shouldHandle(world)) {
            TerrariumWorldType worldType = GenericWorldType.unwrapAs(world.func_175624_G(), TerrariumWorldType.class);
            if (worldType == null) {
                return;
            }
            TerrariumAuxCaps.Implementation aux = new TerrariumAuxCaps.Implementation();
            if (!world.field_72995_K && world instanceof WorldServer) {
                TerrariumWorld.Impl terrarium = new TerrariumWorld.Impl((WorldServer)world, worldType);
                Collection<ICapabilityProvider> capabilities = worldType.createCapabilities(world, terrarium.getSettings());
                for (ICapabilityProvider provider : capabilities) {
                    aux.addAux(provider);
                }
                event.addCapability(TerrariumCapabilities.WORLD_DATA_ID, (ICapabilityProvider)terrarium);
            }
            event.addCapability(TerrariumCapabilities.AUX_DATA_ID, (ICapabilityProvider)aux);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        block39: {
            World world = event.world;
            if (event.phase == TickEvent.Phase.START && ServerEventHandler.shouldHandle(world) && world instanceof WorldServer) {
                TerrariumWorld terrarium = TerrariumWorld.get(world);
                if (terrarium == null) {
                    return;
                }
                Profiler profiler = ThreadedProfiler.get();
                try (Profiler.Handle tick = profiler.push("tick");){
                    ColumnDataCache dataCache = terrarium.getDataCache();
                    try (Profiler.Handle advance = profiler.push("advance");){
                        long allocation = 2000000L;
                        dataCache.advanceUntil(System.nanoTime() + allocation);
                    }
                    long time = System.currentTimeMillis();
                    if (time - lastDataTrackTime <= 2000L) break block39;
                    try (Profiler.Handle track = profiler.push("track_columns");){
                        dataCache.dropColumns();
                        dataCache.trackColumns();
                        lastDataTrackTime = time;
                    }
                }
            }
        }
    }

    private static boolean shouldHandle(World world) {
        GenericWorldType worldType = GenericWorldType.unwrap(world.func_175624_G());
        return world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && worldType instanceof TerrariumWorldType;
    }
}

