/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client.gui.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.gegy1000.terrarium.client.gui.GuiRenderUtils;
import net.gegy1000.terrarium.client.gui.widget.TooltipRenderer;
import net.gegy1000.terrarium.server.world.generator.customization.property.CycleEnumProperty;
import net.gegy1000.terrarium.server.world.generator.customization.property.PropertyPair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CycleGuiWidget<T extends Enum>
extends GuiButtonExt
implements TooltipRenderer {
    private final PropertyPair<T> property;
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private int ordinal;
    private float hoverTime;

    public CycleGuiWidget(PropertyPair<T> property) {
        super(0, 0, 0, 150, 20, "");
        this.property = property;
        this.setOrdinal(((Enum)property.value.get()).ordinal());
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
            this.hoverTime = this.isSelected(mouseX, mouseY) ? (this.hoverTime += partialTicks) : 0.0f;
        }
    }

    @Override
    public void renderTooltip(int mouseX, int mouseY) {
        if (this.hoverTime >= 15.0f) {
            List<String> lines = this.getTooltip();
            GuiRenderUtils.drawTooltip(lines, mouseX, mouseY);
        }
    }

    private List<String> getTooltip() {
        String name = TextFormatting.BLUE + this.property.key.getLocalizedName();
        String tooltip = TextFormatting.GRAY + this.property.key.getLocalizedTooltip();
        ArrayList lines = Lists.newArrayList((Object[])new String[]{name, tooltip});
        for (Enum variant : this.getVariants()) {
            String descriptionKey = ((CycleEnumProperty)((Object)variant)).getDescriptionKey();
            if (descriptionKey == null) continue;
            String translatedKey = I18n.func_135052_a((String)((CycleEnumProperty)((Object)variant)).getTranslationKey(), (Object[])new Object[0]);
            String translatedDescription = I18n.func_135052_a((String)((CycleEnumProperty)((Object)variant)).getDescriptionKey(), (Object[])new Object[0]);
            lines.add(((CycleEnumProperty)((Object)variant)).getFormatting() + String.format(" - %s: %s", translatedKey, TextFormatting.GRAY + translatedDescription));
        }
        return lines;
    }

    public void setOrdinal(int ordinal) {
        if (ordinal != this.ordinal) {
            Enum[] constants = this.getVariants();
            this.property.value.set(constants[ordinal]);
            this.listeners.forEach(Runnable::run);
        }
        this.ordinal = ordinal;
        T variant = this.getVariant(this.ordinal);
        String state = ((CycleEnumProperty)variant).getFormatting() + I18n.func_135052_a((String)((CycleEnumProperty)variant).getTranslationKey(), (Object[])new Object[0]);
        this.field_146126_j = String.format("%s: %s", this.property.key.getLocalizedName(), state);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (this.isSelected(mouseX, mouseY)) {
            Enum[] variants = this.getVariants();
            this.setOrdinal((this.ordinal + 1) % variants.length);
            return true;
        }
        return false;
    }

    private boolean isSelected(int mouseX, int mouseY) {
        return this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
    }

    private T getVariant(int ordinal) {
        Enum[] variants = this.getVariants();
        return (T)variants[ordinal % variants.length];
    }

    private T[] getVariants() {
        return (Enum[])this.property.key.getType().getEnumConstants();
    }
}

