/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.terrarium.client;

import dev.gegy.gengen.api.GenericWorldType;
import javax.annotation.Nullable;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.client.ClientProxy;
import net.gegy1000.terrarium.server.message.TerrariumHandshakeMessage;
import net.gegy1000.terrarium.server.world.TerrariumWorldType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="terrarium", value={Side.CLIENT})
public class ClientEventHandler {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final int WORLD_TYPE_BUTTON_ID = 5;
    private static boolean handshakeQueued;

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (!handshakeQueued) {
            return;
        }
        if (ClientEventHandler.MC.field_71439_g != null && ClientEventHandler.MC.field_71439_g.field_70173_aa > 1) {
            handshakeQueued = false;
            Terrarium.NETWORK.sendToServer((IMessage)new TerrariumHandshakeMessage());
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K && Terrarium.serverHasMod) {
            handshakeQueued = true;
        }
    }

    @SubscribeEvent
    public static void onGuiPostInit(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiCreateWorld createWorld;
        TerrariumWorldType worldType;
        GuiScreen currentScreen = event.getGui();
        if (currentScreen instanceof GuiCreateWorld && (worldType = ClientEventHandler.getSelectedWorldType(createWorld = (GuiCreateWorld)currentScreen)) != null) {
            ClientEventHandler.hideStructuresButton(createWorld);
        }
    }

    @SubscribeEvent
    public static void onGuiButton(GuiScreenEvent.ActionPerformedEvent.Post event) {
        GuiCreateWorld createWorld;
        TerrariumWorldType worldType;
        GuiScreen currentScreen = event.getGui();
        if (currentScreen instanceof GuiCreateWorld && event.getButton().field_146127_k == 5 && (worldType = ClientEventHandler.getSelectedWorldType(createWorld = (GuiCreateWorld)currentScreen)) != null) {
            if (worldType.isHidden() && !GuiScreen.func_146272_n()) {
                ClientProxy.actionPerformed(currentScreen, event.getButton());
            } else {
                ClientEventHandler.hideStructuresButton(createWorld);
            }
        }
    }

    @Nullable
    private static TerrariumWorldType getSelectedWorldType(GuiCreateWorld createWorld) {
        int selectedWorldIndex = ClientProxy.getSelectedWorldType(createWorld);
        return GenericWorldType.unwrapAs(WorldType.field_77139_a[selectedWorldIndex], TerrariumWorldType.class);
    }

    private static void hideStructuresButton(GuiCreateWorld createWorld) {
        GuiButton structuresButton = ClientProxy.getStructuresButton(createWorld);
        if (structuresButton != null) {
            structuresButton.field_146125_m = false;
        }
    }
}

