/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.executor;

import java.util.concurrent.ThreadFactory;
import net.gegy1000.justnow.executor.Task;
import net.gegy1000.justnow.executor.TaskHandle;
import net.gegy1000.justnow.executor.TaskQueue;
import net.gegy1000.justnow.future.Future;

public final class ThreadedExecutor
implements AutoCloseable {
    private final Worker[] workers;
    private final TaskQueue taskQueue = new TaskQueue();

    public ThreadedExecutor(int threadCount, ThreadFactory factory) {
        this.workers = new Worker[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            this.workers[i] = new Worker(factory);
        }
        for (Worker worker : this.workers) {
            worker.start();
        }
    }

    public <T> TaskHandle<T> spawn(Future<T> future) {
        Task<T> task = new Task<T>(future, this.taskQueue);
        this.taskQueue.enqueue(task);
        return task.handle;
    }

    public <T> Future<T> steal(TaskHandle<T> handle) {
        this.taskQueue.remove(handle.task);
        return handle.steal();
    }

    public boolean cancel(TaskHandle<?> handle) {
        if (this.taskQueue.remove(handle.task)) {
            handle.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.taskQueue.close();
    }

    public void closeAndInterrupt() {
        this.close();
        for (Worker worker : this.workers) {
            worker.thread.interrupt();
        }
    }

    private class Worker {
        private final Thread thread;

        Worker(ThreadFactory factory) {
            this.thread = factory.newThread(this::drive);
        }

        public void start() {
            this.thread.start();
        }

        private void drive() {
            try {
                Task<?> task;
                while ((task = ThreadedExecutor.this.taskQueue.take()) != null) {
                    task.advance();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

