/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.executor;

import java.util.concurrent.atomic.AtomicBoolean;
import net.gegy1000.justnow.executor.TaskHandle;
import net.gegy1000.justnow.executor.TaskQueue;
import net.gegy1000.justnow.future.Future;

public final class Task<T> {
    public final Future<T> future;
    public final TaskQueue.Waker waker;
    public final TaskHandle<T> handle;
    private final AtomicBoolean invalidated = new AtomicBoolean(false);

    public Task(Future<T> future, TaskQueue taskQueue) {
        this.future = future;
        this.handle = new TaskHandle(this);
        this.waker = taskQueue.waker(this);
    }

    public void invalidate() {
        this.invalidated.set(true);
    }

    public boolean isInvalid() {
        return this.invalidated.get();
    }

    public void advance() {
        if (this.isInvalid()) {
            return;
        }
        try {
            this.waker.polling();
            T result = this.future.poll(this.waker);
            if (result != null) {
                this.invalidate();
                this.handle.completeOk(result);
            } else {
                this.waker.ready();
            }
        }
        catch (Throwable exception) {
            this.invalidate();
            this.handle.completeErr(exception);
        }
    }
}

