/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.justnow.executor;

import java.util.ArrayList;
import java.util.Collection;
import net.gegy1000.justnow.executor.Task;
import net.gegy1000.justnow.executor.TaskHandle;
import net.gegy1000.justnow.executor.TaskQueue;
import net.gegy1000.justnow.future.Future;

public final class LocalExecutor
implements AutoCloseable {
    private final TaskQueue taskQueue = new TaskQueue();
    private final Collection<Task<?>> drainBuffer = new ArrayList();

    public <T> TaskHandle<T> spawn(Future<T> future) {
        Task<T> task = new Task<T>(future, this.taskQueue);
        this.taskQueue.enqueue(task);
        return task.handle;
    }

    public <T> Future<T> steal(TaskHandle<T> handle) {
        this.taskQueue.remove(handle.task);
        return handle.steal();
    }

    public boolean cancel(TaskHandle<?> handle) {
        if (this.taskQueue.remove(handle.task)) {
            handle.invalidate();
            return true;
        }
        return false;
    }

    public void run() throws InterruptedException {
        Task<?> task;
        while ((task = this.taskQueue.take()) != null) {
            task.advance();
        }
    }

    public boolean advanceAll() {
        this.drainBuffer.clear();
        this.taskQueue.drainTo(this.drainBuffer);
        for (Task<?> task : this.drainBuffer) {
            task.advance();
        }
        return !this.taskQueue.isEmpty();
    }

    @Override
    public void close() {
        this.taskQueue.close();
    }
}

