/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.feature;

import java.util.Random;
import net.gegy1000.earth.server.world.ecology.SoilPredicate;
import net.gegy1000.earth.server.world.feature.AbstractTreeFeature;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TallShrubFeature
extends AbstractTreeFeature {
    public TallShrubFeature(boolean notify, IBlockState log, IBlockState leaves) {
        super(notify, log, leaves);
    }

    public boolean func_180709_b(World world, Random random, BlockPos origin) {
        if (!this.tryGrowOn(world, origin.func_177977_b(), SoilPredicate.ANY)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(origin);
        this.setWood(world, origin, mutablePos);
        boolean thickLeaves = random.nextBoolean();
        if (thickLeaves) {
            this.setLeafPlane(world, origin.func_177981_b(1), mutablePos);
            this.setLeafCross(world, origin.func_177981_b(2), mutablePos);
        } else {
            this.setLeafCross(world, origin.func_177981_b(1), mutablePos);
            this.setLeaves(world, origin.func_177981_b(2));
        }
        return true;
    }

    private void setWood(World world, BlockPos origin, BlockPos.MutableBlockPos mutablePos) {
        for (int y = 0; y < 2; ++y) {
            mutablePos.func_185336_p(origin.func_177956_o() + y);
            this.setLog(world, (BlockPos)mutablePos);
        }
    }

    private void setLeafPlane(World world, BlockPos origin, BlockPos.MutableBlockPos mutablePos) {
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                mutablePos.func_181079_c(origin.func_177958_n() + x, origin.func_177956_o(), origin.func_177952_p() + z);
                this.trySetLeaves(world, (BlockPos)mutablePos);
            }
        }
    }

    private void setLeafCross(World world, BlockPos origin, BlockPos.MutableBlockPos mutablePos) {
        for (int z = -1; z <= 1; ++z) {
            mutablePos.func_181079_c(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p() + z);
            this.trySetLeaves(world, (BlockPos)mutablePos);
        }
        for (int x = -1; x <= 1; ++x) {
            mutablePos.func_181079_c(origin.func_177958_n() + x, origin.func_177956_o(), origin.func_177952_p());
            this.trySetLeaves(world, (BlockPos)mutablePos);
        }
    }
}

