/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data.op;

import net.gegy1000.terrarium.server.world.data.DataOp;
import net.gegy1000.terrarium.server.world.data.raster.FloatRaster;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.minecraft.util.math.MathHelper;

public final class TransformTerrainElevation {
    private final double terrestrialScale;
    private final double oceanicScale;
    private final int offset;

    public TransformTerrainElevation(double terrestrialScale, double oceanicScale, int offset) {
        this.terrestrialScale = terrestrialScale;
        this.oceanicScale = oceanicScale;
        this.offset = offset;
    }

    public DataOp<ShortRaster> apply(DataOp<FloatRaster> source) {
        return source.map((raster, view) -> {
            ShortRaster result = ShortRaster.create(view);
            raster.iterate((elevation, x, y) -> {
                short value = elevation >= 0.0f ? (short)(MathHelper.func_76143_f((double)((double)elevation * this.terrestrialScale)) + this.offset) : (short)(MathHelper.func_76128_c((double)((double)elevation * this.oceanicScale)) + this.offset);
                result.set(x, y, value);
            });
            return result;
        });
    }
}

