/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.data;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.gegy1000.earth.server.shared.SharedEarthData;
import net.gegy1000.earth.server.world.data.EarthApiKeys;

public final class GooglePanorama {
    private static final String METADATA_ADDRESS = "https://maps.googleapis.com/maps/api/streetview/metadata?location=%.5f,%.5f&radius=%.0f&source=outdoor&key=%s";
    private static final String PANORAMA_ADDRESS = "https://geo0.ggpht.com/cbk?cb_client=maps_sv.tactile&panoid=%s&output=tile&x=%s&y=%s&zoom=%s&nbt&fover=2";
    private static final String BROWSER_UA = "Mozilla/5.0 (Windows NT 10.0; \u00e2\u20ac\u00a6) Gecko/20100101 Firefox/61.0";
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final String id;
    private final double latitude;
    private final double longitude;

    GooglePanorama(String id, double latitude, double longitude) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Nullable
    public static GooglePanorama lookup(double latitude, double longitude, double radius) throws IOException {
        EarthApiKeys keys = SharedEarthData.instance().get(SharedEarthData.API_KEYS);
        if (keys == null) {
            return null;
        }
        String key = keys.getStreetviewKey();
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(String.format(METADATA_ADDRESS, latitude, longitude, radius, key)).openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "terrarium");
        connection.setRequestProperty("Referer", "https://github.com/gegy1000/Terrarium");
        connection.setConnectTimeout(4000);
        connection.setReadTimeout(30000);
        try (InputStreamReader input = new InputStreamReader(new BufferedInputStream(connection.getInputStream()));){
            JsonObject root = (JsonObject)JSON_PARSER.parse((Reader)input);
            GooglePanorama.handleResponseStatus(root);
            if (root.has("location")) {
                JsonObject location = root.getAsJsonObject("location");
                double panoLat = location.get("lat").getAsDouble();
                double panoLon = location.get("lng").getAsDouble();
                String panoId = root.get("pano_id").getAsString();
                GooglePanorama googlePanorama = new GooglePanorama(panoId, panoLat, panoLon);
                return googlePanorama;
            }
        }
        return null;
    }

    private static void handleResponseStatus(JsonObject root) throws IOException {
        if (root.has("status")) {
            String status = root.get("status").getAsString();
            if (status.equalsIgnoreCase("OVER_QUERY_LIMIT")) {
                throw new IOException("Reached query limit for Google API! Try again in a few minutes");
            }
            if (status.equalsIgnoreCase("REQUEST_DENIED")) {
                throw new IOException(root.get("error_message").getAsString());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public BufferedImage loadTile(int tileX, int tileY, int zoom) throws IOException {
        URL url = new URL(String.format(PANORAMA_ADDRESS, this.id, tileX, tileY, zoom));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        connection.setRequestProperty("Connection", "keep-alive");
        connection.setRequestProperty("Host", "geo0.ggpht.com");
        connection.setRequestProperty("Origin", "https://www.google.com");
        connection.setRequestProperty("Referer", "https://www.google.com/");
        connection.setRequestProperty("User-Agent", BROWSER_UA);
        connection.setConnectTimeout(4000);
        connection.setReadTimeout(30000);
        try (BufferedInputStream input = new BufferedInputStream(connection.getInputStream());){
            BufferedImage bufferedImage = ImageIO.read(input);
            return bufferedImage;
        }
    }
}

