/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.structure.data;

import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.structure.StructureStart;

public final class StructureStartMap
implements Iterable<StructureStart> {
    private static final int MIX = 662976773;
    private final float loadFactor;
    private StructureStart[] table;
    private int capacity;
    private int mask;
    private int size;
    private int growThreshold;

    public StructureStartMap(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.setupTable(capacity);
    }

    private void setupTable(int capacity) {
        this.capacity = MathHelper.func_151236_b((int)capacity);
        this.mask = this.capacity - 1;
        this.growThreshold = MathHelper.func_76141_d((float)((float)this.capacity * this.loadFactor)) - 1;
        StructureStart[] previous = this.table;
        this.table = new StructureStart[this.capacity];
        if (previous != null) {
            this.copyEntriesFrom(previous);
        }
    }

    private void copyEntriesFrom(StructureStart[] table) {
        for (StructureStart entry : table) {
            if (entry == null) continue;
            this.put(entry);
        }
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    @Nullable
    public StructureStart put(StructureStart start) {
        StructureStart entry;
        int x = start.func_143019_e();
        int z = start.func_143018_f();
        int index = this.index(x, z);
        while ((entry = this.table[index]) != null) {
            if (entry.func_143019_e() == x && entry.func_143018_f() == z) {
                this.table[index] = start;
                return entry;
            }
            index = index + 1 & this.mask;
        }
        this.table[index] = start;
        if (++this.size > this.growThreshold) {
            this.setupTable(this.capacity * 2);
        }
        return null;
    }

    @Nullable
    public StructureStart get(int x, int z) {
        StructureStart entry;
        int index = this.index(x, z);
        while ((entry = this.table[index]) != null) {
            if (entry.func_143019_e() == x && entry.func_143018_f() == z) {
                return entry;
            }
            index = index + 1 & this.mask;
        }
        return null;
    }

    public boolean contains(int x, int z) {
        return this.get(x, z) != null;
    }

    private int index(int x, int z) {
        return StructureStartMap.hash(x, z) & this.mask;
    }

    private static int hash(int x, int z) {
        int hash = 662976773;
        hash += x;
        hash *= 662976773;
        hash += z;
        return hash *= 662976773;
    }

    @Override
    public Iterator<StructureStart> iterator() {
        return new AbstractIterator<StructureStart>(){
            private int index;

            protected StructureStart computeNext() {
                while (this.index < StructureStartMap.this.table.length) {
                    StructureStart entry = StructureStartMap.this.table[this.index++];
                    if (entry == null) continue;
                    return entry;
                }
                return (StructureStart)this.endOfData();
            }
        };
    }
}

