/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.composer.decoration;

import dev.gegy.gengen.api.CubicPos;
import dev.gegy.gengen.api.writer.ChunkPopulationWriter;
import dev.gegy.gengen.util.SpatialRandom;
import java.util.Random;
import net.gegy1000.earth.server.world.EarthData;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.gegy1000.terrarium.server.world.composer.decoration.DecorationComposer;
import net.gegy1000.terrarium.server.world.data.ColumnDataCache;
import net.gegy1000.terrarium.server.world.data.raster.ShortRaster;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenLakes;

public class LavaPoolComposer
implements DecorationComposer {
    private static final int DEPTH = 54;
    private static final int CHANCE = 30;
    private static final WorldGenLakes GENERATOR = new WorldGenLakes((Block)Blocks.field_150353_l);
    private final ShortRaster.Sampler heightSampler = ShortRaster.sampler(EarthData.TERRAIN_HEIGHT);
    private final SpatialRandom random;

    public LavaPoolComposer(World world) {
        this.random = new SpatialRandom(world, 1234L);
    }

    @Override
    public void composeDecoration(TerrariumWorld terrarium, CubicPos cubePos, ChunkPopulationWriter writer) {
        ColumnDataCache dataCache = terrarium.getDataCache();
        short surfaceHeight = this.heightSampler.sample(dataCache, cubePos.getMaxX(), cubePos.getMaxZ());
        if (cubePos.getMinY() > surfaceHeight - 54) {
            return;
        }
        World world = writer.getGlobal();
        this.random.setSeed(cubePos.getX(), cubePos.getY(), cubePos.getZ());
        if (this.random.nextInt(30) == 0) {
            int x = cubePos.getCenterX() + this.random.nextInt(16);
            int y = cubePos.getCenterY() + this.random.nextInt(16);
            int z = cubePos.getCenterZ() + this.random.nextInt(16);
            GENERATOR.func_180709_b(world, (Random)this.random, new BlockPos(x, y, z));
        }
    }
}

