/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility.capability;

import dev.gegy.gengen.core.GenGen;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gegy1000.earth.TerrariumEarth;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="earth")
public final class CcColumnCompatibilityMetadata
implements ICapabilitySerializable<NBTTagByte> {
    public static final ResourceLocation ID = new ResourceLocation("earth", "cc_compat_meta");
    private boolean runGenerator;

    public boolean tryRunGenerator() {
        if (!this.runGenerator) {
            this.runGenerator = true;
            return true;
        }
        return false;
    }

    @Nullable
    public static CcColumnCompatibilityMetadata get(Chunk chunk) {
        return (CcColumnCompatibilityMetadata)chunk.getCapability(TerrariumEarth.ccCompatibilityGenerationCap(), null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == TerrariumEarth.ccCompatibilityGenerationCap();
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == TerrariumEarth.ccCompatibilityGenerationCap() ? TerrariumEarth.ccCompatibilityGenerationCap().cast((Object)this) : null);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        World world = ((Chunk)event.getObject()).func_177412_p();
        if (world == null || GenGen.isCubic(world)) {
            event.addCapability(ID, (ICapabilityProvider)new CcColumnCompatibilityMetadata());
        }
    }

    public NBTTagByte serializeNBT() {
        return new NBTTagByte((byte)(this.runGenerator ? 1 : 0));
    }

    public void deserializeNBT(NBTTagByte nbt) {
        this.runGenerator = nbt.func_150290_f() != 0;
    }
}

