/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.compatibility;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.gegy1000.earth.server.world.compatibility.CompatibilityChunkProvider;
import net.gegy1000.earth.server.world.compatibility.CompatibilitySaveHandler;
import net.gegy1000.earth.server.world.compatibility.ModGeneratorInvoker;
import net.gegy1000.earth.server.world.compatibility.hooks.DimensionManagerHooks;
import net.gegy1000.terrarium.Terrarium;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.FunctionManager;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class ColumnCompatibilityWorld
extends WorldServer
implements AutoCloseable {
    private static final WorldGenerator NOOP_GENERATOR = new WorldGenerator(){

        public boolean func_180709_b(World world, Random rand, BlockPos position) {
            return false;
        }
    };
    static final ThreadLocal<WorldServer> CONSTRUCTION_PARENT = new ThreadLocal();
    final WorldServer parent;
    final IChunkGenerator generator;
    ChunkPos columnPos;
    BlockPos columnDecoratePos;
    int minY;
    final BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
    private final Long2ObjectMap<TileEntity> accessedBlockEntities = new Long2ObjectOpenHashMap();
    private boolean tickWarning;

    private ColumnCompatibilityWorld(WorldServer parent) {
        super(parent.func_73046_m(), (ISaveHandler)new CompatibilitySaveHandler(parent), parent.func_72912_H(), parent.field_73011_w.getDimension(), parent.field_72984_F);
        this.parent = parent;
        this.generator = ColumnCompatibilityWorld.getChunkGenerator((World)parent);
        this.field_73020_y = this.func_72970_h();
        this.func_175643_b();
    }

    public static ColumnCompatibilityWorld create(WorldServer parent) {
        try {
            CONSTRUCTION_PARENT.set(parent);
            ColumnCompatibilityWorld columnCompatibilityWorld = new ColumnCompatibilityWorld(parent);
            return columnCompatibilityWorld;
        }
        finally {
            DimensionManagerHooks.restoreWorldMapping(parent);
            CONSTRUCTION_PARENT.remove();
        }
    }

    private static IChunkGenerator getChunkGenerator(World world) {
        IChunkProvider provider = world.func_72863_F();
        if (provider instanceof ChunkProviderServer) {
            return ((ChunkProviderServer)provider).field_186029_c;
        }
        return null;
    }

    public void func_72835_b() {
        DimensionManagerHooks.restoreWorldMapping(this.parent);
        if (this.tickWarning) {
            return;
        }
        this.tickWarning = true;
        Terrarium.LOGGER.error("Tried to tick Terrarium compatibility world implementation! Trying to reset Forge dimension list...", (Throwable)new IllegalAccessException());
    }

    public ColumnCompatibilityWorld setupAt(ChunkPos columnPos, int minY) {
        this.close();
        this.columnPos = columnPos;
        this.columnDecoratePos = new BlockPos(this.columnPos.func_180334_c(), 0, this.columnPos.func_180333_d());
        this.minY = minY;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public boolean fireDecorateEvent(Random random, DecorateBiomeEvent.Decorate.EventType type) {
        return TerrainGen.decorate((World)this, (Random)random, (ChunkPos)this.columnPos, (DecorateBiomeEvent.Decorate.EventType)type);
    }

    public boolean firePopulateEvent(Random random, boolean pre) {
        if (this.generator == null) {
            return false;
        }
        if (pre) {
            return MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(this.generator, (World)this, random, this.columnPos.field_77276_a, this.columnPos.field_77275_b, false));
        }
        return MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(this.generator, (World)this, random, this.columnPos.field_77276_a, this.columnPos.field_77275_b, false));
    }

    public boolean firePopulateEvent(Random random, PopulateChunkEvent.Populate.EventType type) {
        if (this.generator == null) {
            return false;
        }
        return TerrainGen.populate((IChunkGenerator)this.generator, (World)this, (Random)random, (int)this.columnPos.field_77276_a, (int)this.columnPos.field_77275_b, (boolean)false, (PopulateChunkEvent.Populate.EventType)type);
    }

    public boolean fireOreGenEvent(Random random, boolean pre) {
        if (pre) {
            return MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre((World)this, random, this.columnDecoratePos));
        }
        return MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post((World)this, random, this.columnDecoratePos));
    }

    public boolean fireOreGenEvent(Random random, OreGenEvent.GenerateMinable.EventType type) {
        return TerrainGen.generateOre((World)this, (Random)random, (WorldGenerator)NOOP_GENERATOR, (BlockPos)this.columnDecoratePos, (OreGenEvent.GenerateMinable.EventType)type);
    }

    public void runModdedGenerators() {
        if (this.generator == null) {
            return;
        }
        ChunkProviderServer chunkProvider = this.parent.func_72863_F();
        ModGeneratorInvoker.runGenerators((World)this, this.columnPos, this.generator, (IChunkProvider)chunkProvider);
    }

    public World func_175643_b() {
        this.field_72988_C = this.parent.func_175693_T();
        this.field_72982_D = this.parent.func_175714_ae();
        this.perWorldStorage = this.parent.getPerWorldStorage();
        this.field_96442_D = this.parent.func_96441_U();
        this.field_184151_B = this.parent.func_184146_ak();
        this.field_193036_D = this.parent.func_193037_A();
        this.field_191951_C = this.parent.func_191952_z();
        return this;
    }

    protected IChunkProvider func_72970_h() {
        return new CompatibilityChunkProvider(this);
    }

    public boolean func_175668_a(BlockPos pos, boolean allowEmpty) {
        return this.parent.func_175668_a(pos, allowEmpty);
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        this.mutablePos.func_181079_c(x << 4, this.minY, z << 4);
        return this.parent.func_175668_a((BlockPos)this.mutablePos, allowEmpty);
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (this.parent.func_180501_a(this.translatePos(pos), newState, flags)) {
            this.accessedBlockEntities.remove(pos.func_177986_g());
            return true;
        }
        return false;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.parent.func_180495_p(this.translatePos(pos));
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity entity) {
        this.accessedBlockEntities.remove(pos.func_177986_g());
        BlockPos worldPos = this.translatePos(pos);
        if (entity != null) {
            entity.func_145834_a((World)this.parent);
            entity.func_174878_a(worldPos);
            this.parent.func_175690_a(worldPos, entity);
        } else {
            this.parent.func_175690_a(worldPos, null);
        }
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        BlockPos worldPos = this.translatePos(pos);
        TileEntity worldEntity = this.parent.func_175625_s(worldPos);
        if (worldEntity == null) {
            return null;
        }
        TileEntity entity = (TileEntity)this.accessedBlockEntities.get(pos.func_177986_g());
        if (entity == null) {
            entity = this.createCompatibilityBlockEntity(pos, worldEntity);
            this.accessedBlockEntities.put(pos.func_177986_g(), (Object)entity);
        }
        return entity;
    }

    private TileEntity createCompatibilityBlockEntity(BlockPos pos, TileEntity worldEntity) {
        NBTTagCompound nbt = worldEntity.serializeNBT();
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        return TileEntity.func_190200_a((World)this, (NBTTagCompound)nbt);
    }

    public Biome getBiomeForCoordsBody(BlockPos pos) {
        return this.parent.func_180494_b(this.translatePos(pos));
    }

    public int func_189649_b(int x, int z) {
        return this.untranslateY(this.parent.func_189649_b(x, z));
    }

    public int func_72800_K() {
        return this.untranslateY(this.parent.func_72800_K());
    }

    public int func_72940_L() {
        return this.untranslateY(this.parent.func_72940_L());
    }

    public BlockPos func_175725_q(BlockPos pos) {
        BlockPos result = this.parent.func_175725_q(this.translatePos(pos));
        int y = this.untranslateY(result.func_177956_o());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public BlockPos func_175672_r(BlockPos pos) {
        BlockPos result = this.parent.func_175672_r(this.translatePos(pos));
        int y = this.untranslateY(result.func_177956_o());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }

    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        this.parent.func_175653_a(type, this.translatePos(pos), lightValue);
    }

    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        return this.parent.func_175642_b(type, this.translatePos(pos));
    }

    public float func_175724_o(BlockPos pos) {
        return this.parent.func_175724_o(this.translatePos(pos));
    }

    public int func_181545_F() {
        return this.untranslateY(this.parent.func_181545_F());
    }

    public boolean func_72838_d(Entity entity) {
        this.translateEntity(entity);
        return this.parent.func_72838_d(entity);
    }

    public void func_72923_a(Entity entity) {
        this.translateEntity(entity);
        this.parent.func_72923_a(entity);
    }

    public void func_72847_b(Entity entity) {
        this.parent.func_72847_b(entity);
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return this.parent.func_73045_a(id);
    }

    @Nullable
    public Entity func_175733_a(UUID uuid) {
        return this.parent.func_175733_a(uuid);
    }

    public void func_72954_a(IWorldEventListener listener) {
        this.parent.func_72954_a(listener);
        super.func_72954_a(listener);
    }

    public void func_72848_b(IWorldEventListener listener) {
        this.parent.func_72848_b(listener);
        super.func_72848_b(listener);
    }

    public List<AxisAlignedBB> func_184144_a(@Nullable Entity entity, AxisAlignedBB aabb) {
        aabb = aabb.func_72317_d(0.0, (double)this.minY, 0.0);
        return this.parent.func_184144_a(entity, aabb);
    }

    @Nullable
    public BlockPos func_180504_m() {
        BlockPos parent = this.parent.func_180504_m();
        if (parent == null) {
            return null;
        }
        return new BlockPos(parent.func_177958_n(), this.untranslateY(parent.func_177956_o()), parent.func_177952_p());
    }

    @Nullable
    public BlockPos func_190528_a(String name, BlockPos origin, boolean findUnexplored) {
        BlockPos parent = this.parent.func_190528_a(name, origin, findUnexplored);
        if (parent == null) {
            return null;
        }
        return new BlockPos(parent.func_177958_n(), this.untranslateY(parent.func_177956_o()), parent.func_177952_p());
    }

    public CompatibilityChunkProvider getChunkProvider() {
        return (CompatibilityChunkProvider)super.func_72863_F();
    }

    public VillageCollection func_175714_ae() {
        return this.parent.func_175714_ae();
    }

    public BiomeProvider func_72959_q() {
        return this.parent.func_72959_q();
    }

    public BlockPos func_175694_M() {
        return this.parent.func_175694_M();
    }

    public EnumDifficulty func_175659_aa() {
        return this.parent.func_175659_aa();
    }

    public GameRules func_82736_K() {
        return this.parent.func_82736_K();
    }

    public LootTableManager func_184146_ak() {
        return this.parent.func_184146_ak();
    }

    public ISaveHandler func_72860_G() {
        return this.parent.func_72860_G();
    }

    @Nullable
    public MapStorage func_175693_T() {
        return this.parent.func_175693_T();
    }

    public TemplateManager func_184163_y() {
        return this.parent.func_184163_y();
    }

    public EntityTracker func_73039_n() {
        return this.parent.func_73039_n();
    }

    public MapStorage getPerWorldStorage() {
        return this.parent.getPerWorldStorage();
    }

    public PlayerChunkMap func_184164_w() {
        return this.parent.func_184164_w();
    }

    public Teleporter func_85176_s() {
        return this.parent.func_85176_s();
    }

    public AdvancementManager func_191952_z() {
        return this.parent.func_191952_z();
    }

    public FunctionManager func_193037_A() {
        return this.parent.func_193037_A();
    }

    public File getChunkSaveLocation() {
        if (this.parent == null) {
            return CONSTRUCTION_PARENT.get().getChunkSaveLocation();
        }
        return this.parent.getChunkSaveLocation();
    }

    public void func_73044_a(boolean all, @Nullable IProgressUpdate callback) {
    }

    public void func_104140_m() {
    }

    public void func_73041_k() {
    }

    protected void func_73042_a() {
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.parent.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)this.parent.getCapability(capability, facing);
    }

    @Override
    public void close() {
        this.getChunkProvider().clear();
        for (TileEntity entity : this.accessedBlockEntities.values()) {
            this.updateAccessedBlockEntity(entity);
        }
        this.accessedBlockEntities.clear();
    }

    private void updateAccessedBlockEntity(TileEntity entity) {
        BlockPos worldPos = this.translatePos(entity.func_174877_v());
        entity.func_145834_a((World)this.parent);
        entity.func_174878_a(worldPos);
        this.parent.func_175690_a(worldPos, entity);
    }

    BlockPos translatePos(BlockPos pos) {
        this.mutablePos.func_189533_g((Vec3i)pos);
        this.mutablePos.func_185336_p(pos.func_177956_o() + this.minY);
        return this.mutablePos;
    }

    int untranslateY(int y) {
        return MathHelper.func_76125_a((int)(y - this.minY), (int)0, (int)255);
    }

    void translateEntity(Entity entity) {
        if (entity.field_70170_p != this.parent) {
            entity.func_70029_a((World)this.parent);
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + (double)this.minY, entity.field_70161_v);
        }
    }
}

