/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.util.zoom;

import java.util.function.IntFunction;
import java.util.stream.IntStream;
import net.gegy1000.earth.server.util.zoom.Zoomable;

public final class ZoomLevels {
    public final int min;
    public final int max;

    private ZoomLevels(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public IntStream stream() {
        return IntStream.range(this.min, this.max + 1);
    }

    public boolean contains(int zoom) {
        return zoom >= this.min && zoom <= this.max;
    }

    public static ZoomLevels range(int minInclusive, int maxInclusive) {
        return new ZoomLevels(minInclusive, maxInclusive);
    }

    public <T> Zoomable<T> map(IntFunction<T> function) {
        return Zoomable.create(this, function);
    }
}

