/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.message;

import io.netty.buffer.ByteBuf;
import net.gegy1000.earth.server.world.data.DataPreloader;
import net.gegy1000.terrarium.Terrarium;
import net.gegy1000.terrarium.server.capability.TerrariumWorld;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public final class OpenDownloadMessage
implements IMessage {
    private ChunkPos min;
    private ChunkPos max;

    public OpenDownloadMessage() {
    }

    public OpenDownloadMessage(ChunkPos min, ChunkPos max) {
        this.min = min;
        this.max = max;
    }

    public void fromBytes(ByteBuf buf) {
        this.min = new ChunkPos(buf.readInt(), buf.readInt());
        this.max = new ChunkPos(buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.min.field_77276_a);
        buf.writeInt(this.min.field_77275_b);
        buf.writeInt(this.max.field_77276_a);
        buf.writeInt(this.max.field_77275_b);
    }

    public static class Handler
    implements IMessageHandler<OpenDownloadMessage, IMessage> {
        public IMessage onMessage(OpenDownloadMessage message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                Terrarium.PROXY.scheduleTask(ctx, () -> {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    if (!DataPreloader.checkPermission(player)) {
                        return;
                    }
                    World world = player.field_70170_p;
                    TerrariumWorld terrarium = TerrariumWorld.get(world);
                    if (terrarium != null) {
                        DataPreloader preloader = DataPreloader.open(terrarium, message.min, message.max);
                        preloader.addWatcher(player);
                        DataPreloader.start(preloader);
                    }
                });
            }
            return null;
        }
    }
}

